//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/DbClass.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: DbClass.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;


/**
 *	Class Description:
 *	This class manage database connection for Tango Class.
 *
 * @author  verdier
 * @Revision 
 */


public class DbClass
{
	/**
	 *	Database object used for TANGO databse access.
	 */
	private Database	dbase;

	/**
	 *	Device name used to access database if device not exported.
	 */
	private String classname;

	//===================================================================
	/**
	 *	DbClass constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	classname		Name of the class oject.
	 */
	//===================================================================
	public DbClass(String classname) throws DevFailed
	{
		//	Access the database and get device server info
		//--------------------------------------------------
		dbase = ApiUtil.get_db_obj();
		this.classname = new String(classname);
	}

	//===================================================================
	/**
	 *	DbClass constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	classname		Name of the class oject.
	 *	@param	host	host where database is running.
	 *	@param	port	port for database connection.
	 */
	//===================================================================
	public DbClass(String classname, String host, String port) throws DevFailed
	{
		//	Access the database and get device server info
		//--------------------------------------------------
		dbase = ApiUtil.get_db_obj(host, port);
		this.classname = new String(classname);
	}


	//==========================================================================
	/**
	 *	Query the database for a list of class
	 *	properties for the pecified object.
	 *	@param wildcard	propertie's wildcard (* matches any charactere).
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public String[] get_property_list(String wildcard)
				throws DevFailed
	{
		return dbase.get_class_property_list(classname, wildcard);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of properties for this class.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(String[] propnames)
				throws DevFailed
	{
		return dbase.get_class_property(classname, propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for a property for this class.
	 *	@param propname		property name.
	 *	@retun properties in DbDatum object.
	 */
	//==========================================================================
	public DbDatum get_property(String propname)
				throws DevFailed
	{
		return dbase.get_class_property(classname, propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of properties for this class.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(DbDatum[] properties)
				throws DevFailed
	{
		return dbase.get_class_property(classname, properties);
	}

	//==========================================================================
	/**
	 *	Insert or update a list of properties for this class
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.put_class_property(classname, properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this class.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_property(String[] propnames)
				throws DevFailed
	{
		dbase.delete_class_property(classname, propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this class.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_property(String propname)
				throws DevFailed
	{
		dbase.delete_class_property(classname, propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this class.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.delete_class_property(classname, properties);
	}


	//==========================================================================
	/**
	 *	Insert or update a list of properties for this class attribute.
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_attibute_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.put_class_attribute_property(classname, properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_attribute_property(String[] propnames)
				throws DevFailed
	{
		dbase.delete_class_attribute_property(classname, propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this object.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_attribute_property(String propname)
				throws DevFailed
	{
		dbase.delete_class_attribute_property(classname, propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.delete_class_attribute_property(classname, properties);
	}

	//==========================================================================
	/**
	 *	Query the database for a list of class attribute
	 *	properties for this device.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(String[] propnames)
				throws DevFailed
	{
		return dbase.get_class_attribute_property(classname, propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for of class attribute
	 *	property for this device.
	 *	@param propname property name.
	 *	@retun property in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum get_attribute_property(String propname)
				throws DevFailed
	{
		return dbase.get_class_attribute_property(classname, propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of class attribute
	 *	properties for this device.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		return dbase.get_class_attribute_property(classname, properties);
	}



	//===========================================================
	/**
	 *	return the class name.
	 */
	//===========================================================
	public String name()
	{
		return classname;
	}
}
