//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/ApiUtil.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: ApiUtil.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import java.io.*;
import java.util.*;


/**
 *	Class Description:
 *	This class manage a static vector of Database object.
 *
 * @author  verdier
 * @Revision 
 */

public class ApiUtil
{
	static private Vector	db_list = null;
	static private Database	default_dbase = null;
	/**
	 * 	ORB object reference for connection.
	 */
	static protected ORB	orb = null;
	

	public ApiUtil() throws DevFailed
	{
	}

	//===================================================================
	/**
	 *	Return the database object created
	 *	with TANGO_HOST environment variable .
	 */
	//===================================================================
	public static Database get_db_obj() throws DevFailed
	{
		if (orb==null)
			create_orb();

		//	If first time, create Database object
		//---------------------------------------------------------------
		if (default_dbase==null)
			default_dbase = new Database();

		return default_dbase;
	}
	//===================================================================
	/**
	 *	Return the database object created for specified host and port.
	 *	
	 *	@param	host	host where database is running.
	 *	@param	port	port for database connection.
	 */
	//===================================================================
	public static Database get_db_obj(String host, String port) throws DevFailed
	{
		if (orb==null)
			create_orb();

		//	If first time, create vector
		//---------------------------------------------------------------
		if (db_list==null)
			db_list = new Vector();

		//	Build tango_host string
		//---------------------------
		String tango_host = new String(host + ":" + port);

		//	Search if database object already created for this host and port
		//-------------------------------------------------------------------
		if (default_dbase!=null)
			if (default_dbase.get_tango_host().equals(tango_host))
				return default_dbase;

		for (int i=0 ; i<db_list.size() ; i++)
		{
			Database dbase = (Database) db_list.elementAt(i);
			if (dbase.get_tango_host().equals(tango_host))
				return (Database) db_list.elementAt(i);
		}

		//	Else, create a new database object
		//---------------------------------------
		Database dbase = new Database(host, port);
		db_list.addElement(dbase);
		return dbase;
	}
	//===================================================================
	/**
	 *	Create the orb object
	 */
	//===================================================================
	private static void create_orb() throws DevFailed
	{
			try
			{
				//	Modified properties fo ORB usage.
				//	Requiered for JDK 1.2 and later.
				//---------------------------------------
				Properties props = System.getProperties();
				props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
				props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
				System.setProperties(props);

				//	Initialize ORB
				//-----------------------------
				String[] args = new String[1];
				args[0] = new String("pascal");
				orb = ORB.init(args, props);
			}
			catch(SystemException ex)
			{
				orb = null;
				Except.throw_exception( ex.toString(),
						"DbGet: ORB failed !", "ApiUtilcreate_orb()");
			}
	}
	//===================================================================
	/**
	 *	Return the orb object
	 */
	//===================================================================
	public static ORB get_orb() throws DevFailed
	{
		if (orb==null)
			create_orb();
		return orb;
	}
}
