/*
 * Decompiled with CFR 0.152.
 */
package TangoDs;

import Tango.DevError;
import Tango.DevFailed;
import Tango.DevVarLongStringArray;
import Tango.DevVarLongStringArrayHelper;
import Tango.Device;
import Tango.DeviceHelper;
import Tango.ErrFacility;
import Tango.ErrSeverity;
import TangoDs.DServer;
import TangoDs.DServerClass;
import TangoDs.DeviceClass;
import TangoDs.DeviceImpl;
import TangoDs.TangoConst;
import TangoDs.TangoUtilPrint;
import com.ooc.CORBA.ORB;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BOA;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;

public class TangoUtil
implements TangoConst {
    private static TangoUtil _instance = null;
    private String ds_exec_name;
    private String ds_instance_name;
    private StringBuffer ds_name;
    static int _tracelevel;
    public static TangoUtilPrint out1;
    public static TangoUtilPrint out2;
    public static TangoUtilPrint out3;
    public static TangoUtilPrint out4;
    static boolean _UseDb;
    private String db_host;
    private int db_port;
    private Device db_device;
    private String hostname;
    private String version_str;
    private int pid;
    private String pid_str;
    private org.omg.CORBA.ORB orb;
    private BOA boa;
    private String trace_output;
    private PrintStream out_tmp;
    private PrintStream file_stream;

    public static TangoUtil instance() {
        if (_instance == null) {
            System.err.println("TangoUtil is not initialised !!!");
            System.err.println("Exiting");
            System.exit(-1);
        }
        return _instance;
    }

    public static TangoUtil init(String[] stringArray, String string) {
        if (_instance == null) {
            _instance = new TangoUtil(stringArray, string);
        }
        return _instance;
    }

    protected TangoUtil(String[] stringArray, String string) {
        this.ds_exec_name = string;
        if (stringArray.length < 1) {
            this.print_usage();
            System.exit(-1);
        }
        this.check_args(stringArray);
        out1 = new TangoUtilPrint(1);
        out2 = new TangoUtilPrint(2);
        out3 = new TangoUtilPrint(3);
        out4 = new TangoUtilPrint(4);
        if (_UseDb) {
            this.read_env();
        }
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        ((Hashtable)properties).put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        System.setProperties(properties);
        this.orb = org.omg.CORBA.ORB.init((String[])stringArray, (Properties)properties);
        this.boa = ((ORB)this.orb).BOA_init(stringArray, properties);
        this.trace_output = "Initial Output";
        this.out_tmp = System.out;
        if (_UseDb) {
            this.connect_db();
            this.server_already_running();
        }
        this.misc_init();
        out4.println("TangoUtil object singleton constructed");
    }

    private void check_args(String[] stringArray) {
        if (stringArray[0].charAt(0) == '-') {
            this.print_usage();
            System.exit(-1);
        }
        this.ds_instance_name = stringArray[0];
        if (stringArray.length > 1) {
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].charAt(0) == '-') {
                    switch (stringArray[n].charAt(1)) {
                        case 'v': {
                            if (stringArray[n].length() == 2) {
                                if (stringArray.length - 1 > n) {
                                    if (stringArray[n + 1].charAt(0) == '-') {
                                        this.set_trace_level(4);
                                    } else {
                                        this.print_usage();
                                        System.exit(-1);
                                    }
                                } else {
                                    this.set_trace_level(4);
                                }
                                ++n;
                                break;
                            }
                            String string = stringArray[n].substring(2);
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.print_usage();
                                System.exit(-1);
                            }
                            this.set_trace_level(n2);
                            ++n;
                            break;
                        }
                        default: {
                            ++n;
                            break;
                        }
                    }
                    continue;
                }
                if (stringArray[n - 1].substring(0, 2).equals("-v")) {
                    this.print_usage();
                    System.exit(-1);
                }
                ++n;
            }
        }
        this.ds_exec_name = this.ds_exec_name.toLowerCase();
        this.ds_instance_name = this.ds_instance_name.toLowerCase();
        this.ds_name = new StringBuffer(this.ds_exec_name);
        this.ds_name.append("/");
        this.ds_name.append(this.ds_instance_name);
        if (this.ds_name.length() > 255) {
            System.err.println("The device server name is too long! Max length is " + 255 + " characters.");
            System.exit(-1);
        }
    }

    private void print_usage() {
        System.err.println("usage : " + this.ds_exec_name + " instance_name [-v[trace level]]");
    }

    private void read_env() {
        String string;
        int n;
        String string2 = System.getProperty("TANGO_HOST");
        if (string2 == null) {
            System.err.println("TANGO_HOST system property not defined, exiting...");
            System.exit(-1);
        }
        if ((n = string2.indexOf(58)) == -1) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        this.db_host = string2.substring(0, n);
        if (this.db_host.length() == 0) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        if ((string = string2.substring(n + 1)).length() == 0) {
            System.err.println("Wrong syntax for TANGO_HOST system property");
            System.err.println("Syntax = <host>:<port>");
            System.exit(-1);
        }
        this.db_port = Integer.parseInt(string);
        out4.println("Db host = " + this.db_host + ", Db port = " + this.db_port);
    }

    private void misc_init() {
        this.pid = 0;
        this.pid_str = String.valueOf(this.pid);
        try {
            String string = InetAddress.getLocalHost().toString();
            int n = string.indexOf(47);
            String string2 = string.substring(0, n);
            n = string2.indexOf(46);
            this.hostname = n == -1 ? string2 : string2.substring(0, n);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Cant retrieve server host name");
            System.exit(1);
        }
        out4.println("Hostname = " + this.hostname);
        this.version_str = String.valueOf(1);
    }

    public void connect_db() {
        try {
            Object object = ((ORB)this.orb).get_inet_object(this.db_host, this.db_port, "database");
            if (object == null) {
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
            this.db_device = DeviceHelper.narrow(object);
            if (this.db_device == null) {
                System.err.println("Can't build connection to TANGO database server, exiting");
                System.err.println("DB server host = " + this.db_host);
                System.exit(-1);
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.err.println("Can't build connection to TANGO database server, exiting");
            System.err.println("DB server host = " + this.db_host);
            System.err.println(cOMM_FAILURE.getMessage());
            cOMM_FAILURE.printStackTrace();
            System.exit(-1);
        }
        out4.println("Connected to database");
    }

    private void server_already_running() {
        java.lang.Object object;
        out4.println("Entering Tango::server_already_running method");
        StringBuffer stringBuffer = new StringBuffer("dserver");
        stringBuffer.append('/');
        stringBuffer.append((java.lang.Object)this.ds_name);
        String string = new String(stringBuffer);
        Device device = null;
        try {
            object = this.orb.create_any();
            object.insert_string(string);
            Any any = this.db_device.command_inout(new String("DbImportDevice"), (Any)object);
            DevVarLongStringArray devVarLongStringArray = DevVarLongStringArrayHelper.extract(any);
            if (devVarLongStringArray.lvalue[0] == 0) {
                out4.println("Leaving Tango::server_already_running method");
                return;
            }
            Object object2 = this.orb.string_to_object(devVarLongStringArray.svalue[1]);
            device = DeviceHelper.narrow(object2);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].facility.value() == 3 && devFailed.errors[0].code == 1) {
                System.err.println("This device server is not defined in database. Exiting!");
                System.exit(-1);
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            System.err.println("Can't pack/unpack data sent to/from database in/to Any object");
            System.exit(-1);
        }
        catch (TRANSIENT tRANSIENT) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        if (device == null) {
            out4.println("Leaving Tango::server_already_running method");
            return;
        }
        try {
            object = device.name();
            if (((String)object).equals(string)) {
                System.err.println("This server is already running, exiting!");
                System.exit(-1);
            }
        }
        catch (SystemException systemException) {}
        out4.println("Leaving Tango::server_already_running method");
    }

    public void server_init() throws DevFailed {
        DServerClass.init();
    }

    public Vector get_device_list_by_class(String string) throws DevFailed {
        DServer dServer = this.get_dserver_device();
        Vector vector = dServer.get_class_list();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DeviceClass)vector.elementAt(n2)).get_name().equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            StringBuffer stringBuffer = new StringBuffer("Class ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            TangoUtil.throw_exception(new String(stringBuffer), new String("TangoUtil::get_device_list_by_class()"), 11, ErrFacility.APILIB);
        }
        return ((DeviceClass)vector.elementAt(n2)).get_device_list();
    }

    public DeviceImpl get_device_by_name(String string) throws DevFailed {
        DServer dServer = this.get_dserver_device();
        Vector vector = dServer.get_class_list();
        Vector vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(0)).get_name());
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n4 = 0;
        while (n4 < n) {
            vector2 = this.get_device_list_by_class(((DeviceClass)vector.elementAt(n4)).get_name());
            n2 = vector2.size();
            n3 = 0;
            while (n3 < n2) {
                if (((DeviceImpl)vector2.elementAt(n4)).get_name().equals(string)) break;
                ++n3;
            }
            ++n4;
        }
        if (n4 == n && n3 == n2) {
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            TangoUtil.throw_exception(new String(stringBuffer), new String("TangoUtil::get_device_by_name()"), 16, ErrFacility.APILIB);
        }
        return (DeviceImpl)vector2.elementAt(n3);
    }

    public DServer get_dserver_device() {
        return (DServer)DServerClass.instance().get_device_list().elementAt(0);
    }

    public void unregister_server() {
        out4.println("Entering Tango::unregister_server method");
        if (_UseDb) {
            try {
                Any any = this.orb.create_any();
                any.insert_string(new String(this.ds_name));
                this.db_device.command_inout(new String("DbUnExportServer"), any);
            }
            catch (SystemException systemException) {
                TangoUtil.print_exception((Exception)((java.lang.Object)systemException));
                System.exit(-1);
            }
            catch (UserException userException) {
                TangoUtil.print_exception((Exception)((java.lang.Object)userException));
                System.exit(-1);
            }
        }
        out4.println("Leaving Tango::unregister_server method");
    }

    public static void print_exception(Exception exception) {
        String string = exception.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
        String string2 = string.substring(n + 1);
        if (string2.equals("DevFailed")) {
            DevFailed devFailed = (DevFailed)((java.lang.Object)exception);
            int n2 = 0;
            while (n2 < devFailed.errors.length) {
                System.err.println("Tango exception");
                System.err.print("Severity = ");
                switch (devFailed.errors[n2].severity.value()) {
                    case 0: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 1: {
                        System.err.print("ERROR ");
                        break;
                    }
                    case 2: {
                        System.err.print("PANIC ");
                        break;
                    }
                    default: {
                        System.err.print("Unknown severity code");
                    }
                }
                System.err.print(", Facility = ");
                switch (devFailed.errors[n2].facility.value()) {
                    case 0: {
                        System.err.print("ONCRPC ");
                        break;
                    }
                    case 1: {
                        System.err.print("NETWORK ");
                        break;
                    }
                    case 2: {
                        System.err.print("APILIB ");
                        break;
                    }
                    case 3: {
                        System.err.print("DATABASE ");
                        break;
                    }
                    case 4: {
                        System.err.print("UNIX ");
                        break;
                    }
                    case 5: {
                        System.err.print("WINDOWS ");
                        break;
                    }
                    case 6: {
                        System.err.print("HARDWARE ");
                        break;
                    }
                    case 7: {
                        System.err.print("CORBA ");
                        break;
                    }
                    case 8: {
                        System.err.print("CONTROL ");
                        break;
                    }
                    case 9: {
                        System.err.print("DCOM ");
                        break;
                    }
                    case 10: {
                        System.err.print("MISC ");
                        break;
                    }
                    case 11: {
                        System.err.print("NONE !!!");
                        break;
                    }
                    default: {
                        System.err.print("Unknown facility code ");
                    }
                }
                System.err.println(", Error code = " + devFailed.errors[n2].code);
                System.err.println("Reason : " + devFailed.errors[n2].reason);
                System.err.println("Origin : " + devFailed.errors[n2].origin);
                exception.printStackTrace();
                ++n2;
            }
            return;
        }
        int n3 = string.lastIndexOf(46, n - 1);
        if (n3 == -1) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return;
        }
        String string3 = string.substring(n3 + 1, n);
        if (string3.equals("CORBA")) {
            SystemException systemException = (SystemException)((java.lang.Object)exception);
            System.err.println("CORBA system exception " + string2);
            System.err.println(exception.getMessage());
            System.err.print("Completed: ");
            switch (systemException.completed.value()) {
                case 0: {
                    System.err.println("yes");
                    break;
                }
                case 1: {
                    System.err.println("no");
                    break;
                }
                case 2: {
                    System.err.println("maybe");
                    break;
                }
            }
            System.err.println("Minor code: " + systemException.minor);
            exception.printStackTrace();
            return;
        }
        System.err.println(exception.getMessage());
        exception.printStackTrace();
    }

    public static void throw_exception(String string, String string2) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].code = -1;
        devErrorArray[0].severity = ErrSeverity.ERROR;
        devErrorArray[0].facility = ErrFacility.CONTROL;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string2;
        throw new DevFailed(devErrorArray);
    }

    public static void throw_exception(String string, String string2, int n) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].code = n;
        devErrorArray[0].severity = ErrSeverity.ERROR;
        devErrorArray[0].facility = ErrFacility.CONTROL;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string2;
        throw new DevFailed(devErrorArray);
    }

    public static void throw_exception(String string, String string2, int n, ErrFacility errFacility) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].code = n;
        devErrorArray[0].severity = ErrSeverity.ERROR;
        devErrorArray[0].facility = errFacility;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string2;
        throw new DevFailed(devErrorArray);
    }

    public static void throw_exception(String string, String string2, int n, ErrFacility errFacility, ErrSeverity errSeverity) throws DevFailed {
        DevError[] devErrorArray = new DevError[]{new DevError()};
        devErrorArray[0].code = n;
        devErrorArray[0].severity = errSeverity;
        devErrorArray[0].facility = errFacility;
        devErrorArray[0].reason = string;
        devErrorArray[0].origin = string2;
        throw new DevFailed(devErrorArray);
    }

    public static Any return_empty_any(String string) throws DevFailed {
        Any any = null;
        try {
            any = TangoUtil.instance().get_orb().create_any();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(".execute");
            out3.println("Bad allocation while in " + string + ".execute()");
            TangoUtil.throw_exception(new String("Can't allocate memory in server"), new String(stringBuffer), 1, ErrFacility.APILIB);
        }
        out4.println("Leaving " + string + ".execute()");
        return any;
    }

    public void set_trace_level(int n) {
        _tracelevel = n;
    }

    public int get_trace_level() {
        return _tracelevel;
    }

    public String get_trace_output() {
        return this.trace_output;
    }

    public void set_trace_output(String string) {
        this.trace_output = string;
    }

    public String get_ds_inst_name() {
        return this.ds_instance_name;
    }

    public String get_ds_exec_name() {
        return this.ds_exec_name;
    }

    public String get_ds_name() {
        return new String(this.ds_name);
    }

    public String get_host_name() {
        return this.hostname;
    }

    public String get_version_str() {
        return this.version_str;
    }

    public Device get_db_device() {
        return this.db_device;
    }

    public PrintStream get_out() {
        return this.out_tmp;
    }

    public void set_trace_output_stream(PrintStream printStream) {
        this.file_stream = printStream;
    }

    public PrintStream get_trace_output_stream() {
        return this.file_stream;
    }

    public org.omg.CORBA.ORB get_orb() {
        return this.orb;
    }

    public BOA get_boa() {
        return this.boa;
    }

    public String get_pid_str() {
        return this.pid_str;
    }

    static {
        _UseDb = true;
    }
}

