/*
 * Decompiled with CFR 0.152.
 */
package TangoDs;

import Tango.AttributeConfig;
import Tango.AttributeValue;
import Tango.DevCmdInfo;
import Tango.DevFailed;
import Tango.DevInfo;
import Tango.DevState;
import Tango.DevVarDoubleArrayHelper;
import Tango.DevVarLongArrayHelper;
import Tango.DevVarShortArrayHelper;
import Tango.DevVarStringArrayHelper;
import Tango.ErrFacility;
import Tango._DeviceImplBase;
import TangoDs.Attribute;
import TangoDs.BlackBox;
import TangoDs.Command;
import TangoDs.DeviceClass;
import TangoDs.MultiAttribute;
import TangoDs.TangoConst;
import TangoDs.TangoUtil;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;

public abstract class DeviceImpl
extends _DeviceImplBase
implements TangoConst {
    protected BlackBox blackbox;
    protected int blackbox_depth;
    protected String dev_name;
    protected String desc;
    protected String dev_status;
    protected String init_status;
    protected DevState dev_state;
    protected DevState init_state;
    protected byte[] access;
    protected int version;
    protected DeviceClass device_class;
    protected MultiAttribute dev_attr;

    public DeviceImpl(DeviceClass deviceClass, String string, String string2, DevState devState, String string3) throws DevFailed {
        this.device_class = deviceClass;
        this.dev_name = string;
        this.desc = string2;
        this.dev_state = devState;
        this.dev_status = string3;
        this.init_state = devState;
        this.init_status = string3;
        this.version = 1;
        this.blackbox_depth = 0;
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.dev_name, this.device_class);
    }

    public DeviceImpl(DeviceClass deviceClass, String string) throws DevFailed {
        this.device_class = deviceClass;
        this.dev_name = string;
        this.desc = new String("A Tango device");
        this.dev_state = DevState.UNKNOWN;
        this.dev_status = new String("Not Initialised");
        this.init_state = this.dev_state;
        this.init_status = this.dev_status;
        this.version = 1;
        this.blackbox_depth = 0;
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.dev_name, this.device_class);
    }

    public DeviceImpl(DeviceClass deviceClass, String string, String string2) throws DevFailed {
        this.device_class = deviceClass;
        this.dev_name = string;
        this.desc = string2;
        this.dev_state = DevState.UNKNOWN;
        this.dev_status = new String("Not Initialised");
        this.init_state = this.dev_state;
        this.init_status = this.dev_status;
        this.version = 1;
        this.blackbox_depth = 0;
        this.get_dev_system_resource();
        this.black_box_create();
        this.dev_attr = new MultiAttribute(this.dev_name, this.device_class);
    }

    private void black_box_create() {
        if (this.blackbox_depth == 0) {
            this.blackbox = new BlackBox();
            return;
        }
        this.blackbox = new BlackBox(this.blackbox_depth);
    }

    private void get_dev_system_resource() {
        TangoUtil tangoUtil = TangoUtil.instance();
        if (TangoUtil._UseDb) {
            try {
                Any any = tangoUtil.get_orb().create_any();
                String[] stringArray = new String[]{this.dev_name, new String("blackbox_depth"), new String("description")};
                DevVarStringArrayHelper.insert(any, stringArray);
                Any any2 = tangoUtil.get_db_device().command_inout(new String("DbGetDeviceProperty"), any);
                String[] stringArray2 = DevVarStringArrayHelper.extract(any2);
                if (!stringArray2[3].equals("0")) {
                    Integer.parseInt(stringArray2[4]);
                }
                if (!stringArray2[6].equals("0")) {
                    this.desc = stringArray2[7];
                    return;
                }
            }
            catch (DevFailed devFailed) {
                return;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                return;
            }
        }
    }

    public Any command_inout(String string, Any any) throws DevFailed {
        TangoUtil.out4.println("DeviceImpl.command_inout(): command received : " + string);
        this.blackbox.insert_cmd(string);
        Any any2 = this.device_class.command_handler(this, string, any);
        TangoUtil.out4.println("DeviceImpl.command_inout(): leaving method for command " + string);
        return any2;
    }

    public String name() {
        TangoUtil.out4.println("DeviceImpl.name() arrived");
        this.blackbox.insert_attr(1);
        TangoUtil.out4.println("Leaving DeviceImpl.name()");
        return this.dev_name;
    }

    public String description() {
        TangoUtil.out4.println("DeviceImpl.description() arrived");
        this.blackbox.insert_attr(2);
        TangoUtil.out4.println("Leaving DeviceImpl.description()");
        return this.desc;
    }

    public DevState state() {
        TangoUtil.out4.println("DeviceImpl.state() (attibute) arrived");
        this.blackbox.insert_attr(3);
        DevState devState = null;
        try {
            devState = this.state_cmd();
        }
        catch (DevFailed devFailed) {}
        TangoUtil.out4.println("Leaving DeviceImpl.state() (attribute)");
        return devState;
    }

    public String status() {
        TangoUtil.out4.println("DeviceImpl.status() (attibute) arrived");
        this.blackbox.insert_attr(4);
        String string = null;
        try {
            string = this.status_cmd();
        }
        catch (DevFailed devFailed) {}
        TangoUtil.out4.println("Leaving DeviceImpl.status() (attribute)");
        return string;
    }

    public String[] black_box(int n) throws DevFailed {
        TangoUtil.out4.println("DeviceImpl.black_box() arrived");
        String[] stringArray = this.blackbox.read(n);
        this.blackbox.insert_op(2);
        TangoUtil.out4.println("Leaving DeviceImpl.black_box()");
        return stringArray;
    }

    public DevCmdInfo[] command_list_query() {
        TangoUtil.out4.println("DeviceImpl.command_list_query() arrived");
        int n = this.device_class.get_command_list().size();
        TangoUtil.out4.println(String.valueOf(n) + " command(s) for device");
        DevCmdInfo[] devCmdInfoArray = new DevCmdInfo[n];
        int n2 = 0;
        while (n2 < n) {
            devCmdInfoArray[n2] = new DevCmdInfo();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            devCmdInfoArray[n3].cmd_name = ((Command)this.device_class.get_command_list().elementAt(n3)).get_name();
            devCmdInfoArray[n3].cmd_tag = 0;
            devCmdInfoArray[n3].in_type = ((Command)this.device_class.get_command_list().elementAt(n3)).get_in_type();
            devCmdInfoArray[n3].out_type = ((Command)this.device_class.get_command_list().elementAt(n3)).get_out_type();
            String string = ((Command)this.device_class.get_command_list().elementAt(n3)).get_in_type_desc();
            devCmdInfoArray[n3].in_type_desc = string == null ? "Uninitialised" : string;
            string = ((Command)this.device_class.get_command_list().elementAt(n3)).get_out_type_desc();
            devCmdInfoArray[n3].out_type_desc = string == null ? "Uninitialised" : string;
            ++n3;
        }
        this.blackbox.insert_op(5);
        TangoUtil.out4.println("Leaving DeviceImpl.command_list_query()");
        return devCmdInfoArray;
    }

    public DevCmdInfo command_query(String string) throws DevFailed {
        CharSequence charSequence;
        TangoUtil.out4.println("DeviceImpl.command_query() arrived");
        DevCmdInfo devCmdInfo = new DevCmdInfo();
        int n = this.device_class.get_command_list().size();
        int n2 = 0;
        while (n2 < n) {
            if (((Command)this.device_class.get_command_list().elementAt(n2)).get_name().equals(string)) {
                devCmdInfo.cmd_name = string;
                devCmdInfo.cmd_tag = 0;
                devCmdInfo.in_type = ((Command)this.device_class.get_command_list().elementAt(n2)).get_in_type();
                devCmdInfo.out_type = ((Command)this.device_class.get_command_list().elementAt(n2)).get_out_type();
                charSequence = ((Command)this.device_class.get_command_list().elementAt(n2)).get_in_type_desc();
                devCmdInfo.in_type_desc = charSequence == null ? "Uninitialised" : charSequence;
                charSequence = ((Command)this.device_class.get_command_list().elementAt(n2)).get_out_type_desc();
                if (charSequence == null) {
                    devCmdInfo.out_type_desc = "Uninitialised";
                    break;
                }
                devCmdInfo.out_type_desc = charSequence;
                break;
            }
            ++n2;
        }
        if (n2 == n) {
            TangoUtil.out3.println("DeviceImpl.command_query(): operation " + string + " not found");
            charSequence = new StringBuffer("Command ");
            charSequence.append(string);
            charSequence.append(" not found");
            TangoUtil.throw_exception(new String((StringBuffer)charSequence), new String("DeviceImpl.command_query()"), 2, ErrFacility.APILIB);
        }
        this.blackbox.insert_op(6);
        TangoUtil.out4.println("Leaving DeviceImpl.command_query()");
        return devCmdInfo;
    }

    public DevInfo info() {
        TangoUtil.out4.println("DeviceImpl.info() arrived");
        DevInfo devInfo = new DevInfo();
        TangoUtil tangoUtil = TangoUtil.instance();
        devInfo.server_host = tangoUtil.get_host_name();
        devInfo.dev_class = this.device_class.get_name();
        devInfo.server_id = tangoUtil.get_ds_name();
        devInfo.server_version = 1;
        devInfo.doc_url = this.device_class.get_doc_url();
        this.blackbox.insert_op(4);
        TangoUtil.out4.println("Leaving DeviceImpl.info()");
        return devInfo;
    }

    public void ping() {
        TangoUtil.out4.println("DeviceImpl.ping() arrived");
        this.blackbox.insert_op(3);
        TangoUtil.out4.println("Leaving DeviceImpl.ping()");
    }

    public AttributeConfig[] get_attribute_config(String[] stringArray) throws DevFailed {
        int n;
        TangoUtil.out4.println("DeviceImpl::get_attribute_config arrived");
        int n2 = stringArray.length;
        boolean bl = false;
        this.blackbox.insert_op(7);
        int n3 = this.dev_attr.get_attr_nb();
        if (n3 == 0) {
            TangoUtil.throw_exception("The device does not have any attribute", "DeviceImpl.get_attribute_config", 23, ErrFacility.APILIB);
        }
        if (n2 == 1 && stringArray[0].equals("All attributes")) {
            n2 = n3;
            bl = true;
        }
        AttributeConfig[] attributeConfigArray = null;
        try {
            attributeConfigArray = new AttributeConfig[n2];
            n = 0;
            while (n < n2) {
                attributeConfigArray[n] = new AttributeConfig();
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            TangoUtil.out3.println("Bad allocation while in DeviceImpl.get_attribute_config");
            TangoUtil.throw_exception("Can't allocate memory in server", "DeviceImpl.get_attribute_config", 1, ErrFacility.APILIB);
        }
        n = 0;
        while (n < n2) {
            Attribute attribute;
            if (bl) {
                attribute = this.dev_attr.get_attr_by_ind(n);
                attribute.get_properties(attributeConfigArray[n]);
            } else {
                attribute = this.dev_attr.get_attr_by_name(stringArray[n]);
                attribute.get_properties(attributeConfigArray[n]);
            }
            ++n;
        }
        TangoUtil.out4.println("Leaving DeviceImpl.get_attribute_config");
        return attributeConfigArray;
    }

    /*
     * Unable to fully structure code
     */
    public void set_attribute_config(AttributeConfig[] var1_1) throws DevFailed {
        block10: {
            TangoUtil.out4.println("DeviceImpl.set_attribute_config arrived");
            this.blackbox.insert_op(8);
            var2_2 = this.dev_attr.get_attr_nb();
            if (var2_2 == 0) {
                TangoUtil.throw_exception("The device does not have any attribute", "DeviceImpl.set_attribute_config", 23, ErrFacility.APILIB);
            }
            var3_3 = var1_1.length;
            var4_4 = 0;
            try {
                var4_4 = 0;
                while (var4_4 < var3_3) {
                    var5_5 = this.dev_attr.get_attr_by_name(var1_1[var4_4].name);
                    var5_5.upd_database(var1_1[var4_4], this.dev_name);
                    var5_5.set_properties(var1_1[var4_4], this.dev_name);
                    ++var4_4;
                }
                break block10;
            }
            catch (DevFailed var5_6) {
                this.dev_attr.get_alarm_list().removeAllElements();
                var6_7 = 0;
                ** while (var6_7 < var2_2)
            }
lbl-1000:
            // 1 sources

            {
                if (this.dev_attr.get_attr_by_ind(var6_7).is_alarmed()) {
                    this.dev_attr.get_alarm_list().addElement(new Integer(var6_7));
                }
                ++var6_7;
                continue;
            }
lbl25:
            // 1 sources

            var7_8 = new StringBuffer(var5_6.errors[0].reason);
            if (var4_4 != 0) {
                var7_8.append("\nAll previous attribute(s) have been successfully updated");
            }
            if (var4_4 != var3_3 - 1) {
                var7_8.append("\nAll remaining attribute(s) have not been updated");
            }
            var5_6.errors[0].reason = var7_8.toString();
            throw var5_6;
        }
        this.dev_attr.get_alarm_list().removeAllElements();
        var4_4 = 0;
        while (var4_4 < var2_2) {
            if (this.dev_attr.get_attr_by_ind(var4_4).is_alarmed()) {
                this.dev_attr.get_alarm_list().addElement(new Integer(var4_4));
            }
            ++var4_4;
        }
        TangoUtil.out4.println("Leaving DeviceImpl.set_attribute_config");
    }

    public AttributeValue[] read_attributes(String[] stringArray) throws DevFailed {
        int n;
        TangoUtil.out4.println("DeviceImpl.read_attributes arrived");
        this.blackbox.insert_op(9);
        int n2 = this.dev_attr.get_attr_nb();
        if (n2 == 0) {
            TangoUtil.throw_exception("The device does not have any attribute", "DeviceImpl.read_attributes", 23, ErrFacility.APILIB);
        }
        int n3 = stringArray.length;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n4 = 0;
        n4 = 0;
        while (n4 < n3) {
            n = this.dev_attr.get_attr_ind_by_name(stringArray[n4]);
            if (this.dev_attr.get_attr_by_ind(n).is_writable()) {
                vector2.addElement(new Integer(n));
            } else {
                vector.addElement(new Integer(n));
                this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n4)).set_value_flag(false);
            }
            ++n4;
        }
        n = vector.size();
        int n5 = vector2.size();
        if (n != 0) {
            this.read_attr_hardware(vector);
        }
        n4 = 0;
        while (n4 < n) {
            this.read_attr(this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n4)));
            ++n4;
        }
        n4 = 0;
        while (n4 < n5) {
            this.dev_attr.get_attr_by_ind((Integer)vector2.elementAt(n4)).set_value();
            ++n4;
        }
        AttributeValue[] attributeValueArray = null;
        try {
            attributeValueArray = new AttributeValue[n3];
            n4 = 0;
            while (n4 < n3) {
                attributeValueArray[n4] = new AttributeValue();
                ++n4;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            TangoUtil.throw_exception("Can't allocate memory in server", "DeviceImpl.read_attributes", 1, ErrFacility.APILIB);
        }
        n4 = 0;
        while (n4 < n3) {
            Object object;
            Attribute attribute = this.dev_attr.get_attr_by_name(stringArray[n4]);
            if (!attribute.get_value_flag()) {
                object = new StringBuffer("Read value for attribute ");
                ((StringBuffer)object).append(attribute.get_name());
                ((StringBuffer)object).append(" has not been updated");
                TangoUtil.throw_exception(((StringBuffer)object).toString(), "DeviceImpl::read_attributes", 24, ErrFacility.APILIB);
            } else {
                if (!attribute.is_writable()) {
                    if (attribute.is_writ_associated()) {
                        this.dev_attr.add_write_value(attribute);
                    }
                    if (attribute.is_alarmed() && attribute.get_quality().value() != 1) {
                        attribute.check_alarm();
                    }
                }
                attributeValueArray[n4].time = attribute.get_when();
                attributeValueArray[n4].quality = attribute.get_quality();
                attributeValueArray[n4].name = attribute.get_name();
                object = TangoUtil.instance();
                attributeValueArray[n4].value = ((TangoUtil)object).get_orb().create_any();
                switch (attribute.get_data_type()) {
                    case 2: {
                        DevVarShortArrayHelper.insert(attributeValueArray[n4].value, attribute.get_short_value());
                        break;
                    }
                    case 3: {
                        DevVarLongArrayHelper.insert(attributeValueArray[n4].value, attribute.get_long_value());
                        break;
                    }
                    case 5: {
                        DevVarDoubleArrayHelper.insert(attributeValueArray[n4].value, attribute.get_double_value());
                        break;
                    }
                    case 8: {
                        DevVarStringArrayHelper.insert(attributeValueArray[n4].value, attribute.get_string_value());
                        break;
                    }
                }
            }
            ++n4;
        }
        TangoUtil.out4.println("Leaving DeviceImpl.read_attributes");
        return attributeValueArray;
    }

    /*
     * Unable to fully structure code
     */
    public void write_attributes(AttributeValue[] var1_1) throws DevFailed {
        TangoUtil.out4.println("DeviceImpl.write_attributes arrived");
        this.blackbox.insert_op(10);
        var2_2 = this.dev_attr.get_attr_nb();
        if (var2_2 == 0) {
            TangoUtil.throw_exception("The device does not have any attribute", "DeviceImpl.write_attributes", 23, ErrFacility.APILIB);
        }
        var3_3 = var1_1.length;
        var5_4 = new Vector<Integer>();
        var6_5 = 0;
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            var5_4.addElement(new Integer(this.dev_attr.get_attr_ind_by_name(var1_1[var6_5].name)));
            ++var6_5;
        }
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            if (!this.dev_attr.get_attr_by_ind((Integer)var5_4.elementAt(var6_5)).is_writable()) {
                var7_6 = new StringBuffer("Attribute ");
                var7_6.append(this.dev_attr.get_attr_by_ind((Integer)var5_4.elementAt(var6_5)).get_name());
                var7_6.append(" is not writable");
                TangoUtil.throw_exception(var7_6.toString(), "DeviceImpl.write_attributes", 26, ErrFacility.APILIB);
            }
            ++var6_5;
        }
        var6_5 = 0;
        while ((long)var6_5 < var3_3) {
            block8: {
                try {
                    this.dev_attr.get_w_attr_by_ind((Integer)var5_4.elementAt(var6_5)).set_write_value(var1_1[var6_5].value);
                    break block8;
                }
                catch (DevFailed var7_7) {
                    var8_8 = 0;
                    ** while (var8_8 < var6_5)
                }
lbl-1000:
                // 1 sources

                {
                    this.dev_attr.get_w_attr_by_ind((Integer)var5_4.elementAt(var8_8)).rollback();
                    ++var8_8;
                    continue;
                }
lbl36:
                // 1 sources

                throw var7_7;
            }
            ++var6_5;
        }
        this.write_attr_hardware(var5_4);
        TangoUtil.out4.println("Leaving DeviceImpl.write_attributes");
    }

    public DevState state_cmd() throws DevFailed {
        Vector vector;
        int n;
        if ((this.dev_state.value() == 0 || this.dev_state.value() == 11) && (n = (vector = this.dev_attr.get_alarm_list()).size()) != 0) {
            this.read_attr_hardware(vector);
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = this.dev_attr.get_attr_by_ind((Integer)vector.elementAt(n2));
                attribute.wanted_date(false);
                try {
                    this.read_attr(attribute);
                }
                catch (DevFailed devFailed) {
                    attribute.wanted_date(true);
                    throw devFailed;
                }
                attribute.wanted_date(true);
                ++n2;
            }
            if (this.dev_attr.check_alarm()) {
                this.dev_state = DevState.ALARM;
            }
        }
        return this.dev_state;
    }

    public String status_cmd() throws DevFailed {
        if (this.dev_state.value() == 11 || this.dev_state.value() == 0) {
            StringBuffer stringBuffer = new StringBuffer(this.dev_status);
            this.dev_attr.read_alarm(stringBuffer);
            return stringBuffer.toString();
        }
        return this.dev_status;
    }

    public void read_attr_hardware(Vector vector) throws DevFailed {
    }

    public void read_attr(Attribute attribute) throws DevFailed {
    }

    public void write_attr_hardware(Vector vector) throws DevFailed {
    }

    public void always_executed_hook() throws DevFailed {
    }

    public abstract void init_device() throws DevFailed;

    public String get_status() {
        return this.dev_status;
    }

    public void set_status(String string) {
        this.dev_status = string;
    }

    public DevState get_state() {
        return this.dev_state;
    }

    public void set_state(DevState devState) {
        this.dev_state = devState;
    }

    public DevState get_init_state() {
        return this.init_state;
    }

    public String get_init_status() {
        return this.init_status;
    }

    public String get_name() {
        return this.dev_name;
    }

    public DeviceClass get_device_class() {
        return this.device_class;
    }

    public void set_device_attr(MultiAttribute multiAttribute) {
        this.dev_attr = multiAttribute;
    }
}

