/*
 * Decompiled with CFR 0.152.
 */
package TangoDs;

import Tango.DevFailed;
import Tango.DevVarStringArrayHelper;
import Tango.ErrFacility;
import TangoDs.Command;
import TangoDs.DevRestartCmd;
import TangoDs.DevStateCmd;
import TangoDs.DevStatusCmd;
import TangoDs.DeviceImpl;
import TangoDs.MultiClassAttribute;
import TangoDs.TangoConst;
import TangoDs.TangoUtil;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public abstract class DeviceClass
implements TangoConst {
    protected String name;
    protected String doc_url;
    protected Vector command_list;
    protected Vector device_list;
    protected MultiClassAttribute class_attr;

    protected DeviceClass(String string) {
        this.name = string;
        this.command_list = new Vector();
        this.device_list = new Vector();
        this.command_list.addElement(new DevStatusCmd(new String("DevStatus"), 0, 8, new String("Device status")));
        this.command_list.addElement(new DevStateCmd(new String("DevState"), 0, 19, new String("Device state")));
        this.command_list.addElement(new DevRestartCmd(new String("DevRestart"), 0, 0));
        this.get_class_system_resource();
        this.class_attr = new MultiClassAttribute();
    }

    private void get_class_system_resource() {
        TangoUtil tangoUtil = TangoUtil.instance();
        if (TangoUtil._UseDb) {
            try {
                Any any = tangoUtil.get_orb().create_any();
                String[] stringArray = new String[]{new String(this.name), new String("doc_url")};
                DevVarStringArrayHelper.insert(any, stringArray);
                Any any2 = tangoUtil.get_db_device().command_inout(new String("DbGetClassProperty"), any);
                String[] stringArray2 = DevVarStringArrayHelper.extract(any2);
                if (stringArray2[3].equals("0")) {
                    TangoUtil.out4.println("doc_url property for class " + this.name + " is not defined in database");
                    this.doc_url = "http://www.ulla.com";
                    return;
                }
                this.doc_url = stringArray2[4];
                return;
            }
            catch (DevFailed devFailed) {
                this.doc_url = "http://www.ulla.com";
                return;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                this.doc_url = "http://www.ulla.com";
                return;
            }
        }
        this.doc_url = "http://www.ulla.com";
    }

    protected void export_device(DeviceImpl deviceImpl) throws DevFailed {
        TangoUtil.out4.println("DeviceClass::export_device() arrived");
        TangoUtil tangoUtil = TangoUtil.instance();
        ORB oRB = tangoUtil.get_orb();
        Any any = oRB.create_any();
        String[] stringArray = new String[]{deviceImpl.get_name(), oRB.object_to_string((Object)deviceImpl), tangoUtil.get_host_name(), tangoUtil.get_pid_str(), tangoUtil.get_version_str()};
        DevVarStringArrayHelper.insert(any, stringArray);
        tangoUtil.get_db_device().command_inout(new String("DbExportDevice"), any);
        TangoUtil.out4.println("Leaving DeviceClass::export_device method()");
    }

    public Any command_handler(DeviceImpl deviceImpl, String string, Any any) throws DevFailed {
        StringBuffer stringBuffer;
        Any any2 = TangoUtil.instance().get_orb().create_any();
        TangoUtil.out4.println("Entering DeviceClass::command_handler() method");
        int n = 0;
        while (n < this.command_list.size()) {
            if (((Command)this.command_list.elementAt(n)).get_name().equals(string)) {
                deviceImpl.always_executed_hook();
                if (!((Command)this.command_list.elementAt(n)).is_allowed(deviceImpl, any)) {
                    stringBuffer = new StringBuffer("Command ");
                    stringBuffer.append(string);
                    stringBuffer.append(" not allowed when the device is in ");
                    stringBuffer.append(TangoConst.Tango_DevStateName[deviceImpl.get_state().value()]);
                    stringBuffer.append(" state");
                    TangoUtil.throw_exception(new String(stringBuffer), new String("DeviceClass::command_handler"), 9, ErrFacility.APILIB);
                }
                any2 = ((Command)this.command_list.elementAt(n)).execute(deviceImpl, any);
                break;
            }
            ++n;
        }
        if (n == this.command_list.size()) {
            TangoUtil.out3.println("DeviceClass::command_handler(): command " + string + " not found");
            stringBuffer = new StringBuffer("Command ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            TangoUtil.throw_exception(new String(stringBuffer), new String("DeviceClass::command_handler"), 2, ErrFacility.APILIB);
        }
        TangoUtil.out4.println("Leaving DeviceClass::command_handler() method");
        return any2;
    }

    public abstract void command_factory();

    public void attribute_factory(Vector vector) {
    }

    public abstract void device_factory(String[] var1) throws DevFailed;

    public Vector get_command_list() {
        return this.command_list;
    }

    public Vector get_device_list() {
        return this.device_list;
    }

    public String get_name() {
        return this.name;
    }

    public String get_doc_url() {
        return this.doc_url;
    }

    public MultiClassAttribute get_class_attr() {
        return this.class_attr;
    }
}

