/*
 * Decompiled with CFR 0.152.
 */
package TangoDs;

import Tango.AttrDataFormat;
import Tango.AttrQuality;
import Tango.AttributeConfig;
import Tango.DevFailed;
import Tango.DevVarStringArrayHelper;
import Tango.ErrFacility;
import Tango.TimeVal;
import TangoDs.AttrProperty;
import TangoDs.TangoAttrCheckVal;
import TangoDs.TangoAttrValue;
import TangoDs.TangoConst;
import TangoDs.TangoUtil;
import java.util.Date;
import java.util.Vector;
import org.omg.CORBA.Any;

public class Attribute
implements TangoConst {
    protected String name;
    protected boolean writable;
    protected int data_type;
    protected AttrDataFormat data_format;
    protected int dim_x;
    protected int dim_y;
    protected String label;
    protected String description;
    protected String unit;
    protected String standard_unit;
    protected String display_unit;
    protected String format;
    protected String writable_attr_name;
    protected String min_alarm_str;
    protected String max_alarm_str;
    protected String min_value_str;
    protected String max_value_str;
    protected TangoAttrCheckVal min_alarm;
    protected TangoAttrCheckVal max_alarm;
    protected TangoAttrCheckVal min_value;
    protected TangoAttrCheckVal max_value;
    protected boolean check_min_alarm;
    protected boolean check_max_alarm;
    protected boolean check_min_value;
    protected boolean check_max_value;
    protected boolean min_alarm_on;
    protected boolean max_alarm_on;
    protected boolean date;
    protected int data_size;
    protected AttrQuality quality;
    protected TimeVal when;
    protected TangoAttrValue value;
    protected boolean value_flag;
    private short[] tmp_sh = new short[2];
    private int[] tmp_lo = new int[2];
    private double[] tmp_db = new double[2];
    private String[] tmp_str = new String[2];
    protected int assoc_ind;

    public Attribute(Vector vector, int n, String string) throws DevFailed {
        this.data_type = n;
        this.check_min_alarm = false;
        this.check_max_alarm = false;
        this.check_min_value = false;
        this.check_max_value = false;
        this.date = true;
        this.min_alarm = new TangoAttrCheckVal();
        this.max_alarm = new TangoAttrCheckVal();
        this.min_value = new TangoAttrCheckVal();
        this.max_value = new TangoAttrCheckVal();
        this.value = new TangoAttrValue();
        this.when = new TimeVal();
        this.quality = AttrQuality.ATTR_VALID;
        this.check_mandatory_prop(vector, string);
        this.init_opt_prop(vector, string);
        this.set_data_size();
    }

    private void check_mandatory_prop(Vector vector, String string) throws DevFailed {
        this.name = ((AttrProperty)vector.elementAt(0)).get_value();
        this.check_writable(vector, string);
        this.check_data_format(vector, string);
    }

    private void check_writable(Vector vector, String string) throws DevFailed {
        boolean bl = false;
        try {
            CharSequence charSequence;
            int n = this.find(vector, "writable");
            long l = this.count(vector, "writable");
            if (l > 1L) {
                bl = true;
                charSequence = new StringBuffer("Device ");
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append("-> Attribute : ");
                ((StringBuffer)charSequence).append(this.name);
                ((StringBuffer)charSequence).append("-> Multiple definition of the writable property !!");
                TangoUtil.throw_exception(((StringBuffer)charSequence).toString(), "Attribute.check_writable", 21, ErrFacility.APILIB);
            }
            if (((String)(charSequence = ((AttrProperty)vector.elementAt(n)).get_value())).equalsIgnoreCase("true")) {
                this.writable = true;
                return;
            }
            if (((String)charSequence).equalsIgnoreCase("false")) {
                this.writable = false;
                return;
            }
            bl = true;
            TangoUtil.out3.println("Attribute.check_writable throwing exception");
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Property writable is badly defined!!");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_writable", 21, ErrFacility.APILIB);
            return;
        }
        catch (DevFailed devFailed) {
            if (bl) {
                throw devFailed;
            }
            this.writable = false;
            return;
        }
    }

    private void check_data_format(Vector vector, String string) throws DevFailed {
        CharSequence charSequence;
        int n = 0;
        try {
            n = this.find(vector, "data_format");
        }
        catch (DevFailed devFailed) {
            TangoUtil.out3.println("Attribute.check_data_format throwing exception");
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Property data_format is not defined");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_data_format", 21, ErrFacility.APILIB);
        }
        int n2 = this.count(vector, "data_format");
        if (n2 > 1) {
            charSequence = new StringBuffer("Device ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append("-> Attribute : ");
            ((StringBuffer)charSequence).append(this.name);
            ((StringBuffer)charSequence).append("-> Multiple definition of the data_format property !!");
            TangoUtil.throw_exception(((StringBuffer)charSequence).toString(), "Attribute.check_data_format", 21, ErrFacility.APILIB);
        }
        if (((String)(charSequence = ((AttrProperty)vector.elementAt(n)).get_value())).equalsIgnoreCase("tango_attr_scalar")) {
            this.data_format = AttrDataFormat.SCALAR;
            this.dim_y = 0;
            this.dim_x = 0;
            return;
        }
        if (((String)charSequence).equalsIgnoreCase("tango_attr_spectrum")) {
            this.check_dim_x(vector, string);
            this.dim_y = 0;
            this.data_format = AttrDataFormat.SPECTRUM;
            return;
        }
        if (((String)charSequence).equalsIgnoreCase("tango_attr_image")) {
            this.check_dim_y(vector, string);
            this.check_dim_x(vector, string);
            this.data_format = AttrDataFormat.IMAGE;
            return;
        }
        TangoUtil.out3.println("Attribute.check_data_format throwing exception");
        StringBuffer stringBuffer = new StringBuffer("Device ");
        stringBuffer.append(string);
        stringBuffer.append("-> Attribute : ");
        stringBuffer.append(this.name);
        stringBuffer.append("-> Data format is not supported!!");
        TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_data_format", 21, ErrFacility.APILIB);
    }

    private void check_dim_x(Vector vector, String string) throws DevFailed {
        Object object;
        int n = 0;
        try {
            n = this.find(vector, "dim_x");
        }
        catch (DevFailed devFailed) {
            TangoUtil.out3.println("Attribute.check_dim_x throwing exception");
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Property dim_x is missing !!");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_dim_x", 21, ErrFacility.APILIB);
        }
        int n2 = this.count(vector, "dim_x");
        if (n2 > 1) {
            object = new StringBuffer("Device ");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append("-> Attribute : ");
            ((StringBuffer)object).append(this.name);
            ((StringBuffer)object).append("-> Multiple definition of the dim_x property !!");
            TangoUtil.throw_exception(((StringBuffer)object).toString(), "Attribute.check_dim_x", 21, ErrFacility.APILIB);
        }
        object = (AttrProperty)vector.elementAt(n);
        try {
            ((AttrProperty)object).convert();
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Can't convert property dim_x to a number !!");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_dim_x", 21, ErrFacility.APILIB);
        }
        this.dim_x = ((AttrProperty)object).get_lg_value();
    }

    private void check_dim_y(Vector vector, String string) throws DevFailed {
        Object object;
        int n = 0;
        try {
            n = this.find(vector, "dim_y");
        }
        catch (DevFailed devFailed) {
            TangoUtil.out3.println("Attribute.check_dim_y throwing exception");
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Property dim_y is missing !!");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_dim_y", 21, ErrFacility.APILIB);
        }
        int n2 = this.count(vector, "dim_y");
        if (n2 > 1) {
            object = new StringBuffer("Device ");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append("-> Attribute : ");
            ((StringBuffer)object).append(this.name);
            ((StringBuffer)object).append("-> Multiple definition of the dim_y property !!");
            TangoUtil.throw_exception(((StringBuffer)object).toString(), "Attribute.check_dim_y", 21, ErrFacility.APILIB);
        }
        object = (AttrProperty)vector.elementAt(n);
        try {
            ((AttrProperty)object).convert();
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer("Device ");
            stringBuffer.append(string);
            stringBuffer.append("-> Attribute : ");
            stringBuffer.append(this.name);
            stringBuffer.append("-> Can't convert property dim_y to a number !!");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_dim_y", 21, ErrFacility.APILIB);
        }
        this.dim_y = ((AttrProperty)object).get_lg_value();
    }

    private int find(Vector vector, String string) throws DevFailed {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((AttrProperty)vector.elementAt(n2)).get_name().equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.find", 21, ErrFacility.APILIB);
        }
        return n2;
    }

    private int count(Vector vector, String string) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((AttrProperty)vector.elementAt(n3)).get_name().equals(string)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    private void init_opt_prop(Vector var1_1, String var2_2) throws DevFailed {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String get_attr_value(Vector vector, String string) throws DevFailed {
        int n = 0;
        try {
            n = this.find(vector, string);
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" is missing for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.get_attr_value", 22, ErrFacility.APILIB);
        }
        return ((AttrProperty)vector.elementAt(n)).get_value();
    }

    private void throw_err_format(String string, String string2) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("Device ");
        stringBuffer.append(string2);
        stringBuffer.append("-> Attribute");
        stringBuffer.append(this.name);
        stringBuffer.append("\nThe property ");
        stringBuffer.append(string);
        stringBuffer.append(" is defined ina unsupported format");
        TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.throw_err_format", 22, ErrFacility.APILIB);
    }

    private void set_data_size() {
        switch (this.data_format.value()) {
            case 0: {
                this.data_size = 1;
                return;
            }
            case 1: {
                this.data_size = this.dim_x;
                return;
            }
            case 2: {
                this.data_size = this.dim_x * this.dim_y;
                return;
            }
        }
    }

    public boolean is_writ_associated() {
        return !this.writable_attr_name.equals("None");
    }

    public boolean is_alarmed() {
        return this.check_min_alarm || this.check_max_alarm;
    }

    public void get_properties(AttributeConfig attributeConfig) {
        attributeConfig.writable = this.writable;
        attributeConfig.data_format = this.data_format;
        attributeConfig.dim_x = this.dim_x;
        attributeConfig.dim_y = this.dim_y;
        attributeConfig.data_type = this.data_type;
        attributeConfig.name = this.name;
        attributeConfig.label = this.label;
        attributeConfig.description = this.description;
        attributeConfig.unit = this.unit;
        attributeConfig.standard_unit = this.standard_unit;
        attributeConfig.display_unit = this.display_unit;
        attributeConfig.format = this.format;
        attributeConfig.writable_attr_name = this.writable_attr_name;
        attributeConfig.min_alarm = this.min_alarm_str;
        attributeConfig.max_alarm = this.max_alarm_str;
        attributeConfig.min_value = this.min_value_str;
        attributeConfig.max_value = this.max_value_str;
        attributeConfig.extensions = new String[0];
    }

    /*
     * Exception decompiling
     */
    void set_properties(AttributeConfig var1_1, String var2_2) throws DevFailed {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void upd_database(AttributeConfig attributeConfig, String string) throws DevFailed {
        TangoUtil.out4.println("Entering upd_database method for attribute " + this.name);
        String[] stringArray = new String[]{string, "1", this.name, "10", "description", attributeConfig.description, "label", attributeConfig.label, "unit", attributeConfig.unit, "standard_unit", attributeConfig.standard_unit, "display_unit", attributeConfig.display_unit, "format", attributeConfig.format, "min_value", attributeConfig.min_value, "max_value", attributeConfig.max_value, "min_alarm", attributeConfig.min_alarm, "max_alarm", attributeConfig.max_alarm};
        TangoUtil tangoUtil = TangoUtil.instance();
        Any any = tangoUtil.get_orb().create_any();
        DevVarStringArrayHelper.insert(any, stringArray);
        tangoUtil.get_db_device().command_inout("DbPutDeviceAttributeProperty", any);
        TangoUtil.out4.println("Leaving upd_database method");
    }

    void add_write_value(short s) {
        this.tmp_sh[1] = s;
        this.value.sh_seq = this.tmp_sh;
    }

    void add_write_value(int n) {
        this.tmp_lo[1] = n;
        this.value.lg_seq = this.tmp_lo;
    }

    void add_write_value(double d) {
        this.tmp_db[1] = d;
        this.value.db_seq = this.tmp_db;
    }

    void add_write_value(String string) {
        this.tmp_str[1] = string;
        this.value.str_seq = this.tmp_str;
    }

    public void set_value(short[] sArray) throws DevFailed {
        if (this.data_type != 2) {
            StringBuffer stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.set_value", 22, ErrFacility.APILIB);
        }
        if (!this.date) {
            this.value.sh_seq = sArray;
        } else if (this.is_writ_associated()) {
            this.tmp_sh[0] = sArray[0];
        } else {
            this.value.sh_seq = sArray;
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(int[] nArray) throws DevFailed {
        if (this.data_type != 3) {
            StringBuffer stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.set_value", 22, ErrFacility.APILIB);
        }
        if (!this.date) {
            this.value.lg_seq = nArray;
        } else if (this.is_writ_associated()) {
            this.tmp_lo[0] = nArray[0];
        } else {
            this.value.lg_seq = nArray;
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(double[] dArray) throws DevFailed {
        if (this.data_type != 5) {
            StringBuffer stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.set_value", 22, ErrFacility.APILIB);
        }
        if (!this.date) {
            this.value.db_seq = dArray;
        } else if (this.is_writ_associated()) {
            this.tmp_db[0] = dArray[0];
        } else {
            this.value.db_seq = dArray;
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(String[] stringArray) throws DevFailed {
        if (this.data_type != 8) {
            StringBuffer stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.set_value", 22, ErrFacility.APILIB);
        }
        if (!this.date) {
            this.value.str_seq = stringArray;
        } else if (this.is_writ_associated()) {
            this.tmp_str[0] = stringArray[0];
        } else {
            this.value.str_seq = stringArray;
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.set_time();
    }

    private void set_time() {
        if (this.date) {
            Date date = new Date();
            long l = date.getTime();
            this.when.tv_sec = (int)(l / 1000L);
            this.when.tv_usec = (int)((l - (long)(this.when.tv_sec * 1000)) * 1000L);
            this.when.tv_nsec = 0;
        }
    }

    public boolean check_alarm() throws DevFailed {
        if (!this.is_alarmed()) {
            StringBuffer stringBuffer = new StringBuffer("No alarm defined for attribute ");
            stringBuffer.append(this.name);
            TangoUtil.throw_exception(stringBuffer.toString(), "Attribute.check_alarm", 25, ErrFacility.APILIB);
        }
        int n = 0;
        if (this.check_min_alarm) {
            switch (this.data_type) {
                case 2: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.sh_seq[n] <= this.min_alarm.sh) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 3: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.lg_seq[n] <= this.min_alarm.lg) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 5: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.db_seq[n] <= this.min_alarm.db) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
            }
            this.min_alarm_on = false;
        }
        if (this.check_max_alarm) {
            switch (this.data_type) {
                case 2: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.sh_seq[n] >= this.max_alarm.sh) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 3: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.lg_seq[n] >= this.max_alarm.lg) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 5: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.db_seq[n] >= this.max_alarm.db) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
            }
            this.max_alarm_on = false;
        }
        return false;
    }

    public String toString() {
        AttributeConfig attributeConfig = new AttributeConfig();
        this.get_properties(attributeConfig);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute name = ");
        stringBuffer.append(attributeConfig.name);
        stringBuffer.append("\nAttribute data_type = ");
        switch (attributeConfig.data_type) {
            case 2: {
                stringBuffer.append("Tango_DevShort");
                break;
            }
            case 3: {
                stringBuffer.append("Tango_DevLong");
                break;
            }
            case 5: {
                stringBuffer.append("Tango_DevDouble");
                break;
            }
            case 8: {
                stringBuffer.append("Tango_DevString");
                break;
            }
        }
        stringBuffer.append("\nAttribute data_format = ");
        switch (attributeConfig.data_format.value()) {
            case 0: {
                stringBuffer.append("scalar");
                break;
            }
            case 1: {
                stringBuffer.append("spectrum, dim_x = ");
                stringBuffer.append(attributeConfig.dim_x);
                break;
            }
            case 2: {
                stringBuffer.append("image, dim_x = ");
                stringBuffer.append(attributeConfig.dim_x);
                stringBuffer.append(", dim_y = ");
                stringBuffer.append(attributeConfig.dim_y);
                break;
            }
        }
        if (attributeConfig.writable) {
            stringBuffer.append("\nAttribute is writable");
        } else {
            stringBuffer.append("\nAttribute is not writable");
        }
        stringBuffer.append("\nAttribute label = ");
        stringBuffer.append(attributeConfig.label);
        stringBuffer.append("\nAttribute description = ");
        stringBuffer.append(attributeConfig.description);
        stringBuffer.append("\nAttribute unit = ");
        stringBuffer.append(attributeConfig.unit);
        stringBuffer.append(", standard unit = ");
        stringBuffer.append(attributeConfig.standard_unit);
        stringBuffer.append(", display unit = ");
        stringBuffer.append(attributeConfig.display_unit);
        stringBuffer.append("\nAttribute format = ");
        stringBuffer.append(attributeConfig.format);
        stringBuffer.append("\nAttribute min alarm = ");
        stringBuffer.append(attributeConfig.min_alarm);
        stringBuffer.append("\nAttribute max alarm = ");
        stringBuffer.append(attributeConfig.max_alarm);
        stringBuffer.append("\nAttribute min value = ");
        stringBuffer.append(attributeConfig.min_value);
        stringBuffer.append("\nAttribute max value = ");
        stringBuffer.append(attributeConfig.max_value);
        stringBuffer.append("\nAttribute writable_attr_name = ");
        stringBuffer.append(attributeConfig.writable_attr_name);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void set_value() throws DevFailed {
    }

    public boolean is_writable() {
        return this.writable;
    }

    public String get_name() {
        return this.name;
    }

    public String get_assoc_name() {
        return this.writable_attr_name;
    }

    public int get_data_type() {
        return this.data_type;
    }

    public boolean is_min_alarm() {
        return this.min_alarm_on;
    }

    public boolean is_max_alarm() {
        return this.max_alarm_on;
    }

    public AttrDataFormat get_data_format() {
        return this.data_format;
    }

    public int get_assoc_ind() {
        return this.assoc_ind;
    }

    public void set_assoc_ind(int n) {
        this.assoc_ind = n;
    }

    public int get_data_size() {
        return this.data_size;
    }

    public AttrQuality get_quality() {
        return this.quality;
    }

    public void set_quality(AttrQuality attrQuality) {
        this.quality = attrQuality;
    }

    public TimeVal get_when() {
        return this.when;
    }

    void wanted_date(boolean bl) {
        this.date = bl;
    }

    void set_value_flag(boolean bl) {
        this.value_flag = bl;
    }

    boolean get_value_flag() {
        return this.value_flag;
    }

    short[] get_short_value() {
        return this.value.sh_seq;
    }

    int[] get_long_value() {
        return this.value.lg_seq;
    }

    double[] get_double_value() {
        return this.value.db_seq;
    }

    String[] get_string_value() {
        return this.value.str_seq;
    }
}

