/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import TangoDs.TangoConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class PogoGene
implements PogoDefs,
TangoConst {
    PogoClass pogo;
    protected StringBuffer sbTrace;

    public PogoGene(PogoClass pogo) {
        this.pogo = pogo;
    }

    protected String addCommentsCmdMethod() {
        StringBuffer sb = new StringBuffer("\n\n");
        sb.append("//===================================================================\n");
        sb.append("//\n");
        sb.append("//\tThe folowing table gives the correspondance\n");
        sb.append("//\tbetween commands and method's name.\n");
        sb.append("//\n");
        sb.append("//\tCommand's name\t|\tMethod's name\n");
        sb.append("//\t----------------------------------------\n");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            sb.append("//\t" + cmd.command + "\t|\t" + cmd.exec_method + "()\n");
            ++i;
        }
        sb.append("//\n");
        sb.append("//===================================================================\n");
        sb.append("\n\n\n");
        return sb.toString();
    }

    protected String buildAttributesMethods(PogoString pgs, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int ptr;
        String rwAttr = lang == 1 ? new String(String.valueOf(this.pogo.templates_dir) + "/java/ReadWriteAttr.java") : new String(String.valueOf(this.pogo.templates_dir) + "/cpp/ReadWriteAttr.cpp");
        String read = this.readAttributeTemplate(rwAttr, 0);
        String write = this.readAttributeTemplate(rwAttr, 1);
        String pattern = lang == 1 ? "public void read_attr_hardware" : "::read_attr_hardware";
        int start = pgs.str.indexOf(pattern);
        if (start < 0) {
            pattern = lang == 1 ? "public void init_device()" : "::always_executed_hook";
            ptr = pgs.str.indexOf(pattern);
            if (ptr < 0) {
                throw new PogoException("'" + pattern + "()' method not found");
            }
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, read);
        }
        boolean writable = false;
        int i = 0;
        while (i < this.pogo.attributes.size()) {
            Attrib attr = this.pogo.attributes.elementAt(i);
            if (attr.getWritable()) {
                writable = true;
            }
            ++i;
        }
        pattern = lang == 1 ? "public void write_attr_hardware" : "::write_attr_hardware";
        if (writable && (start = pgs.str.indexOf(pattern)) < 0) {
            pattern = lang == 1 ? "public void init_device()" : "::always_executed_hook";
            ptr = pgs.str.indexOf(pattern);
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, write);
        }
        if ((start = pgs.str.indexOf(pattern = lang == 1 ? "public void read_attr(" : "::read_attr(")) < 0) {
            throw new PogoException("'" + pattern + ")' method not found");
        }
        start = pgs.inMethod(start);
        int end = pgs.outMethod(start + 1);
        PogoString block1 = new PogoString(pgs.str.substring(start, end));
        String src = new String(block1.toString());
        ptr = block1.str.indexOf("Switch on attribute name");
        if (ptr < 0) {
            System.out.println(block1);
            throw new PogoException("'Switch on attribute name' not found");
        }
        ptr = block1.nextCr(ptr) + 1;
        ptr = block1.nextCr(ptr) + 1;
        int i2 = 0;
        while (i2 < this.pogo.attributes.size()) {
            Attrib attr = this.pogo.attributes.elementAt(i2);
            String target = new String("\"" + attr.name + "\"");
            if (block1.str.indexOf(target, ptr) < 0) {
                String tab = lang == 1 ? "\t\t" : "\t";
                StringBuffer sb = new StringBuffer(tab);
                sb.append("if (attr_name == " + target + ")\n");
                sb.append(String.valueOf(tab) + "{\n");
                sb.append(String.valueOf(tab) + "\t//\tAdd your own code here\n");
                sb.append(String.valueOf(tab) + "}\n");
                block1.insert(ptr, sb.toString());
            }
            ++i2;
        }
        pgs.replace(src, block1.toString());
        if (writable) {
            pattern = lang == 1 ? "public void write_attr_hardware(" : "::write_attr_hardware";
            start = pgs.str.indexOf(pattern);
            if (start < 0) {
                throw new PogoException("'" + pattern + "' method not found");
            }
            start = pgs.inMethod(start);
            end = pgs.outMethod(start + 1);
            PogoString block2 = new PogoString(pgs.str.substring(start, end));
            src = new String(block2.toString());
            ptr = block2.str.indexOf("Switch on attribute name");
            if (ptr < 0) {
                throw new PogoException("'Switch on attribute name' not found");
            }
            ptr = block2.nextCr(ptr) + 1;
            ptr = block2.nextCr(ptr) + 1;
            int i3 = 0;
            while (i3 < this.pogo.attributes.size()) {
                String target;
                Attrib attr = this.pogo.attributes.elementAt(i3);
                if (attr.getWritable() && block2.str.indexOf(target = new String("\"" + attr.name + "\""), ptr) < 0) {
                    String tab = lang == 1 ? "\t\t\t" : "\t\t";
                    StringBuffer sb = new StringBuffer(tab);
                    sb.append("if (attr_name == " + target + ")\n");
                    sb.append(String.valueOf(tab) + "{\n");
                    sb.append(String.valueOf(tab) + "\t//\tAdd your own code here\n");
                    sb.append(String.valueOf(tab) + "}\n");
                    block2.insert(ptr, sb.toString());
                }
                ++i3;
            }
            pgs.replace(src, block2.toString());
        }
        return pgs.toString();
    }

    protected void buildReadMeFile(String f_in, String f_out) {
        try {
            FileInputStream fidin = new FileInputStream(f_in);
            FileOutputStream fidout = new FileOutputStream(f_out);
            int nb = fidin.available();
            byte[] inStr = new byte[nb];
            fidin.read(inStr);
            fidin.close();
            PogoString pgs = new PogoString(new String(inStr));
            while (pgs.str.indexOf(PogoDefs.templateClass) > 0) {
                pgs.replace(PogoDefs.templateClass, this.pogo.class_name);
            }
            fidout.write(pgs.str.getBytes());
            if (this.pogo.language == 1) {
                int i = 0;
                while (i < this.pogo.commands.size()) {
                    Cmd cmd = this.pogo.commands.cmdIdx(i);
                    if (!cmd.virtual_method) {
                        String str = new String(String.valueOf(cmd.command) + "Cmd" + PogoDefs.javaExtention + ":\n\t" + "Java source code for the command " + cmd.command + "\n\t" + cmd.description + "\n\n");
                        fidout.write(str.getBytes());
                    }
                    ++i;
                }
            }
            fidout.close();
        }
        catch (Exception ex) {
            System.out.println("README Cannot be generated\n" + ex.toString());
        }
    }

    protected String changeExeMethodArgs(Cmd cmd, String str, int idx, int lang) {
        StringBuffer sb = new StringBuffer(str);
        boolean in_method = false;
        int cnt = 0;
        sb.insert(idx, "//");
        while (!in_method || cnt > 0) {
            char c;
            if ((c = sb.charAt(idx++)) == '\n') {
                sb.insert(idx, "//");
            }
            if (c == '{') {
                ++cnt;
                in_method = true;
                continue;
            }
            if (c != '}') continue;
            --cnt;
        }
        switch (lang) {
            case 1: {
                String description = cmd.buildJavaExecCmdMethodComments();
                sb.insert(idx, description);
                sb.insert(idx += description.length(), cmd.buildJavaExecCmdMethod());
                break;
            }
        }
        return sb.toString();
    }

    protected void checkForExecMethodModif(String f_in, String f_out, int lang) throws IOException, PogoException {
        Cmd cmd;
        int i;
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        if (lang == 2) {
            i = 0;
            while (i < this.pogo.commands.size()) {
                cmd = this.pogo.commands.cmdIdx(i);
                if (!cmd.virtual_method) {
                    cmd.updateCppExecCmdMethodComments(pgs, this.pogo.class_name);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.pogo.commands.size()) {
            cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                int startmethod;
                boolean generate = true;
                String pattern = lang == 2 ? new String(String.valueOf(this.pogo.class_name) + "::" + cmd.exec_method + "(") : cmd.buildJavaExecCmdMethodSignature();
                int endline = 0;
                while ((startmethod = pgs.str.indexOf(pattern, endline)) >= 0) {
                    int sl;
                    int startline = pgs.previousCr(startmethod);
                    String line = pgs.str.substring(startline, endline = pgs.nextCr(startline));
                    int el = line.indexOf(" ", sl = line.indexOf("("));
                    if (el < 0) {
                        el = sl + 1;
                    }
                    line = line.substring(0, el);
                    if (!cmd.isExecMethod(pgs.str.substring(startmethod, endline)) || line.indexOf("//") >= 0 || line.indexOf("\"") >= 0 || line.indexOf("<<") >= 0 || line.indexOf("println") >= 0 || !cmd.execMethodArgsChanged(line, lang)) continue;
                    System.out.println("args of " + cmd.exec_method + " have been modified !\n\t-> Re-Generate....");
                    String s = this.changeExeMethodArgs(cmd, pgs.str, startline, lang);
                    pgs = new PogoString(s);
                    break;
                }
            }
            ++i;
        }
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    protected void copyFile(String f_in, String f_out) throws FileNotFoundException, IOException {
        FileInputStream fidin = new FileInputStream(f_in);
        FileOutputStream fidout = new FileOutputStream(f_out);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        fidout.write(inStr);
        fidin.close();
        fidout.close();
    }

    public String getTrace() {
        return this.sbTrace.toString();
    }

    protected boolean mustGenerate(String filename) throws FileNotFoundException, IOException {
        return new File(filename).exists() ^ true;
    }

    protected String readAttributeTemplate(String f_in, int part) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString rw = new PogoString(inStr);
        fidin.close();
        while (rw.str.indexOf(PogoDefs.templateClass) >= 0) {
            rw.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        int end = rw.str.indexOf("WRITE ATTRIBUTE");
        if (end < 0) {
            throw new PogoException("'WRITE ATTRIBUTE' method not found");
        }
        end = rw.previousCr(end);
        PogoString pgs = null;
        switch (part) {
            case 0: {
                pgs = new PogoString(rw.str.substring(0, end));
                break;
            }
            case 1: {
                int start = rw.nextCr(end) + 1;
                pgs = new PogoString(rw.str.substring(start));
                break;
            }
        }
        return pgs.toString();
    }

    protected void replacePatternFile(String f_in, String f_out, String to_find, String target) throws IOException {
        String s;
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        String str = new String(inStr);
        fidin.close();
        FileOutputStream fidout = new FileOutputStream(f_out);
        int end = 0;
        int start = 0;
        while ((end = str.indexOf(to_find, start)) > 0) {
            s = str.substring(start, end);
            fidout.write(s.getBytes());
            fidout.write(target.getBytes());
            start = end + to_find.length();
        }
        s = str.substring(start);
        fidout.write(s.getBytes());
        fidout.close();
    }

    protected String setMethodInComments(PogoString pgs, int startline) {
        int end_bl = pgs.inMethod(startline);
        end_bl = pgs.outMethod(end_bl);
        PogoString pgs1 = new PogoString(pgs.str.substring(startline, end_bl));
        StringBuffer sb = new StringBuffer("//");
        int i = 0;
        while (i < pgs1.str.length()) {
            sb.append(pgs1.str.charAt(i));
            if (pgs1.str.charAt(i) == '\n') {
                sb.append("//");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String setProjectTitle(String header) {
        int start = header.indexOf(PogoDefs.projectTitleRes);
        if (start < 0) {
            return header;
        }
        int end = header.indexOf("\n", start += PogoDefs.projectTitleRes.length());
        StringBuffer sb = new StringBuffer(header.substring(0, start));
        sb.append("\t" + this.pogo.title);
        sb.append(header.substring(end));
        return sb.toString();
    }
}

