/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.DevState;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class DevStateTable
implements PogoDefs {
    public Vector vect = new Vector();

    public DevStateTable() {
    }

    public DevStateTable(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        int start = str.indexOf(PogoDefs.statesDescRes);
        if (start < 0) {
            System.out.println("WARNING: " + PogoDefs.statesDescRes + "Not found !");
            return;
        }
        start = str.indexOf("\n", start) + 1;
        int end = str.indexOf("*/", start);
        PogoString pgs = new PogoString(str.substring(start, end));
        pgs.getDescription();
        String pattern = "Tango::";
        end = 0;
        start = 0;
        while (end >= 0 && (start = pgs.str.indexOf(pattern, end)) >= 0) {
            end = pgs.str.indexOf(":", start + pattern.length() + 1);
            String name = pgs.str.substring(start, end).trim();
            start = end + 2;
            String desc = (end = pgs.str.indexOf(pattern, start)) > 0 ? pgs.str.substring(start, end).trim() : (start < pgs.str.length() ? pgs.str.substring(start) : "");
            this.vect.addElement(new DevState(name, desc));
            start = end;
        }
    }

    public DevStateTable(Vector v_in) {
        int i = 0;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public void addElement(DevState st) {
        this.vect.addElement(st);
    }

    public void clear() {
        this.vect.clear();
    }

    public DevState elementAt(int idx) {
        return (DevState)this.vect.elementAt(idx);
    }

    public void remove(DevState st) {
        this.vect.remove(st);
    }

    public int size() {
        return this.vect.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            DevState state = (DevState)this.vect.elementAt(i);
            sb.append(String.valueOf(state.name) + ":\n");
            sb.append(String.valueOf(state.description) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public String toStringComments() {
        StringBuffer sb = new StringBuffer(" *\t" + PogoDefs.statesDescRes + "\n");
        int i = 0;
        while (i < this.vect.size()) {
            DevState state = (DevState)this.vect.elementAt(i);
            PogoString pgs = new PogoString(" *\t" + state.name + " :\t" + state.description);
            int idx = 0;
            while (idx < pgs.str.length()) {
                if (pgs.str.charAt(idx) == '\n') {
                    pgs.insert(idx + 1, " *\t\t\t");
                }
                ++idx;
            }
            sb.append(String.valueOf(String.valueOf(pgs)) + "\n");
            ++i;
        }
        return sb.toString();
    }
}

