/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class CmdTable
implements PogoDefs {
    public Vector vect = new Vector();

    public CmdTable(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String add_list_str;
        int lang;
        if (filename.indexOf(PogoDefs.cppExtention) > 0) {
            lang = 2;
            add_list_str = PogoDefs.cppAddCommands;
        } else if (filename.indexOf(PogoDefs.javaExtention) > 0) {
            lang = 1;
            add_list_str = PogoDefs.javaAddCommands;
        } else {
            throw new PogoException("Unrecognised file type !");
        }
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        this.createVirtualStatusCmd();
        int i = 0;
        while ((i = str.indexOf(add_list_str, i)) > 0) {
            int start = str.indexOf(PogoDefs.NEW_STR, i) + PogoDefs.NEW_STR.length();
            while (str.charAt(start) <= ' ') {
                ++start;
            }
            int end = str.indexOf(59, start);
            Cmd cmd = new Cmd(str.substring(start, end));
            switch (lang) {
                case 2: {
                    cmd.setNotAllowedFor(str, lang);
                    break;
                }
                case 1: {
                    String path = new PogoString(filename).extractPathFromFullPath();
                    fid = new FileInputStream(new String(String.valueOf(path) + "/" + cmd.cmd_class + PogoDefs.javaExtention));
                    nb = fid.available();
                    inStr = new byte[nb];
                    fid.read(inStr);
                    String strCmd = new String(inStr);
                    fid.close();
                    cmd.setNotAllowedFor(strCmd, lang);
                    break;
                }
            }
            this.vect.addElement(cmd);
            ++i;
        }
    }

    public CmdTable(Vector v_in) {
        if (v_in.size() == 0) {
            this.createVirtualStatusCmd();
        }
        int i = this.vect.size();
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public void addElement(Cmd cmd) {
        this.vect.addElement(cmd);
    }

    public String buildCommandFactoryMethod(int lang) throws PogoException {
        StringBuffer sb = new StringBuffer("{\n");
        int i = 0;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            if (!cmd.virtual_method) {
                sb.append(cmd.AddCmdObjectList(lang));
            }
            ++i;
        }
        if (lang == 1) {
            sb.append("\t");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String checkArgsType() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            if (cmd.argin.code == -1) {
                sb.append("Argin type (" + cmd.argin.cpp + ") unknown for command " + cmd.command + "!\n");
            }
            if (cmd.argout.code == -1) {
                sb.append("Argout type (" + cmd.argout.cpp + ") unknown for command " + cmd.command + "!\n");
            }
            ++i;
        }
        String s = sb.toString();
        if (s.length() > 0) {
            return s;
        }
        return null;
    }

    public Cmd cmdIdx(int idx) {
        return (Cmd)this.vect.elementAt(idx);
    }

    private void createVirtualStatusCmd() {
        Cmd cmd1 = new Cmd("DevState", "DevStateCmd", "Tango::DEV_VOID", "Tango::DEV_STATE", "", "State Code", "Command to read the device state.\nThe method dev_state() override a DeviceImpl class virtual method.");
        cmd1.virtual_method = true;
        cmd1.override_method = 0;
        this.vect.addElement(cmd1);
        Cmd cmd2 = new Cmd("DevStatus", "DevStatusCmd", "Tango::DEV_VOID", "Tango::DEV_STRING", "", "Status descrition", "Command to read the device status.\nThe method dev_status() override a DeviceImpl class virtual method.");
        cmd2.virtual_method = true;
        cmd2.override_method = 0;
        this.vect.addElement(cmd2);
    }

    public void getDescriptions(String descFile, String serverClass, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String path = new PogoString(descFile).extractPathFromFullPath();
        int i = 0;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            if (!cmd.virtual_method) {
                switch (lang) {
                    case 2: {
                        cmd.checkCppExecCmdMethodName(serverClass);
                        break;
                    }
                    case 1: {
                        String cmdFile = new String(String.valueOf(path) + "/" + cmd.cmd_class + PogoDefs.javaExtention);
                        cmd.checkJavaExecCmdMethodName(cmdFile);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            ++i;
        }
        FileInputStream fid = new FileInputStream(descFile);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        int i2 = 0;
        while (i2 < this.vect.size()) {
            if (!this.cmdIdx((int)i2).virtual_method) {
                System.out.println(this.cmdIdx((int)i2).command);
                this.cmdIdx(i2).getExecMethodDescription(str, lang);
            }
            ++i2;
        }
    }

    public int size() {
        return this.vect.size();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            buff.append("--------------------------------------------\n");
            buff.append(String.valueOf(cmd.command) + ", " + cmd.cmd_class + ", " + cmd.argin.code_str + ", " + cmd.argout.code_str);
            if (cmd.argin.description != null) {
                buff.append(",\n\t" + cmd.argin.description + "\n\t" + cmd.argout.description + "\n");
            } else {
                buff.append("\n");
            }
            ++i;
        }
        String str = new String(buff);
        return str;
    }

    public String toString(int idx) throws PogoException {
        if (idx >= this.vect.size()) {
            throw new PogoException("Command index out of bounds !");
        }
        Cmd cmd = this.cmdIdx(idx);
        String str = new String(String.valueOf(cmd.command) + ", " + cmd.cmd_class + ", " + cmd.argin.code_str + ", " + cmd.argout.code_str);
        return str;
    }
}

