/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class AttribTable
implements PogoDefs {
    public Vector vect = new Vector();

    public AttribTable() {
    }

    public AttribTable(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        int start = pgs.str.indexOf("attribute_factory(");
        if (start < 0) {
            return;
        }
        PogoString block = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        String patern = filename.indexOf(PogoDefs.javaExtention) > 0 ? PogoDefs.javaAddAttrib : PogoDefs.cppAddAttrib;
        while ((start = block.str.indexOf(patern, start)) >= 0) {
            Attrib attr;
            int xSize;
            start = block.str.indexOf("(", start) + 1;
            int end = block.str.indexOf("(", start) + 1;
            String constructor = block.str.substring(start, end);
            start = end;
            end = block.str.indexOf(")", start);
            PogoString s = new PogoString(block.str.substring(start, end));
            String[] params = s.getParams();
            if (constructor.indexOf("Image") >= 0) {
                xSize = new Integer(params[2]);
                int ySize = new Integer(params[3]);
                attr = new Attrib(params[0], 2, params[1], xSize, ySize);
            } else if (constructor.indexOf("Spectrum") >= 0) {
                xSize = new Integer(params[2]);
                attr = new Attrib(params[0], 1, params[1], xSize);
            } else {
                int type = 0;
                int i = 0;
                while (i < PogoDefs.AttrRWtypeArray.length) {
                    if (params[2].equals(PogoDefs.AttrRWtypeArray[i])) {
                        type = i;
                    }
                    ++i;
                }
                attr = params.length == 4 && type == 3 ? new Attrib(params[0], 0, params[1], type, params[3]) : new Attrib(params[0], 0, params[1], type, "");
            }
            this.vect.addElement(attr);
        }
    }

    public AttribTable(Vector v_in) {
        int i = 0;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public void addElement(Attrib st) {
        this.vect.addElement(st);
    }

    public String buildFactory(int lang) {
        String addKeyWord = lang == 1 ? PogoDefs.javaAddAttrib : PogoDefs.cppAddAttrib;
        String tab = lang == 1 ? "\t" : "";
        StringBuffer sb = new StringBuffer(String.valueOf(tab) + "{\n");
        int i = 0;
        while (i < this.size()) {
            Attrib attr = this.elementAt(i);
            sb.append(String.valueOf(tab) + "\t" + addKeyWord + "(new Tango::");
            switch (attr.attrType) {
                case 0: {
                    sb.append("Attr(\n\t\t\"" + attr.name + "\", " + attr.dataType.code_str + ", " + PogoDefs.AttrRWtypeArray[attr.rwType]);
                    if (attr.rwType != 3) break;
                    sb.append(", \"" + attr.assAttr + "\"");
                    break;
                }
                case 1: {
                    sb.append("SpectrumAttr(\n\t\t\"" + attr.name + "\", " + attr.dataType.code_str + ", " + attr.xSize);
                    break;
                }
                case 2: {
                    sb.append("ImageAttr(\n\t\t\"" + attr.name + "\", " + attr.dataType.code_str + ", " + attr.xSize + ", " + attr.ySize);
                    break;
                }
            }
            sb.append("));\n");
            ++i;
        }
        sb.append(String.valueOf(tab) + "}\n");
        return sb.toString();
    }

    public Attrib elementAt(int idx) {
        return (Attrib)this.vect.elementAt(idx);
    }

    public int size() {
        return this.vect.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            Attrib attr = (Attrib)this.vect.elementAt(i);
            sb.append(String.valueOf(attr.name) + "\t");
            sb.append(String.valueOf(attr.dataType.code_str) + "\n");
            ++i;
        }
        return sb.toString();
    }
}

