/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pogo.appli.GenerateDialog;
import pogo.appli.PogoAppliDefs;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoGeneCpp;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoGeneJava;

public class GenerateThread
extends Thread
implements PogoDefs,
PogoAppliDefs {
    private PogoClass pogo;
    private int item;
    private String homeDir;
    private JFrame parent;
    private GenerateDialog dialog;

    public GenerateThread(JFrame frame, PogoClass pogo, int item, String path) {
        this.pogo = pogo;
        this.item = item;
        this.homeDir = path;
        this.parent = frame;
        int ratio = item == 2 && pogo.language == 1 ? 7 : 20;
        this.dialog = new GenerateDialog((Frame)frame, ratio);
    }

    public void run() {
        try {
            switch (this.item) {
                case 1: {
                    if (this.pogo.language == 1) {
                        PogoGeneJava gene = new PogoGeneJava(this.pogo);
                        gene.geneSrc();
                        this.dialog.stop();
                        JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                    } else {
                        PogoGeneCpp gene = new PogoGeneCpp(this.pogo);
                        gene.geneSrc();
                        this.dialog.stop();
                        JOptionPane.showMessageDialog(this.parent, gene.getTrace(), "Message Window", 1);
                    }
                    break;
                }
                case 2: {
                    new PogoGeneDoc(this.pogo).generate();
                    this.dialog.stop();
                    JOptionPane.showMessageDialog(this.parent, "Html Documentation Generated in :\n" + this.pogo.output_files + "/doc_html", "Message Window", 1);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.dialog.stop();
            JOptionPane.showMessageDialog(this.parent, ex.toString(), "Error Window", 0);
            ex.printStackTrace();
        }
    }
}

