/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import pogo.appli.NotAllowedDialog;
import pogo.appli.PogoAppliDefs;
import pogo.gene.Cmd;
import pogo.gene.DevStateTable;

public class CommandDialog
extends JDialog
implements PogoAppliDefs {
    private Frame parent;
    private Vector stVector;
    private Vector existingCmd;
    private int editingIdx;
    private DevStateTable notAllowedFor;
    private static int returnStatus = 0;
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel nameLbl;
    private JTextField nameText;
    private JLabel jLabel1;
    private JComboBox arginComboBox;
    private JLabel jLabel2;
    private JComboBox argoutComboBox;
    private JLabel jLabel8;
    private JTextField arginDescText;
    private JLabel jLabel4;
    private JTextField argoutDescText;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextArea cmdDescText;
    private JButton allowedBtn;

    public CommandDialog(Frame parent, boolean modal, Vector stVect, Vector cmdVect) {
        super(parent, modal);
        this.parent = parent;
        this.stVector = stVect;
        this.existingCmd = cmdVect;
        this.initComponents();
        int i = 0;
        while (i < PogoAppliDefs.TangoTypesArray.length) {
            this.arginComboBox.addItem(PogoAppliDefs.TangoTypesArray[i]);
            this.argoutComboBox.addItem(PogoAppliDefs.TangoTypesArray[i]);
            ++i;
        }
        this.pack();
    }

    private void allowedBtnActionPerformed(ActionEvent evt) {
        NotAllowedDialog dialog = new NotAllowedDialog(this.parent, true, this.stVector);
        int ret = dialog.showDialog(this.notAllowedFor);
        if (ret == 1) {
            this.notAllowedFor = dialog.getInput();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private int checkCommandName() {
        String cmdName = this.nameText.getText();
        if (cmdName.length() <= 0) {
            JOptionPane.showMessageDialog(this, "Command's name must be filled in !", "Message Window", 1);
            return -1;
        }
        int i = 0;
        while (i < cmdName.length()) {
            char c = cmdName.charAt(i);
            if (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
                JOptionPane.showMessageDialog(this, "Syntax error in command's name !\nDo not use '" + c + "' char.", "Message Window", 1);
                return -1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.existingCmd.size()) {
            if (i2 != this.editingIdx) {
                Cmd cmd = (Cmd)this.existingCmd.elementAt(i2);
                if (cmdName.equals(cmd.command)) {
                    JOptionPane.showMessageDialog(this, "Command " + cmdName + " already exists !", "Message Window", 1);
                    return -1;
                }
            }
            ++i2;
        }
        return 1;
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public Cmd getInputCommand() {
        Cmd cmd = new Cmd(this.nameText.getText(), String.valueOf(this.nameText.getText()) + "Cmd", this.arginComboBox.getSelectedItem().toString(), this.argoutComboBox.getSelectedItem().toString(), this.arginDescText.getText(), this.argoutDescText.getText(), this.cmdDescText.getText());
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        }
        cmd.setNotAllowedFor(this.notAllowedFor);
        return cmd;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.nameLbl = new JLabel();
        this.nameText = new JTextField();
        this.jLabel1 = new JLabel();
        this.arginComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.argoutComboBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.arginDescText = new JTextField();
        this.jLabel4 = new JLabel();
        this.argoutDescText = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.cmdDescText = new JTextArea();
        this.allowedBtn = new JButton();
        ((Component)this).setBackground(new Color(198, 178, 168));
        this.setTitle("Command Window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CommandDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2, 5, 5));
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.nameLbl.setText("Command Name:");
        this.nameLbl.setForeground(Color.black);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.nameLbl, gridBagConstraints1);
        this.nameText.setMinimumSize(new Dimension(30, 28));
        this.nameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.nameTextActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.nameText, gridBagConstraints1);
        this.jLabel1.setText("Argin Type:");
        this.jLabel1.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.arginComboBox, gridBagConstraints1);
        this.jLabel2.setText("Argout Type:");
        this.jLabel2.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.argoutComboBox, gridBagConstraints1);
        this.jLabel8.setText("Argin Description:");
        this.jLabel8.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.arginDescText, gridBagConstraints1);
        this.jLabel4.setText("Argout Description:  ");
        this.jLabel4.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.argoutDescText, gridBagConstraints1);
        this.jLabel5.setText(" ");
        this.jLabel5.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints1);
        this.jLabel6.setText("Command Description:  ");
        this.jLabel6.setForeground(Color.black);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 8;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints1);
        this.cmdDescText.setPreferredSize(new Dimension(100, 125));
        this.cmdDescText.setMinimumSize(new Dimension(0, 100));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 9;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridheight = 5;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 5.0;
        this.jPanel2.add((Component)this.cmdDescText, gridBagConstraints1);
        this.allowedBtn.setPreferredSize(new Dimension(167, 30));
        this.allowedBtn.setBorder(new BevelBorder(0));
        this.allowedBtn.setText("Command Allowed For States....");
        this.allowedBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.allowedBtnActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        this.jPanel2.add((Component)this.allowedBtn, gridBagConstraints1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
    }

    public static void main(String[] args) {
        new CommandDialog(new Frame(), false, new Vector(), new Vector()).show();
    }

    private void nameTextActionPerformed(ActionEvent evt) {
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.checkCommandName() == 1) {
            this.doClose(1);
        }
    }

    public int showDialog() {
        return this.showDialog(null, -1);
    }

    public int showDialog(Cmd cmd, int idx) {
        this.editingIdx = idx;
        if (cmd != null) {
            this.nameText.setText(cmd.command);
            int i = 0;
            while (i < PogoAppliDefs.TangoTypesArray.length) {
                if (PogoAppliDefs.TangoTypesArray[i].equals(cmd.argin.code_str)) {
                    this.arginComboBox.setSelectedIndex(i);
                }
                if (PogoAppliDefs.TangoTypesArray[i].equals(cmd.argout.code_str)) {
                    this.argoutComboBox.setSelectedIndex(i);
                }
                ++i;
            }
            if (cmd.argin.description != null) {
                this.arginDescText.setText(cmd.argin.description);
            }
            if (cmd.argout.description != null) {
                this.argoutDescText.setText(cmd.argout.description);
            }
            if (cmd.description != null) {
                this.cmdDescText.setText(cmd.description);
            }
            this.notAllowedFor = new DevStateTable(cmd.notAllowedFor.vect);
        }
        ((Component)this).setVisible(true);
        return returnStatus;
    }
}

