/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.ImageAttr;
import fr.esrf.TangoDs.SpectrumAttr;
import fr.esrf.TangoDs.TangoAttrCheckVal;
import fr.esrf.TangoDs.TangoAttrValue;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Date;
import java.util.Vector;

public class Attribute
implements TangoConst {
    protected String name;
    protected AttrWriteType writable;
    protected int data_type;
    protected AttrDataFormat data_format;
    protected int max_x;
    protected int max_y;
    protected String label;
    protected String description;
    protected String unit;
    protected String standard_unit;
    protected String display_unit;
    protected String format;
    protected String writable_attr_name;
    protected String min_alarm_str;
    protected String max_alarm_str;
    protected String min_value_str;
    protected String max_value_str;
    protected TangoAttrCheckVal min_alarm;
    protected TangoAttrCheckVal max_alarm;
    protected TangoAttrCheckVal min_value;
    protected TangoAttrCheckVal max_value;
    protected boolean check_min_alarm = false;
    protected boolean check_max_alarm = false;
    protected boolean check_min_value = false;
    protected boolean check_max_value = false;
    protected boolean min_alarm_on;
    protected boolean max_alarm_on;
    protected boolean date = true;
    protected int data_size;
    protected AttrQuality quality;
    protected TimeVal when;
    protected TangoAttrValue value;
    protected boolean value_flag;
    private short[] tmp_sh = new short[2];
    private int[] tmp_lo = new int[2];
    private double[] tmp_db = new double[2];
    private String[] tmp_str = new String[2];
    int dim_x;
    int dim_y;
    private int name_size;
    private String name_upper;
    protected int assoc_ind;

    public Attribute(Vector vector, Attr attr, String string) throws DevFailed {
        this.min_alarm = new TangoAttrCheckVal();
        this.max_alarm = new TangoAttrCheckVal();
        this.min_value = new TangoAttrCheckVal();
        this.max_value = new TangoAttrCheckVal();
        this.value = new TangoAttrValue();
        this.when = new TimeVal();
        this.quality = AttrQuality.ATTR_VALID;
        this.name = attr.get_name();
        this.name_size = this.name.length();
        this.name_upper = new String(this.name);
        this.name_upper.toUpperCase();
        this.data_type = attr.get_type();
        this.writable = attr.get_writable();
        this.data_format = attr.get_format();
        this.writable_attr_name = attr.get_assoc();
        switch (this.data_format.value()) {
            case 1: {
                this.max_x = ((SpectrumAttr)attr).get_max_x();
                this.max_y = 0;
                this.dim_y = 0;
                break;
            }
            case 2: {
                this.max_x = ((ImageAttr)attr).get_max_x();
                this.max_y = ((ImageAttr)attr).get_max_y();
                break;
            }
            default: {
                this.max_x = 1;
                this.max_y = 0;
                this.dim_x = 1;
                this.dim_y = 0;
            }
        }
        this.init_opt_prop(vector, string);
    }

    void add_write_value(double d) {
        this.tmp_db[1] = d;
        this.value.db_seq = this.tmp_db;
    }

    void add_write_value(int n) {
        this.tmp_lo[1] = n;
        this.value.lg_seq = this.tmp_lo;
    }

    void add_write_value(String string) {
        this.tmp_str[1] = string;
        this.value.str_seq = this.tmp_str;
    }

    void add_write_value(short s) {
        this.tmp_sh[1] = s;
        this.value.sh_seq = this.tmp_sh;
    }

    public boolean check_alarm() throws DevFailed {
        if (!this.is_alarmed()) {
            StringBuffer stringBuffer = new StringBuffer("No alarm defined for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrNoAlarm", stringBuffer.toString(), "Attribute.check_alarm");
        }
        int n = 0;
        if (this.check_min_alarm) {
            switch (this.data_type) {
                case 2: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.sh_seq[n] <= this.min_alarm.sh) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 3: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.lg_seq[n] <= this.min_alarm.lg) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 5: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.db_seq[n] <= this.min_alarm.db) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.min_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
            }
            this.min_alarm_on = false;
        }
        if (this.check_max_alarm) {
            switch (this.data_type) {
                case 2: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.sh_seq[n] >= this.max_alarm.sh) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 3: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.lg_seq[n] >= this.max_alarm.lg) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
                case 5: {
                    n = 0;
                    while (n < this.data_size) {
                        if (this.value.db_seq[n] >= this.max_alarm.db) {
                            this.quality = AttrQuality.ATTR_ALARM;
                            this.max_alarm_on = true;
                            return true;
                        }
                        ++n;
                    }
                    break;
                }
            }
            this.max_alarm_on = false;
        }
        return false;
    }

    private int find(Vector vector, String string) throws DevFailed {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (((AttrProperty)vector.elementAt(n2)).get_name().equals(string)) break;
            ++n2;
        }
        if (n2 == n) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_AttrWrongDefined", stringBuffer.toString(), "Attribute.find");
        }
        return n2;
    }

    public int get_assoc_ind() {
        return this.assoc_ind;
    }

    public String get_assoc_name() {
        return this.writable_attr_name;
    }

    private String get_attr_value(Vector vector, String string) throws DevFailed {
        int n = 0;
        try {
            n = this.find(vector, string);
        }
        catch (DevFailed devFailed) {
            StringBuffer stringBuffer = new StringBuffer("Property ");
            stringBuffer.append(string);
            stringBuffer.append(" is missing for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.get_attr_value");
        }
        return ((AttrProperty)vector.elementAt(n)).get_value();
    }

    public AttrDataFormat get_data_format() {
        return this.data_format;
    }

    public int get_data_size() {
        return this.data_size;
    }

    public int get_data_type() {
        return this.data_type;
    }

    double[] get_double_value() {
        return this.value.db_seq;
    }

    int[] get_long_value() {
        return this.value.lg_seq;
    }

    public String get_name() {
        return this.name;
    }

    int get_name_size() {
        return this.name_size;
    }

    public void get_properties(AttributeConfig attributeConfig) {
        attributeConfig.writable = this.writable;
        attributeConfig.data_format = this.data_format;
        attributeConfig.max_dim_x = this.max_x;
        attributeConfig.max_dim_y = this.max_y;
        attributeConfig.data_type = this.data_type;
        attributeConfig.name = this.name;
        attributeConfig.label = this.label;
        attributeConfig.description = this.description;
        attributeConfig.unit = this.unit;
        attributeConfig.standard_unit = this.standard_unit;
        attributeConfig.display_unit = this.display_unit;
        attributeConfig.format = this.format;
        attributeConfig.writable_attr_name = this.writable_attr_name;
        attributeConfig.min_alarm = this.min_alarm_str;
        attributeConfig.max_alarm = this.max_alarm_str;
        attributeConfig.min_value = this.min_value_str;
        attributeConfig.max_value = this.max_value_str;
        attributeConfig.extensions = new String[0];
    }

    public AttrQuality get_quality() {
        return this.quality;
    }

    short[] get_short_value() {
        return this.value.sh_seq;
    }

    String[] get_string_value() {
        return this.value.str_seq;
    }

    String get_upper_name() {
        return this.name_upper;
    }

    boolean get_value_flag() {
        return this.value_flag;
    }

    public TimeVal get_when() {
        return this.when;
    }

    public AttrWriteType get_writable() {
        return this.writable;
    }

    int get_x() {
        return this.dim_x;
    }

    int get_y() {
        return this.dim_y;
    }

    /*
     * Exception decompiling
     */
    private void init_opt_prop(Vector var1_1, String var2_2) throws DevFailed {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean is_alarmed() {
        return this.check_min_alarm || this.check_max_alarm;
    }

    public boolean is_max_alarm() {
        return this.max_alarm_on;
    }

    public boolean is_min_alarm() {
        return this.min_alarm_on;
    }

    public boolean is_writ_associated() {
        return !this.writable_attr_name.equals("None");
    }

    public void set_assoc_ind(int n) {
        this.assoc_ind = n;
    }

    private void set_data_size() {
        switch (this.data_format.value()) {
            case 0: {
                this.data_size = 1;
                break;
            }
            case 1: {
                this.data_size = this.dim_x;
                break;
            }
            case 2: {
                this.data_size = this.dim_x * this.dim_y;
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    void set_properties(AttributeConfig var1_1, String var2_2) throws DevFailed {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void set_quality(AttrQuality attrQuality) {
        this.quality = attrQuality;
    }

    private void set_time() {
        if (this.date) {
            Date date = new Date();
            long l = date.getTime();
            this.when.tv_sec = (int)(l / 1000L);
            this.when.tv_usec = (int)((l - (long)(this.when.tv_sec * 1000)) * 1000L);
            this.when.tv_nsec = 0;
        }
    }

    void set_value() throws DevFailed {
    }

    public void set_value(double d) throws DevFailed {
        double[] dArray = new double[]{d};
        this.set_value(dArray, 1, 0);
    }

    public void set_value(int n) throws DevFailed {
        int[] nArray = new int[]{n};
        this.set_value(nArray, 1, 0);
    }

    public void set_value(String string) throws DevFailed {
        String[] stringArray = new String[]{string};
        this.set_value(stringArray, 1, 0);
    }

    public void set_value(short s) throws DevFailed {
        short[] sArray = new short[]{s};
        this.set_value(sArray, 1, 0);
    }

    public void set_value(double[] dArray, int n) throws DevFailed {
        this.set_value(dArray, n, 0);
    }

    public void set_value(double[] dArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 5) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (dArray.length == this.data_size) {
                this.value.db_seq = dArray;
            } else {
                this.value.db_seq = new double[this.data_size];
                int n3 = 0;
                while (n3 < this.data_size) {
                    this.value.db_seq[n3] = dArray[n3];
                    ++n3;
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_db[0] = dArray[0];
        } else if (dArray.length == this.data_size) {
            this.value.db_seq = dArray;
        } else {
            this.value.db_seq = new double[this.data_size];
            int n4 = 0;
            while (n4 < this.data_size) {
                this.value.db_seq[n4] = dArray[n4];
                ++n4;
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(int[] nArray, int n) throws DevFailed {
        this.set_value(nArray, n, 0);
    }

    public void set_value(int[] nArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 3) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (nArray.length == this.data_size) {
                this.value.lg_seq = nArray;
            } else {
                this.value.lg_seq = new int[this.data_size];
                int n3 = 0;
                while (n3 < this.data_size) {
                    this.value.lg_seq[n3] = nArray[n3];
                    ++n3;
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_lo[0] = nArray[0];
        } else if (nArray.length == this.data_size) {
            this.value.lg_seq = nArray;
        } else {
            this.value.lg_seq = new int[this.data_size];
            int n4 = 0;
            while (n4 < this.data_size) {
                this.value.lg_seq[n4] = nArray[n4];
                ++n4;
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(String[] stringArray, int n) throws DevFailed {
        this.set_value(stringArray, n, 0);
    }

    public void set_value(String[] stringArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 8) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (stringArray.length == this.data_size) {
                this.value.str_seq = stringArray;
            } else {
                this.value.str_seq = new String[this.data_size];
                int n3 = 0;
                while (n3 < this.data_size) {
                    this.value.str_seq[n3] = stringArray[n3];
                    ++n3;
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_str[0] = stringArray[0];
        } else if (stringArray.length == this.data_size) {
            this.value.str_seq = stringArray;
        } else {
            this.value.str_seq = new String[this.data_size];
            int n4 = 0;
            while (n4 < this.data_size) {
                this.value.str_seq[n4] = stringArray[n4];
                ++n4;
            }
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.set_time();
    }

    public void set_value(short[] sArray, int n) throws DevFailed {
        this.set_value(sArray, n, 0);
    }

    public void set_value(short[] sArray, int n, int n2) throws DevFailed {
        StringBuffer stringBuffer;
        if (this.data_type != 2) {
            stringBuffer = new StringBuffer("Invalid data type for attribute ");
            stringBuffer.append(this.name);
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        if (n > this.max_x || n2 > this.max_y) {
            stringBuffer = new StringBuffer("Data size for attribute ");
            stringBuffer.append(this.name);
            stringBuffer.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.set_value");
        }
        this.dim_x = n;
        this.dim_y = n2;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (sArray.length == this.data_size) {
                this.value.sh_seq = sArray;
            } else {
                this.value.sh_seq = new short[this.data_size];
                int n3 = 0;
                while (n3 < this.data_size) {
                    this.value.sh_seq[n3] = sArray[n3];
                    ++n3;
                }
            }
        } else if (this.is_writ_associated()) {
            this.tmp_sh[0] = sArray[0];
        } else if (sArray.length == this.data_size) {
            this.value.sh_seq = sArray;
        } else {
            this.value.sh_seq = new short[this.data_size];
            int n4 = 0;
            while (n4 < this.data_size) {
                this.value.sh_seq[n4] = sArray[n4];
                ++n4;
            }
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    void set_value_flag(boolean bl) {
        this.value_flag = bl;
    }

    private void throw_err_format(String string, String string2) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("Device ");
        stringBuffer.append(string2);
        stringBuffer.append("-> Attribute");
        stringBuffer.append(this.name);
        stringBuffer.append("\nThe property ");
        stringBuffer.append(string);
        stringBuffer.append(" is defined in a unsupported format");
        Except.throw_exception("API_AttrOptProp", stringBuffer.toString(), "Attribute.throw_err_format");
    }

    public String toString() {
        AttributeConfig attributeConfig = new AttributeConfig();
        this.get_properties(attributeConfig);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute name = ");
        stringBuffer.append(attributeConfig.name);
        stringBuffer.append("\nAttribute data_type = ");
        switch (attributeConfig.data_type) {
            case 2: {
                stringBuffer.append("Tango_DevShort");
                break;
            }
            case 3: {
                stringBuffer.append("Tango_DevLong");
                break;
            }
            case 5: {
                stringBuffer.append("Tango_DevDouble");
                break;
            }
            case 8: {
                stringBuffer.append("Tango_DevString");
                break;
            }
        }
        stringBuffer.append("\nAttribute data_format = ");
        switch (attributeConfig.data_format.value()) {
            case 0: {
                stringBuffer.append("scalar");
                break;
            }
            case 1: {
                stringBuffer.append("spectrum, max_x = ");
                stringBuffer.append(attributeConfig.max_dim_x);
                break;
            }
            case 2: {
                stringBuffer.append("image, max_dim_x = ");
                stringBuffer.append(attributeConfig.max_dim_x);
                stringBuffer.append(", max_dim_y = ");
                stringBuffer.append(attributeConfig.max_dim_y);
                break;
            }
        }
        if (attributeConfig.writable == AttrWriteType.READ) {
            stringBuffer.append("\nAttribute is not writable");
        } else {
            stringBuffer.append("\nAttribute is writable");
        }
        stringBuffer.append("\nAttribute label = ");
        stringBuffer.append(attributeConfig.label);
        stringBuffer.append("\nAttribute description = ");
        stringBuffer.append(attributeConfig.description);
        stringBuffer.append("\nAttribute unit = ");
        stringBuffer.append(attributeConfig.unit);
        stringBuffer.append(", standard unit = ");
        stringBuffer.append(attributeConfig.standard_unit);
        stringBuffer.append(", display unit = ");
        stringBuffer.append(attributeConfig.display_unit);
        stringBuffer.append("\nAttribute format = ");
        stringBuffer.append(attributeConfig.format);
        stringBuffer.append("\nAttribute min alarm = ");
        stringBuffer.append(attributeConfig.min_alarm);
        stringBuffer.append("\nAttribute max alarm = ");
        stringBuffer.append(attributeConfig.max_alarm);
        stringBuffer.append("\nAttribute min value = ");
        stringBuffer.append(attributeConfig.min_value);
        stringBuffer.append("\nAttribute max value = ");
        stringBuffer.append(attributeConfig.max_value);
        stringBuffer.append("\nAttribute writable_attr_name = ");
        stringBuffer.append(attributeConfig.writable_attr_name);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    void upd_database(AttributeConfig attributeConfig, String string) throws DevFailed {
        Util.out4.println("Entering upd_database method for attribute " + this.name);
        String[] stringArray = new String[]{string, "1", this.name, "10", "description", attributeConfig.description, "label", attributeConfig.label, "unit", attributeConfig.unit, "standard_unit", attributeConfig.standard_unit, "display_unit", attributeConfig.display_unit, "format", attributeConfig.format, "min_value", attributeConfig.min_value, "max_value", attributeConfig.max_value, "min_alarm", attributeConfig.min_alarm, "max_alarm", attributeConfig.max_alarm};
        Util util = Util.instance();
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        util.get_database().command_inout("DbPutDeviceAttributeProperty", deviceData);
        Util.out4.println("Leaving upd_database method");
    }

    void wanted_date(boolean bl) {
        this.date = bl;
    }
}

