/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.util.StringTokenizer;
import pogo.gene.PogoException;

public class PogoString {
    public String str;

    public PogoString(String str) {
        this.str = new String(str);
    }

    public PogoString(byte[] b) {
        this.str = new String(b);
    }

    public void append(String newStr) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.append(newStr);
        this.str = new String(sb.toString());
    }

    public String buildDescClassFromPath(int lang) {
        if (lang == 1) {
            return this.str;
        }
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        return new String(String.valueOf(this.str.substring(0, end)) + ".h");
    }

    public String buildServerClassFromPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        String ext = this.str.substring(end, this.str.length());
        StringBuffer sb = new StringBuffer(this.str.substring(0, end));
        sb.append("Class" + ext);
        return sb.toString();
    }

    public String extractClassFromPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        int start = end;
        while (start > 0 && this.str.charAt(start) != '/') {
            --start;
        }
        if (this.str.charAt(start) == '/') {
            ++start;
        }
        return this.str.substring(start, end);
    }

    public String extractMethodCore() {
        return this.extractMethodCore(0);
    }

    public String extractMethodCore(int start) {
        start = this.inMethod(start);
        start = this.nextCr(start) + 1;
        int end = this.outMethod(start);
        while (end > start && this.str.charAt(end) != '}') {
            --end;
        }
        return this.str.substring(start, end);
    }

    public String extractPathFromFullPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '/') {
            --end;
        }
        return this.str.substring(0, end);
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer("");
        int start = this.str.indexOf("/**");
        if (start < 0) {
            start = 0;
        }
        String s = this.noEdges(start);
        StringTokenizer st = new StringTokenizer(s);
        boolean newLine = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (tmp.indexOf("@") >= 0) break;
            if (tmp.indexOf("*") >= 0) {
                newLine = true;
                sb.append("\n");
            } else {
                if (!newLine) {
                    sb.append(" ");
                }
                sb.append(tmp);
                newLine = false;
            }
            ++i;
        }
        this.str = sb.toString();
        this.str = this.noEdges();
        return this.str;
    }

    public int inMethod(int start) {
        while (this.str.charAt(start) != '{') {
            ++start;
        }
        return start;
    }

    public int inTest(int start) {
        if ((start = this.str.indexOf("if", start)) < 0) {
            return start;
        }
        start = this.str.indexOf("(", start);
        return start;
    }

    public void insert(int idx, String s) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.insert(idx, s);
        this.str = new String(sb.toString());
    }

    public int nextCr(int start) {
        while (start < this.str.length() && this.str.charAt(start) != '\n') {
            ++start;
        }
        return start;
    }

    public String noEdges() {
        return this.noEdges(0);
    }

    public String noEdges(int start) {
        int end = this.str.length() - 1;
        while (start < end && (this.str.charAt(start) < '.' || this.str.charAt(start) == '/')) {
            ++start;
        }
        while (start <= end && (this.str.charAt(end) < '.' || this.str.charAt(end) == '/')) {
            --end;
        }
        return this.str.substring(start, ++end);
    }

    public int outMethod(int start) {
        ++start;
        int cnt = 1;
        while (cnt != 0) {
            switch (this.str.charAt(start)) {
                case '{': {
                    ++cnt;
                    break;
                }
                case '}': {
                    --cnt;
                    break;
                }
            }
            ++start;
        }
        return this.nextCr(start) + 1;
    }

    public int outTest(int start) {
        ++start;
        int cnt = 1;
        while (cnt != 0) {
            switch (this.str.charAt(start)) {
                case '(': {
                    ++cnt;
                    break;
                }
                case ')': {
                    --cnt;
                    break;
                }
            }
            ++start;
        }
        return start;
    }

    public int previousCr(int start) {
        while (start >= 0 && this.str.charAt(start) != '\n') {
            --start;
        }
        return ++start;
    }

    public void replace(int start, String pattern, String newOne) throws PogoException {
        StringBuffer sb = new StringBuffer(this.str);
        int start1 = this.str.indexOf(pattern, start);
        if (start1 < 0) {
            throw new PogoException(String.valueOf(pattern) + ": Not Found !");
        }
        int end = start1 + pattern.length();
        if (newOne == null) {
            sb.replace(start1, end, "");
        } else {
            sb.replace(start1, end, newOne);
        }
        this.str = new String(sb.toString());
    }

    public void replace(String pattern, String newOne) throws PogoException {
        this.replace(0, pattern, newOne);
    }

    public String setComments() {
        StringBuffer sb = new StringBuffer("");
        int start = 0;
        int end = 0;
        int n = 0;
        while ((end = this.nextCr(start)) < this.str.length()) {
            ++end;
            if (n++ > 0) {
                sb.append(" *\t");
            }
            sb.append(this.str.substring(start, end));
            start = end;
        }
        if (n++ > 0) {
            sb.append(" *\t");
        }
        sb.append(this.str.substring(start, end));
        return sb.toString();
    }

    public String toString() {
        return this.str;
    }
}

