/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import TangoDs.TangoConst;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;

public class PogoGeneDoc
extends PogoGene
implements PogoDefs,
TangoConst {
    private PogoClass pogo;
    private String outDoc;

    public PogoGeneDoc(PogoClass pogo) {
        super(pogo);
        this.pogo = pogo;
        this.outDoc = new String(String.valueOf(pogo.output_files) + "/doc_html");
    }

    public String generate() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        System.out.println("Generating HTML Doc files...");
        this.generateProgrammersGuide();
        this.generateIndexFile();
        this.generateDescriptionFile();
        this.generateStateDescriptionFile();
        this.generateCmdListDescriptionFile();
        this.generateCmdListFile();
        this.generateCmdTableFile();
        this.generateAttributesFile();
        return "";
    }

    protected void generateAttributesFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/Attributes.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Attributes Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        fidout.write(new String("<Table Border=5 Cellpadding=6>\n").getBytes());
        fidout.write(new String("<Tr><Td>  <b>Attribute name</b>  </Td><Td>  <b>Type</b>  </Td><Td>  <b>Writable</b>  </Td></Tr>\n").getBytes());
        fidout.write(new String("\n").getBytes());
        int i = 0;
        while (i < this.pogo.attributes.size()) {
            Attrib attr = this.pogo.attributes.elementAt(i);
            fidout.write(new String("<Tr><Td>" + attr.name + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + attr.type.code_str + "</Td>").getBytes());
            fidout.write(new String("<Td>" + attr.writable + "</Td></Tr>\n\n").getBytes());
            ++i;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generateCmdListDescriptionFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/DevCommands.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n").getBytes());
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            fidout.write(new String("<A NAME=\"" + cmd.command + "\"><!-- --></A>\n").getBytes());
            fidout.write(new String("<h2>" + (i + 1) + " - " + cmd.command + "</h2>\n<ul>\n").getBytes());
            fidout.write(new String("<Li><Strong>Description: </Strong> ").getBytes());
            if (cmd.description != null) {
                fidout.write(new String(cmd.description).getBytes());
            }
            fidout.write(new String("<Br>&nbsp\n").getBytes());
            fidout.write(new String("<Li><Strong>Argin:<Br>" + cmd.argin.code_str + "</Strong>\n").getBytes());
            if (cmd.argin.description != null) {
                fidout.write(new String(" : " + cmd.argin.description).getBytes());
            }
            fidout.write(new String("<Br>&nbsp\n").getBytes());
            fidout.write(new String("<Li><Strong>Argout:<Br>" + cmd.argout.code_str + "</Strong>\n").getBytes());
            if (cmd.argout.description != null) {
                fidout.write(new String(" : " + cmd.argout.description).getBytes());
            }
            if (cmd.notAllowedFor != null) {
                fidout.write(new String("<Br>&nbsp\n").getBytes());
                fidout.write(new String("<Li><Strong>Command allowed for: </Strong><Ul>\n").getBytes());
                int idx = 0;
                while (idx < this.pogo.states.size()) {
                    DevState st = this.pogo.states.elementAt(idx);
                    boolean found = false;
                    int alIdx = 0;
                    while (alIdx < cmd.notAllowedFor.size()) {
                        DevState st1 = cmd.notAllowedFor.elementAt(alIdx);
                        if (st1.name.equals(st.name)) {
                            found = true;
                        }
                        ++alIdx;
                    }
                    if (!found) {
                        fidout.write(new String("<Li>" + st.name).getBytes());
                    }
                    ++idx;
                }
                fidout.write(new String("</Ul>\n").getBytes());
            } else {
                fidout.write(new String("<Li><Strong>Command allowed for all device states.</Strong><Br>\n").getBytes());
            }
            fidout.write(new String("</ul><Br>\n<Br>\n").getBytes());
            ++i;
        }
        fidout.close();
    }

    protected void generateCmdListFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/DevCommandsList.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(new String("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n").getBytes());
        fidout.write(new String("<HTML><HEAD>\n").getBytes());
        fidout.write(new String("<TITLE>Commands\n</TITLE></HEAD>\n").getBytes());
        fidout.write(new String("<BODY BGCOLOR=\"white\">\n").getBytes());
        fidout.write(new String("<FONT size=\"+1\" ID=\"FrameHeadingFont\">\n").getBytes());
        fidout.write(new String("<B>Commands</B></FONT>\n").getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n").getBytes());
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            fidout.write(new String("<A Href=\"DevCommands.html#" + cmd.command + "\" TARGET=\"DevCommands\"> " + cmd.command + "</a><Br>\n").getBytes());
            ++i;
        }
        fidout.write(new String("<Br>\n<Br>\n<A Href=\"DevCommandsTable.html\" TARGET=\"DevCommands\"> Abstract </a><Br>\n").getBytes());
        fidout.close();
        this.copyFile(new String(String.valueOf(this.pogo.templates_dir) + "/html/frame.html"), new String(String.valueOf(this.outDoc) + "/DevCommandsFrame.html"));
    }

    protected void generateCmdTableFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/DevCommandsTable.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n").getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        fidout.write(new String("<Table Border=5 Cellpadding=6>\n").getBytes());
        fidout.write(new String("<Tr><Td>  <b>Command name</b>  </Td>\n").getBytes());
        fidout.write(new String("<Td>  <b>Argin Type</b>  </Td>\n").getBytes());
        fidout.write(new String("<Td>  <b>Argout Type</b>  </Td>\n").getBytes());
        fidout.write(new String("</Td></Tr>\n").getBytes());
        fidout.write(new String("\n").getBytes());
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            fidout.write(new String("<Tr><Td>" + cmd.command + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + cmd.argin.code_str + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + cmd.argout.code_str + "</Td>\n").getBytes());
            ++i;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generateDescriptionFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/Description.html");
        if (new File(f_out).exists()) {
            return;
        }
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> <Br> <Br> <Br>\n").getBytes());
        fidout.write(new String("This Page Must Be Filled by <Br>\n").getBytes());
        fidout.write(new String("The Programmer\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generateIndexFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/index.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/index.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.classDescRes, this.pogo.class_desc);
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    private String generateProgrammersGuide() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        String str;
        String cmd;
        switch (this.pogo.language) {
            case 1: {
                this.makeDocDir();
                String header = new String(this.pogo.class_name);
                String geneProc = "javadoc -private -author ";
                StringBuffer sb = new StringBuffer(String.valueOf(this.pogo.output_files) + "/" + this.pogo.class_name + PogoDefs.javaExtention);
                sb.append(" " + this.pogo.output_files + "/" + this.pogo.class_name + "Class" + PogoDefs.javaExtention);
                int i = 0;
                while (i < this.pogo.commands.size()) {
                    Cmd c = this.pogo.commands.cmdIdx(i);
                    sb.append(" " + this.pogo.output_files + "/" + c.cmd_class + PogoDefs.javaExtention);
                    ++i;
                }
                String inFile = sb.toString();
                cmd = new String(String.valueOf(geneProc) + " -windowtitle " + header + " -header " + header + " -d " + this.outDoc + " " + inFile);
                break;
            }
            case 2: {
                String docPath = System.getProperty("CPP_DOC_PATH");
                if (docPath == null) {
                    throw new PogoException("CPP_DOC_PATH not Set");
                }
                String geneProc = new String(String.valueOf(docPath) + "/doc++/bin/doc++");
                String dummy = new String(String.valueOf(docPath) + "/tool/dummy");
                String inFile = new String(String.valueOf(this.pogo.output_files) + "/" + this.pogo.class_name + ".h");
                cmd = new String(String.valueOf(geneProc) + " -p -H -B " + dummy + " -d " + this.outDoc + " " + inFile);
                break;
            }
            default: {
                return "Languange not supported !";
            }
        }
        System.out.println("\n" + cmd + "\n");
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        StringBuffer sb = new StringBuffer("Generating Doc:\n\n");
        while ((str = br.readLine()) != null) {
            sb.append(String.valueOf(str) + "\n");
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            throw new PogoException("Programmer's guide generation returns : " + retVal + " !");
        }
        System.out.println(sb);
        File file = new File(String.valueOf(this.outDoc) + "/index.html");
        file.renameTo(new File(String.valueOf(this.outDoc) + "/pg_index.html"));
        return sb.toString();
    }

    protected void generateStateDescriptionFile() throws IOException, PogoException {
        String f_in = new String(String.valueOf(this.pogo.templates_dir) + "/html/page.html");
        String f_out = new String(String.valueOf(this.outDoc) + "/TangoDevStates.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device States Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        fidout.write(new String("<Table Border=5 Cellpadding=6>\n").getBytes());
        fidout.write(new String("<Tr><Td>  <b>State name</b>  </Td><Td>  <b>Description</b>  </Td></Tr>\n").getBytes());
        fidout.write(new String("\n").getBytes());
        int i = 0;
        while (i < this.pogo.states.size()) {
            DevState state = this.pogo.states.elementAt(i);
            fidout.write(new String("<Tr><Td>" + state.name + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + state.description + "</Td></Tr>\n\n").getBytes());
            ++i;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    private void makeDocDir() {
        String cmd = new String("mkdir " + this.outDoc);
        System.out.println("\n" + cmd + "\n");
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        catch (InterruptedException ex) {
            System.out.println(ex);
        }
    }
}

