/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class PogoClass
implements PogoDefs,
TangoConst {
    public String title;
    public String class_name;
    public String class_desc;
    public String output_files;
    public String templates_dir;
    public CmdTable commands;
    public AttribTable attributes;
    public DevStateTable states;
    public int language;
    public int in_language;
    public String author;
    public String revision;

    public PogoClass(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int ext_idx = filename.length() - 1;
        while (ext_idx > 0 && filename.charAt(ext_idx) != '.') {
            --ext_idx;
        }
        if (ext_idx == 0) {
            throw new PogoException(String.valueOf(filename) + ": Not Available File's Name !");
        }
        String ext = filename.substring(ext_idx);
        this.author = new String("");
        this.revision = new String("");
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
        this.initializePogoFromSrcFile(filename, ext);
    }

    public PogoClass(String className, String classDesc, Vector cmdVect, Vector attrVect, Vector statesVector) throws PogoException {
        this.class_name = new String(className);
        if (classDesc != null) {
            this.class_desc = new String(classDesc);
        }
        this.output_files = new String(".");
        this.author = new String("");
        this.revision = new String("");
        this.commands = new CmdTable(cmdVect);
        this.attributes = new AttribTable(attrVect);
        this.states = new DevStateTable(statesVector);
        this.language = 1;
        this.in_language = 1;
        this.templates_dir = System.getProperty("TEMPL_HOME");
        if (this.templates_dir == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
    }

    public void addAttribute(Attrib attr) {
        this.attributes.addElement(attr);
    }

    public void addCommand(Cmd cmd) {
        this.commands.addElement(cmd);
    }

    public void addState(DevState st) {
        this.states.addElement(st);
    }

    private void getTheClassDescription(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        int start = str.indexOf(PogoDefs.classDescRes);
        if (start < 0) {
            this.class_desc = "";
            return;
        }
        int end = str.indexOf("*/", start += PogoDefs.classDescRes.length());
        if (end < 0) {
            this.class_desc = "";
            return;
        }
        PogoString comments = new PogoString(str.substring(start, end));
        this.class_desc = comments.getDescription();
    }

    private void getTheProjectTitle(String filename) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        int start = str.indexOf(PogoDefs.projectTitleRes);
        if (start < 0) {
            System.out.println("WARNING: '" + PogoDefs.projectTitleRes + "' Not Found in " + filename);
            return;
        }
        int end = str.indexOf("\n", start += PogoDefs.projectTitleRes.length());
        this.title = new String(str.substring(start, end).trim());
        start = str.indexOf(PogoDefs.authorRes);
        if (start < 0) {
            return;
        }
        end = str.indexOf("$", start += PogoDefs.authorRes.length());
        this.author = new String(str.substring(start, end).trim());
        start = str.indexOf(PogoDefs.revisionRes);
        if (start < 0) {
            return;
        }
        end = str.indexOf("$", start += PogoDefs.revisionRes.length());
        this.revision = new String(str.substring(start, end).trim());
    }

    private void initializePogoFromSrcFile(String filename, String ext) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString pogo_fname = new PogoString(filename);
        this.class_name = pogo_fname.extractClassFromPath();
        String server_class = pogo_fname.buildServerClassFromPath();
        if (ext.equals(PogoDefs.javaExtention)) {
            this.language = 1;
            this.in_language = 1;
        } else if (ext.equals(PogoDefs.cppExtention)) {
            this.language = 2;
            this.in_language = 2;
        } else {
            throw new PogoException("File's extention unknown !");
        }
        this.output_files = new String(".");
        this.commands = new CmdTable(server_class);
        String descClassFile = pogo_fname.buildDescClassFromPath(this.in_language);
        this.commands.getDescriptions(descClassFile, server_class, this.in_language);
        this.states = new DevStateTable(descClassFile);
        this.attributes = new AttribTable(filename, this.in_language);
        this.getTheProjectTitle(descClassFile);
        this.getTheClassDescription(descClassFile);
    }

    public void setAuthor(String name) {
        this.author = new String(name);
    }

    public void setRevision(String vers) {
        this.revision = new String(vers);
    }

    public void setTitle(String projTitle) {
        this.title = new String(projTitle);
    }
}

