/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class CmdTable
implements PogoDefs {
    public Vector vect = new Vector();

    public CmdTable(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int start;
        String add_list_str;
        int lang;
        if (filename.indexOf(PogoDefs.cppExtention) > 0) {
            lang = 2;
            add_list_str = new String(PogoDefs.cppAddCommands);
        } else if (filename.indexOf(PogoDefs.javaExtention) > 0) {
            lang = 1;
            add_list_str = new String(PogoDefs.javaAddCommands);
        } else {
            throw new PogoException("Unrecognised file type !");
        }
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        this.createDummyStatusCmd();
        int i = start = str.indexOf(PogoDefs.dataStartCmd) + PogoDefs.dataStartCmd.length();
        while ((i = str.indexOf(add_list_str, i)) > 0) {
            start = str.indexOf(PogoDefs.NEW_STR, i) + PogoDefs.NEW_STR.length();
            while (str.charAt(start) <= ' ') {
                ++start;
            }
            int end = str.indexOf(59, start);
            Cmd cmd = new Cmd(str.substring(start, end));
            switch (lang) {
                case 2: {
                    cmd.setNotAllowedFor(str, lang);
                    break;
                }
                case 1: {
                    String path = new PogoString(filename).extractPathFromFullPath();
                    fid = new FileInputStream(new String(String.valueOf(path) + "/" + cmd.cmd_class + PogoDefs.javaExtention));
                    nb = fid.available();
                    inStr = new byte[nb];
                    fid.read(inStr);
                    String strCmd = new String(inStr);
                    fid.close();
                    cmd.setNotAllowedFor(strCmd, lang);
                    break;
                }
            }
            this.vect.addElement(cmd);
            ++i;
        }
    }

    public CmdTable(Vector v_in) {
        if (this.vect.size() == 0) {
            this.createDummyStatusCmd();
        }
        int i = 2;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public void addElement(Cmd cmd) {
        this.vect.addElement(cmd);
    }

    public String buildCommandFactoryMethod(int lang) throws PogoException {
        StringBuffer sb = new StringBuffer("{\n");
        int i = 2;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            sb.append(cmd.AddCmdObjectList(lang));
            ++i;
        }
        if (lang == 1) {
            sb.append("\t");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public Cmd cmdIdx(int idx) {
        return (Cmd)this.vect.elementAt(idx);
    }

    private void createDummyStatusCmd() {
        this.vect.addElement(new Cmd("DevState", "DevStateCmd", "Tango_DEV_VOID", "Tango_DEV_STATE", "", "State Code", "command to read the device state"));
        this.vect.addElement(new Cmd("DevStatus", "DevStatusCmd", "Tango_DEV_VOID", "Tango_DEV_STRING", "", "Status descrition", "command to read the device status"));
    }

    public void getDescriptions(String descFile, String serverClass, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String path = new PogoString(descFile).extractPathFromFullPath();
        int i = 2;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            switch (lang) {
                case 2: {
                    cmd.checkCppExecCmdMethodName(serverClass);
                    break;
                }
                case 1: {
                    String cmdFile = new String(String.valueOf(path) + "/" + cmd.cmd_class + PogoDefs.javaExtention);
                    cmd.checkJavaExecCmdMethodName(cmdFile);
                    break;
                }
                default: {
                    return;
                }
            }
            ++i;
        }
        FileInputStream fid = new FileInputStream(descFile);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        int i2 = 2;
        while (i2 < this.vect.size()) {
            System.out.println(this.cmdIdx((int)i2).command);
            this.cmdIdx(i2).getExecMethodDescription(str, lang);
            ++i2;
        }
    }

    public int size() {
        return this.vect.size();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.vect.size()) {
            Cmd cmd = this.cmdIdx(i);
            buff.append("--------------------------------------------\n");
            buff.append(String.valueOf(cmd.command) + ", " + cmd.cmd_class + ", " + cmd.argin.code_str + ", " + cmd.argout.code_str);
            if (cmd.argin.description != null) {
                buff.append(",\n\t" + cmd.argin.description + "\n\t" + cmd.argout.description + "\n");
            } else {
                buff.append("\n");
            }
            ++i;
        }
        String str = new String(buff);
        return str;
    }

    public String toString(int idx) throws PogoException {
        if (idx >= this.vect.size()) {
            throw new PogoException("Command index out of bounds !");
        }
        Cmd cmd = this.cmdIdx(idx);
        String str = new String(String.valueOf(cmd.command) + ", " + cmd.cmd_class + ", " + cmd.argin.code_str + ", " + cmd.argout.code_str);
        return str;
    }
}

