/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Cmd
implements TangoConst,
PogoDefs {
    public String command;
    public String description;
    public String exec_method;
    public String cmd_class;
    public TangoTypes argin;
    public TangoTypes argout;
    public DevStateTable notAllowedFor;

    public Cmd(String cmdLine) throws PogoException {
        int end = cmdLine.indexOf("(");
        this.cmd_class = new String(cmdLine.substring(0, end));
        int start = cmdLine.indexOf("\"") + 1;
        end = cmdLine.indexOf("\"", start);
        this.command = new String(cmdLine.substring(start, end));
        this.exec_method = this.buildExecCmdMethodName();
        start = cmdLine.indexOf(",", start) + 1;
        end = cmdLine.indexOf(",", start);
        String tmp = cmdLine.substring(start, end);
        this.argin = new TangoTypes(new PogoString(tmp).noEdges(), "");
        start = end + 1;
        end = cmdLine.indexOf(",", start);
        if (end < 0) {
            end = cmdLine.indexOf(")", start);
        }
        tmp = cmdLine.substring(start, end);
        this.argout = new TangoTypes(new PogoString(tmp).noEdges(), "");
        end = cmdLine.indexOf(",", start);
        if (end > 0) {
            start = cmdLine.indexOf("\"", start) + 1;
            end = cmdLine.indexOf("\",", start);
            this.argin.setDescription(cmdLine.substring(start, end));
            start = cmdLine.indexOf("\"", end += "\",".length()) + 1;
            end = cmdLine.indexOf("\")", start);
            this.argout.setDescription(cmdLine.substring(start, end));
        }
        this.notAllowedFor = new DevStateTable();
    }

    public Cmd(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc) {
        this.command = new String(name);
        this.cmd_class = new String(cc);
        this.exec_method = this.buildExecCmdMethodName();
        this.argin = new TangoTypes(in_type, in_desc);
        this.argout = new TangoTypes(out_type, out_desc);
        this.notAllowedFor = new DevStateTable();
        if (desc != null) {
            this.description = new String(desc);
        }
    }

    public String AddCmdObjectList(int lang) {
        String add_list_str = lang == 1 ? PogoDefs.javaAddCommands : PogoDefs.cppAddCommands;
        String tab0 = lang == 1 ? "\t\t" : "\t";
        String tab = lang == 1 ? "\t\t\t" : "\t\t";
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(tab0) + add_list_str + "(new " + this.cmd_class + "(\"" + this.command + "\",\n" + tab + this.argin.code_str + ", " + this.argout.code_str + ",\n" + tab);
        if (this.argin.description == null) {
            sb.append("\"\",\n" + tab);
        } else {
            sb.append("\"" + this.argin.description + "\",\n" + tab);
        }
        if (this.argout.description == null) {
            sb.append("\"\"));\n");
        } else {
            sb.append("\"" + this.argout.description + "\"));\n");
        }
        return sb.toString();
    }

    public void addNotAllowedFor(DevState state) {
        this.notAllowedFor.addElement(state);
    }

    /*
     * Unable to fully structure code
     */
    public String buildCppCmdClassBlock(String str, String class_name) throws PogoException {
        end = str.indexOf("extract");
        if (end >= 0) ** GOTO lbl5
        throw new PogoException("Input File Syntax error 1!");
lbl-1000:
        // 1 sources

        {
            --end;
lbl5:
            // 2 sources

            ** while (str.charAt((int)end) != '\n')
        }
lbl6:
        // 1 sources

        sb = new StringBuffer(str.substring(0, ++end));
        if (this.argin.code != 0) {
            sb.append("\t" + this.argin.cpp + "\t");
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append("*");
            }
            sb.append("argin;\n");
            sb.append("\textract(in_any, argin);\n\n");
        }
        sb.append("\t");
        if (this.argout.code != 0) {
            sb.append("return insert");
        }
        sb.append("((static_cast<" + class_name + " *>(device))->" + this.exec_method + "(");
        if (this.argin.code != 0) {
            sb.append("argin");
        }
        sb.append("));\n");
        if (this.argout.code == 0) {
            sb.append("\treturn new CORBA_Any();\n");
        }
        sb.append("}\n\n");
        return sb.toString();
    }

    public String buildCppCmdClassDefs(String str) {
        int end;
        StringBuffer sb = new StringBuffer("");
        int start = 0;
        while ((end = str.indexOf(PogoDefs.templateCmd, start)) > 0) {
            sb.append(str.substring(start, end));
            sb.append(this.cmd_class);
            start = end + PogoDefs.templateCmd.length();
            ++end;
        }
        sb.append(String.valueOf(str.substring(start)) + "\n\n");
        return sb.toString();
    }

    public String buildCppCmdProtypes() {
        StringBuffer sb = new StringBuffer("/**\n * ");
        if (this.description != null) {
            sb.append(new PogoString(this.description).setComments());
        }
        if (this.argin.code != 0) {
            sb.append("\n *\t@param\targin\t");
            if (this.argin.description != null) {
                sb.append(new PogoString(this.argin.description).setComments());
            }
        }
        if (this.argout.code != 0) {
            sb.append("\n *\t@return\t");
            if (this.argout.description != null) {
                sb.append(new PogoString(this.argout.description).setComments());
            }
        }
        sb.append("\n *\t@exception DevFailed");
        sb.append("\n */\n");
        sb.append("\t" + this.argout.cpp + "\t");
        if (this.argout.code == 8) {
            sb.append("&");
        } else if (this.argout.need_constr || this.argout.is_array) {
            sb.append("*");
        }
        sb.append(String.valueOf(this.exec_method) + "(");
        if (this.argin.code != 0) {
            sb.append(this.argin.cpp);
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append(" *");
            }
        }
        sb.append(");\n");
        return sb.toString();
    }

    public String buildCppExecCmdMethod(String class_name) {
        StringBuffer sb = new StringBuffer(String.valueOf(this.buildCppExecCmdMethodLine(class_name)) + "\n{\n");
        if (this.argout.code != 0) {
            sb.append("\t" + this.argout.cpp + "\t");
            if (this.argout.need_constr || this.argout.is_array) {
                sb.append("*");
            }
            sb.append("argout");
            if (this.argout.need_constr) {
                sb.append(" = new " + this.argout.cpp + "()");
            }
            sb.append(";\n");
        }
        sb.append("\tcout1 << \"" + class_name + "::" + this.exec_method + "(): entering... !\" << endl;\n");
        sb.append("\n\t//\tAdd your own code to control device here\n\n");
        if (this.argout.code != 0) {
            if (this.argout.code == 8) {
                sb.append("\treturn *argout;\n");
            } else {
                sb.append("\treturn argout;\n");
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String buildCppExecCmdMethodComments(String class_name) {
        StringBuffer sb = new StringBuffer("");
        sb.append("//+------------------------------------------------------------------\n");
        sb.append("/**\n");
        sb.append(" *\tmethod:\t" + class_name + "::" + this.exec_method + "\n");
        sb.append(" *\n");
        sb.append(" *\tdescription:\tmethod to execute \"" + this.command + "\"\n");
        if (this.description != null && this.description.length() > 0) {
            sb.append(" *\t" + new PogoString(this.description).setComments() + "\n");
        }
        sb.append(" *\n");
        if (this.argin.code != 0) {
            sb.append(" * @param\targin\t" + this.argin.description + "\n");
        }
        if (this.argout.code != 0) {
            sb.append(" * @return\t" + this.argout.description + "\n");
        }
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("//+------------------------------------------------------------------\n");
        return sb.toString();
    }

    public String buildCppExecCmdMethodLine(String class_name) {
        StringBuffer sb = new StringBuffer(String.valueOf(this.argout.cpp) + " ");
        if (this.argout.code == 8) {
            sb.append("&");
        } else if (this.argout.is_array) {
            sb.append("*");
        }
        sb.append(String.valueOf(class_name) + "::" + this.exec_method + "(");
        if (this.argin.code != 0) {
            sb.append(String.valueOf(this.argin.cpp) + " ");
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append("*");
            }
            sb.append("argin");
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildExecCmdMethodName() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.command.length()) {
            if (this.command.charAt(i) >= 'A' && this.command.charAt(i) <= 'Z') {
                if (i > 0 && (this.command.charAt(i - 1) < 'A' || this.command.charAt(i - 1) > 'Z')) {
                    sb.append('_');
                }
                sb.append((char)(this.command.charAt(i) + 32));
            } else {
                sb.append(this.command.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String buildIsAllowedMethod(PogoString method, int lang) throws PogoException {
        int start = method.str.indexOf(PogoDefs.endGeneTag);
        if (start < 0) {
            throw new PogoException("\"" + PogoDefs.endGeneTag + "\" Not Found !");
        }
        int end = method.str.indexOf(PogoDefs.startGeneTag);
        if (end < 0) {
            throw new PogoException("\"" + PogoDefs.startGeneTag + "\" Not Found !");
        }
        start = method.previousCr(start);
        end = method.nextCr(end) + 1;
        String nonAuto = method.str.substring(start, end);
        if (this.notAllowedFor == null || this.notAllowedFor.size() == 0) {
            StringBuffer sb = new StringBuffer("{\n" + nonAuto + "\t\treturn true;\n");
            if (lang == 1) {
                sb.append("\t");
            }
            sb.append("}\n");
            return sb.toString();
        }
        StringBuffer head = new StringBuffer("{\n\t");
        if (lang == 1) {
            head.append("\t");
        }
        head.append("if (");
        int i = 0;
        while (i < this.notAllowedFor.size()) {
            DevState state = this.notAllowedFor.elementAt(i);
            if (lang == 1) {
                head.append("device.get_state() == " + state.javaName());
            } else {
                head.append("device->get_state() == " + state.name);
            }
            if (i < this.notAllowedFor.size() - 1) {
                head.append("  ||\n\t\t");
                if (lang == 1) {
                    head.append("\t");
                }
            }
            ++i;
        }
        if (lang == 1) {
            head.append(")\n\t\t{\n");
        } else {
            head.append(")\n\t{\n");
        }
        StringBuffer foot = new StringBuffer("");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\t\treturn false;\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\t}\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\treturn true;\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("}\n");
        return new String(String.valueOf(head.toString()) + nonAuto + foot.toString());
    }

    public String buildJavaExecCmdMethod() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.buildJavaExecCmdMethodLine()) + "\n\t{\n");
        if (this.argout.code != 0) {
            sb.append("\t\t" + this.argout.java + "\targout = ");
            if (this.argout.is_array) {
                sb.append("new " + this.argout.java);
                sb.insert(sb.length() - 1, '5');
                sb.append(";\n\n");
            } else if (this.argout.need_constr) {
                sb.append("new " + this.argout.java + "();\n\n");
            } else {
                sb.append(" (" + this.argout.java + ")0;\n\n");
            }
        }
        sb.append("\t\tTangoUtil.out2.println(\"Entering " + this.exec_method + "()\");\n");
        sb.append("\n\t\t// ---Add your Own code to control device here ---\n\n");
        sb.append("\t\tTangoUtil.out2.println(\"Exiting " + this.exec_method + "()\");\n");
        if (this.argout.code != 0) {
            sb.append("\t\treturn argout;\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    public String buildJavaExecCmdMethodComments() {
        StringBuffer sb = new StringBuffer("\n\n");
        sb.append("//===============================================================\n");
        sb.append("/**\n");
        sb.append(" *\tExecute command \"" + this.command + "\" on device.\n");
        if (this.description != null && this.description.length() > 0) {
            sb.append(" *\t" + new PogoString(this.description).setComments() + "\n");
        }
        sb.append(" *\n");
        if (!this.argin.java.equals("void")) {
            sb.append(" * @param\targin\t" + this.argin.description + "\n");
        }
        if (!this.argout.java.equals("void")) {
            sb.append(" * @return\t" + this.argout.description + "\n");
        }
        sb.append(" */\n");
        sb.append("//===============================================================\n");
        return sb.toString();
    }

    public String buildJavaExecCmdMethodLine() {
        StringBuffer sb = new StringBuffer("\tpublic ");
        sb.append(String.valueOf(this.argout.java) + " " + this.exec_method + "(");
        if (this.argin.code != 0) {
            sb.append(String.valueOf(this.argin.java) + " argin");
        }
        sb.append(") throws DevFailed");
        return sb.toString();
    }

    public String buildJavaExecuteMethodBlock(String class_name) {
        StringBuffer sb = new StringBuffer("");
        String indent = new String("\t\t");
        if (this.argin.code != 0) {
            sb.append(String.valueOf(indent) + this.argin.java + " argin = " + this.argin.javaExtract() + "(in_any);\n");
        }
        if (!this.argout.java.equals("void")) {
            sb.append(String.valueOf(indent) + "return insert(");
        } else {
            sb.append(indent);
        }
        sb.append("((" + class_name + ")(device))." + this.exec_method + "(");
        if (!this.argin.java.equals("void")) {
            sb.append("argin");
        }
        if (!this.argout.java.equals("void")) {
            sb.append("));\n");
        } else {
            sb.append(");\n" + indent + "return insert();\n");
        }
        return sb.toString();
    }

    public void checkCppExecCmdMethodName(String filename) throws PogoException {
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            fid.read(inStr);
            String str = new String(inStr);
            fid.close();
            String pattern = new String(String.valueOf(this.cmd_class) + "::execute");
            int start = str.indexOf(pattern);
            if (start < 0) {
                System.out.println(String.valueOf(pattern) + "\nClass not found -> does'nt change name !");
                return;
            }
            if ((start = str.indexOf("static_cast", start)) < 0) {
                System.out.println("insert not found -> does'nt change name !");
                return;
            }
            int end = str.indexOf(";", start);
            String line = str.substring(start, end);
            String name = line.substring(start = line.indexOf("->") + 2, end = line.indexOf("(", start)).trim();
            if (!this.exec_method.equals(name)) {
                System.out.println(String.valueOf(name) + ": Not conventionnal name !");
                System.out.println("It should be :   " + this.exec_method + "()...");
                this.exec_method = new String(name);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (SecurityException securityException) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (IOException iOException) {
            System.out.println("File Not Found Do not change exec method name");
        }
    }

    public void checkJavaExecCmdMethodName(String filename) throws PogoException {
        try {
            int start;
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            fid.read(inStr);
            String str = new String(inStr);
            fid.close();
            String pattern = new String(")(device)).");
            int end = 0;
            while ((start = str.indexOf(pattern, end)) > 0) {
                String name;
                if (this.exec_method.equals(name = str.substring(start += pattern.length(), end = str.indexOf("(", start)).trim())) continue;
                System.out.println("\"" + this.exec_method + "\"");
                this.exec_method = new String(name);
                System.out.println(String.valueOf(this.exec_method) + ": Not conventionnal name !\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (SecurityException securityException) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (IOException iOException) {
            System.out.println("File Not Found Do not change exec method name");
        }
    }

    public boolean execMethodArgsChanged(String line, int lang) {
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken().toString();
        String argout = lang == 1 ? st.nextToken().toString() : s;
        int start = line.indexOf("(") + 1;
        int end = line.indexOf(")");
        String s1 = line.substring(start, end);
        StringTokenizer st1 = new StringTokenizer(s1);
        String argin = st1.countTokens() > 0 ? st1.nextToken().toString() : new String("void");
        switch (lang) {
            case 1: {
                return !this.argin.java.equals(argin) || !this.argout.java.equals(argout);
            }
            case 2: {
                if (!this.argin.cpp.equals(argin)) {
                    System.out.println("ARGIN CHANGED " + argin + " - " + this.argin.cpp);
                }
                if (!this.argout.cpp.equals(argout)) {
                    System.out.println("ARGOUT CHANGED " + argout + " - " + this.argout.cpp);
                }
                return !this.argin.cpp.equals(argin) || !this.argout.cpp.equals(argout);
            }
        }
        return false;
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void getExecMethodDescription(String str, int lang) {
        isComments = true;
        pgs = new PogoString(str);
        end = 0;
        while (end >= 0 && isComments) {
            if ((end = pgs.str.indexOf(this.exec_method, end)) < 0) {
                System.out.println(String.valueOf(this.exec_method) + " Not found !");
                return;
            }
            start = pgs.previousCr(end);
            if (pgs.str.substring(start, end).indexOf("//") < 0) {
                isComments = false;
            }
            ++end;
        }
        if (end < 0) {
            System.out.println(String.valueOf(this.exec_method) + " Not found !");
            return;
        }
        start = end = pgs.previousCr(end);
        cfr_temp_0 = 0;
        do {
            block0 : switch (cfr_temp_0 == 0 ? lang : cfr_temp_0) {
                case 2: {
                    while (true) {
                        if (start <= 0 || pgs.str.charAt(start) == ';' || pgs.str.charAt(start) == '{') {
                            ++start;
                            break block0;
                        }
                        --start;
                    }
                }
                while (true) {
                    cfr_temp_0 = 1;
                    --start;
                    break;
                }
                case 1: {
                    if (start > 0 && pgs.str.charAt(start) != '}') ** continue;
                    if ((start1 = pgs.str.indexOf("Execute command", ++start)) >= 0) {
                        start = pgs.nextCr(start1);
                    }
                    end = pgs.str.indexOf("*/", start);
                }
            }
            break;
        } while (true);
        comments = new PogoString(pgs.str.substring(start, end));
        this.description = comments.getDescription();
    }

    public boolean isExecMethod(String line) {
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken().toString();
        int end = s.indexOf("(");
        if (end > 0) {
            s = s.substring(0, end);
        }
        return s.equals(this.exec_method);
    }

    public void removeNotAllowedFor(DevState state) {
        this.notAllowedFor.remove(state);
    }

    public void setDescription(String str) {
        this.description = new String(str);
    }

    public void setNotAllowedFor(String str, int lang) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        PogoString pgs = new PogoString(str);
        String pattern = lang == 1 ? new String("public boolean is_allowed(DeviceImpl device, Any data_in)") : new String(String.valueOf(this.cmd_class) + "::is_allowed");
        int start = pgs.str.indexOf(pattern);
        if (start < 0) {
            System.out.println("WARNING: " + pattern + " Not Found !");
            return;
        }
        start = pgs.inMethod(start);
        int end = pgs.outMethod(start + 1);
        PogoString method = new PogoString(pgs.str.substring(start, end));
        if ((start = method.inTest(0)) < 0) {
            return;
        }
        end = method.outTest(start);
        if (end < 0) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(method.str.substring(start + 1, end - 1));
        int i = 0;
        while (stk.hasMoreTokens()) {
            String s = stk.nextToken();
            switch (lang) {
                case 2: {
                    if (s.indexOf("Tango_") != 0) break;
                    this.notAllowedFor.addElement(new DevState(s, ""));
                    break;
                }
                case 1: {
                    String tag = new String("DevState.");
                    if (s.indexOf(tag) != 0) break;
                    String stName = new String("Tango_" + s.substring(tag.length()));
                    this.notAllowedFor.addElement(new DevState(stName, ""));
                    break;
                }
            }
            ++i;
        }
    }

    public void setNotAllowedFor(DevStateTable stTable) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        int i = 0;
        while (i < stTable.size()) {
            this.notAllowedFor.addElement(stTable.elementAt(i));
            ++i;
        }
    }

    public String toString() {
        return this.command;
    }

    public void updateCppExecCmdMethodComments(PogoString codeStr, String class_name) throws PogoException {
        int startMethod;
        boolean methodExists = false;
        int endLine = 0;
        String line = this.buildCppExecCmdMethodLine(class_name);
        System.out.println(line);
        int sl = line.indexOf("(");
        int el = line.indexOf(" ", sl);
        if (el < 0) {
            el = sl + 1;
        }
        line = line.substring(0, el);
        while ((startMethod = codeStr.str.indexOf(line, endLine)) >= 0) {
            String s;
            if ((startMethod = codeStr.previousCr(startMethod)) > (endLine = codeStr.nextCr(startMethod))) {
                System.out.println("\n1:\n" + startMethod + " - " + endLine);
                System.out.println(String.valueOf(line) + "\n\n");
            }
            if ((s = codeStr.str.substring(startMethod, endLine)).indexOf("//") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("<<") >= 0) continue;
            methodExists = true;
            break;
        }
        String newHeader = this.buildCppExecCmdMethodComments(class_name);
        if (methodExists) {
            int startHeader = startMethod;
            while (startHeader > 0 && codeStr.str.charAt(startHeader) != '}') {
                --startHeader;
            }
            if ((startHeader = codeStr.str.indexOf("//", startHeader)) < 0) {
                startHeader = startMethod;
            }
            String oldHeader = codeStr.str.substring(startHeader, startMethod);
            codeStr.replace(startHeader, oldHeader, newHeader);
        } else {
            codeStr.append(newHeader);
        }
    }
}

