/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Attrib;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class AttribTable
implements PogoDefs {
    public Vector vect = new Vector();

    public AttribTable() {
    }

    public AttribTable(String filename, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        PogoString pogo_fname = new PogoString(filename);
        String class_name = pogo_fname.extractClassFromPath();
        String server_class = pogo_fname.buildServerClassFromPath();
        String descClassFile = pogo_fname.buildDescClassFromPath(lang);
        System.out.println("descClassFile:\t" + descClassFile);
        this.readAttributeFactory(server_class);
        if (this.size() > 0) {
            this.readAttributeTypes(descClassFile, lang);
        }
    }

    public AttribTable(Vector v_in) {
        int i = 0;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public void addElement(Attrib st) {
        this.vect.addElement(st);
    }

    public String buildFactory(int lang) {
        String addKeyWord = lang == 1 ? PogoDefs.javaAddAttrib : PogoDefs.cppAddAttrib;
        String tab = lang == 1 ? "\t" : "";
        StringBuffer sb = new StringBuffer(String.valueOf(tab) + "{\n");
        int i = 0;
        while (i < this.size()) {
            Attrib attr = this.elementAt(i);
            sb.append(String.valueOf(tab) + "\t" + addKeyWord + "(\"" + attr.name + "\");\n");
            ++i;
        }
        sb.append(String.valueOf(tab) + "}\n");
        return sb.toString();
    }

    public Attrib elementAt(int idx) {
        return (Attrib)this.vect.elementAt(idx);
    }

    private void readAttributeFactory(String filename) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        int start = pgs.str.indexOf("attribute_factory(");
        if (start < 0) {
            return;
        }
        start = pgs.inMethod(start);
        int end = pgs.outMethod(start + 1);
        PogoString block = new PogoString(pgs.str.substring(start, end));
        start = 0;
        String patern = filename.indexOf(PogoDefs.javaExtention) > 0 ? PogoDefs.javaAddAttrib : PogoDefs.cppAddAttrib;
        while ((start = block.str.indexOf(patern, start)) >= 0) {
            start = block.str.indexOf("(\"", start) + 2;
            end = block.str.indexOf("\")", start);
            this.vect.addElement(new Attrib(block.str.substring(start, end)));
        }
    }

    private void readAttributeTypes(String filename, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        int i = 0;
        while (i < this.size()) {
            Attrib attr = this.elementAt(i);
            String ptr = lang == 1 ? "" : "*";
            String pattern1 = new String(String.valueOf(ptr) + "attr_" + attr.name + "_read");
            int end = pgs.str.indexOf(pattern1);
            if (end < 0) {
                throw new PogoException(String.valueOf(pattern1) + " member data not found !");
            }
            int start = pgs.previousCr(end);
            String type = pgs.str.substring(start, end);
            if (lang == 1) {
                start = type.indexOf("protected");
                if (start >= 0) {
                    type = type.substring(start + "protected".length());
                }
                if ((end = type.indexOf("[]")) > 0) {
                    type = type.substring(0, end);
                }
            }
            attr.setType(type.trim(), lang);
            String pattern2 = new String("attr_" + attr.name + "_write");
            if (pgs.str.indexOf(pattern2) > 0) {
                attr.setWritable(true);
            }
            ++i;
        }
    }

    public int size() {
        return this.vect.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            Attrib attr = (Attrib)this.vect.elementAt(i);
            sb.append(String.valueOf(attr.name) + "\t");
            sb.append(String.valueOf(attr.type.code_str) + "\t");
            if (attr.writable) {
                sb.append("rw\n");
            } else {
                sb.append("r-\n");
            }
            ++i;
        }
        return sb.toString();
    }
}

