/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pogo.appli.ClassDialog;
import pogo.appli.GenerateThread;
import pogo.appli.PogoAppliDefs;
import pogo.appli.PogoFileFilter;
import pogo.appli.PogoHelp;
import pogo.appli.PogoTree;
import pogo.appli.PrefGeneDialog;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.RcsId;

public class PogoAppli
extends JFrame
implements PogoAppliDefs,
PogoDefs {
    private static String rcsString = "$Header: /segfs/tango/tools/pogo/appli/RCS/PogoAppli.java,v 1.20 2000/07/07 13:30:10 verdier Exp verdier $";
    private PogoTree tree;
    private PogoClass pogo;
    private String homeDir;
    private JFileChooser chooser;
    private static String[] palette = new String[]{"Edit Class", null, "Property", "Command", "Attribute", "State"};
    JLabel versionLabel;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JSeparator jSeparator1;
    private JMenuItem geneSrcBtn;
    private JMenuItem geneDocBtn;
    private JSeparator jSeparator2;
    private JMenuItem exitMenuItem;
    private JMenu editMenu;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JSeparator jSeparator3;
    private JMenuItem deleteMenuItem;
    private JMenuItem moveUpItem;
    private JMenuItem moveDownItem;
    private JMenu paletteMenu;
    private JMenu prefMenu;
    private JMenuItem jMenuItem1;
    private JMenu helpMenu;
    private JMenuItem contentsMenuItem;
    private JSeparator jSeparator4;
    private JMenuItem aboutMenuItem;
    private JScrollPane jScrollPane1;
    private JPanel southPanel;
    private JPanel mousePanel;
    private JLabel leftBtnLabel;
    private JLabel rightBtnLabel;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JRadioButton cppBtn;
    private JRadioButton javaBtn;

    public PogoAppli() {
        this.initComponents();
        this.tree = new PogoTree(this);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 350));
        this.jScrollPane1.setViewportView(this.tree);
        this.customMenu();
        this.setPogoDefined(false);
        this.setTitle(new RcsId(rcsString).toString());
        this.pack();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.tree.copySelection();
    }

    private void customMenu() {
        String templates_dir = System.getProperty("TEMPL_HOME");
        if (templates_dir != null) {
            this.jLabel1.setIcon(new ImageIcon(String.valueOf(templates_dir) + "/img/pogo.jpg"));
            this.jLabel1.setDisabledIcon(null);
        }
        this.jLabel1.setBackground(Color.black);
        this.versionLabel = new JLabel();
        this.versionLabel.setText("");
        this.versionLabel.setBackground(Color.black);
        this.getContentPane().add((Component)this.versionLabel, "North");
        this.tree.setMouseUsageListener(this.leftBtnLabel, this.rightBtnLabel);
        this.fileMenu.setMnemonic('F');
        this.editMenu.setMnemonic('E');
        this.helpMenu.setMnemonic('H');
        this.newMenuItem.setMnemonic('N');
        this.openMenuItem.setMnemonic('O');
        this.exitMenuItem.setMnemonic('E');
        this.deleteMenuItem.setMnemonic('D');
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.geneSrcBtn.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.geneDocBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.paletteMenu.setMnemonic('P');
        int i = 0;
        while (i < palette.length) {
            if (palette[i] != null) {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setText(palette[i]);
                menuItem.setMnemonic(palette[i].charAt(0));
                menuItem.setAccelerator(KeyStroke.getKeyStroke((int)palette[i].charAt(0), 1));
                this.paletteMenu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PogoAppli.this.paletteItemAP(evt);
                    }
                });
                if (i == 2) {
                    menuItem.setEnabled(false);
                }
            } else {
                this.paletteMenu.addSeparator();
                this.paletteMenu.addSeparator();
                JLabel lbl = new JLabel(" Create a New:");
                this.paletteMenu.add(lbl);
            }
            ++i;
        }
    }

    private void cutMenuItemActionPerformed(ActionEvent evt) {
        this.tree.cutSelection();
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        this.tree.removeSelectedLeaf();
    }

    private void editAP(MenuEvent evt) {
        boolean state = this.tree.isLeafSelected();
        this.copyMenuItem.setEnabled(state);
        this.cutMenuItem.setEnabled(state);
        this.pasteMenuItem.setEnabled(this.tree.objToBePasted());
        this.deleteMenuItem.setEnabled(state);
        this.moveUpItem.setEnabled(state);
        this.moveDownItem.setEnabled(state);
    }

    private void exitForm(WindowEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showConfirmDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "information", 0) == 0) {
            this.generateSource(1);
        }
        System.exit(0);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        if (this.tree != null && this.tree.hasBeenModified()) {
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, "This project has not been saved !\n\nWould you like to generate modifications ?", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    this.generateSource(1);
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        System.exit(0);
    }

    private void genePrefActionPerformed(ActionEvent evt) {
        PrefGeneDialog dialog;
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((dialog = new PrefGeneDialog((Frame)this, true)).showDialog(this.homeDir) == 1) {
            this.homeDir = dialog.getInput();
        }
        this.tree.setHomeDir(this.homeDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateAP(ActionEvent evt) {
        String type = evt.getActionCommand();
        if (type.indexOf("Source") > 0) {
            this.generateSource(1);
            return;
        }
        if (type.indexOf("Doc.") <= 0 || this.tree == null) return;
        if (this.tree.hasBeenModified()) {
            Object[] options = new Object[]{"Generate Source\n Before", "Generate Only\n Documentation", "CANCEL"};
            switch (JOptionPane.showOptionDialog(this.tree, "The source files have not been generateded !\nThe programmer's guide generation use source files.\n\n\n", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    this.generateSource(1);
                    this.generateSource(2);
                    return;
                }
                case 1: {
                    this.generateSource(2);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.generateSource(2);
    }

    private void generateSource(int item) {
        PogoClass pogoTree;
        if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
            this.homeDir = new File("").getAbsolutePath();
        }
        if ((pogoTree = this.tree.getPogoClass()) == null) {
            return;
        }
        if (item == 1) {
            PrefGeneDialog dialog = new PrefGeneDialog((Frame)this, true);
            if (dialog.showDialog(this.homeDir) != 1) {
                return;
            }
            this.homeDir = dialog.getInput();
            this.tree.setHomeDir(this.homeDir);
        }
        pogoTree.output_files = this.homeDir;
        pogoTree.author = this.pogo.author;
        pogoTree.revision = this.pogo.revision;
        String message = null;
        try {
            pogoTree.language = pogoTree.in_language = this.getLanguage();
            GenerateThread gt = new GenerateThread(this, pogoTree, item, this.homeDir);
            gt.run();
            this.tree.setModified(false);
        }
        catch (PogoException ex) {
            message = ex.toString();
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Error Window", 0);
        }
    }

    private int getLanguage() throws PogoException {
        if (this.javaBtn.getSelectedObjects() != null) {
            return 1;
        }
        if (this.cppBtn.getSelectedObjects() != null) {
            return 2;
        }
        throw new PogoException("Output Language NOT Selected !");
    }

    private void helpAP(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        String message = null;
        if (cmd.equals("About")) {
            message = new String(String.valueOf(new RcsId(rcsString).toString()) + "\n\n\n" + "This is the famous POGO application.\nThe Program Obviously used to Generate tango Object.");
        } else {
            PogoHelp.displayMessage(this, cmd);
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Help Window", 1);
        }
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.geneSrcBtn = new JMenuItem();
        this.geneDocBtn = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.deleteMenuItem = new JMenuItem();
        this.moveUpItem = new JMenuItem();
        this.moveDownItem = new JMenuItem();
        this.paletteMenu = new JMenu();
        this.prefMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.aboutMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.southPanel = new JPanel();
        this.mousePanel = new JPanel();
        this.leftBtnLabel = new JLabel();
        this.rightBtnLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.fileMenu.setText("File");
        this.fileMenu.setName("File");
        this.newMenuItem.setText("New Class");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setToolTipText("Open Class File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.geneSrcBtn.setText("Generate Source");
        this.geneSrcBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneSrcBtn);
        this.geneDocBtn.setText("Generate Doc.");
        this.geneDocBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.generateAP(evt);
            }
        });
        this.fileMenu.add(this.geneDocBtn);
        this.fileMenu.add(this.jSeparator2);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                PogoAppli.this.editAP(evt);
            }
        });
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.cutMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.add(this.jSeparator3);
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.moveUpItem.setText("Move Up");
        this.moveUpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveUpItem);
        this.moveDownItem.setText("Move Down");
        this.moveDownItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.moveActionPerformed(evt);
            }
        });
        this.editMenu.add(this.moveDownItem);
        this.menuBar.add(this.editMenu);
        this.paletteMenu.setText("Palette");
        this.menuBar.add(this.paletteMenu);
        this.prefMenu.setText("Preferences");
        this.jMenuItem1.setText("On Generation");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.genePrefActionPerformed(evt);
            }
        });
        this.prefMenu.add(this.jMenuItem1);
        this.menuBar.add(this.prefMenu);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Shortcuts");
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.helpMenu.add(this.jSeparator4);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.helpAP(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setTitle("Pogo Appli");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PogoAppli.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBackground(Color.white);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.mousePanel.setLayout(new BorderLayout());
        this.leftBtnLabel.setHorizontalTextPosition(2);
        this.mousePanel.add((Component)this.leftBtnLabel, "West");
        this.mousePanel.add((Component)this.rightBtnLabel, "East");
        this.southPanel.add((Component)this.mousePanel, "North");
        this.jLabel1.setBackground(Color.white);
        this.jLabel1.setText("Language Generated: ");
        this.jPanel1.add(this.jLabel1);
        this.cppBtn.setToolTipText("The device server will be generated in C++");
        this.cppBtn.setText("C++");
        this.cppBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.cppBtn);
        this.javaBtn.setToolTipText("The device server will be generated in Java");
        this.javaBtn.setText("Java");
        this.javaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PogoAppli.this.languageBtnAP(evt);
            }
        });
        this.jPanel1.add(this.javaBtn);
        this.southPanel.add((Component)this.jPanel1, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setJMenuBar(this.menuBar);
    }

    private void languageBtnAP(ActionEvent evt) {
        String lang = evt.getActionCommand();
        if (lang.equals("Java")) {
            this.cppBtn.setSelected(false);
            this.javaBtn.setSelected(true);
        } else {
            this.cppBtn.setSelected(true);
            this.javaBtn.setSelected(false);
        }
        try {
            this.tree.setLanguage(this.getLanguage());
        }
        catch (PogoException pogoException) {}
    }

    public static void main(String[] args) {
        try {
            PogoAppli pogoAppli = new PogoAppli();
            pogoAppli.show();
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
        }
    }

    private void moveActionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.indexOf("Up") >= 0) {
            this.tree.moveUpSelection();
        } else {
            this.tree.moveDownSelection();
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        block5: {
            ClassDialog classDialog;
            Object[] options;
            if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this.tree, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
                return;
            }
            if (this.homeDir == null && (this.homeDir = System.getProperty("HOME_GENE")) == null) {
                this.homeDir = new File("").getAbsolutePath();
            }
            if ((classDialog = new ClassDialog((Frame)this, true)).showClassDialog(null, null, null) != 1) break block5;
            if (this.tree != null) {
                this.tree.clear();
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                this.pogo = null;
            }
            try {
                this.pogo = new PogoClass(classDialog.getClassName(), classDialog.getDescription(), new Vector(), new Vector(), new Vector());
                this.pogo.title = classDialog.getProjectTitle();
                this.tree.setPogoTree(this.pogo);
                this.setPogoDefined(true);
                this.resetLanguage();
                this.tree.setHomeDir(this.homeDir);
            }
            catch (PogoException ex) {
                JOptionPane.showMessageDialog(this, String.valueOf(String.valueOf(ex)) + ex.str[0], "Error Window", 0);
            }
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        Object[] options;
        if (this.tree != null && this.tree.hasBeenModified() && JOptionPane.showOptionDialog(this.tree, "This project has not been saved !\n\nDiscard modifications ?", "Warning", -1, 2, null, options = new Object[]{"OK", "CANCEL"}, options[0]) != 0) {
            return;
        }
        if (this.homeDir == null) {
            this.homeDir = System.getProperty("HOME_GENE");
            if (this.homeDir == null) {
                this.homeDir = new File("").getAbsolutePath();
                System.out.println(this.homeDir);
            }
            this.chooser = new JFileChooser(this.homeDir);
            PogoFileFilter cppFF = new PogoFileFilter("Cpp", "Class Name");
            PogoFileFilter javaFF = new PogoFileFilter("java", "Class Name");
            this.chooser.addChoosableFileFilter(javaFF);
            this.chooser.addChoosableFileFilter(cppFF);
            String inLang = System.getProperty("IN_LANG");
            if (inLang != null && inLang.indexOf("java") >= 0) {
                this.chooser.setFileFilter(javaFF);
            }
        }
        this.chooser.setCurrentDirectory(new File(this.homeDir));
        int retval = this.chooser.showOpenDialog(this);
        if (retval == 0) {
            File file;
            if (this.tree != null) {
                this.tree.clear();
                this.setPogoDefined(false);
                this.versionLabel.setText("");
                this.pogo = null;
            }
            if ((file = this.chooser.getSelectedFile()) != null && !file.isDirectory()) {
                this.readSourceFile(file.getAbsolutePath());
                this.homeDir = file.getParentFile().toString();
                this.versionLabel.setText("  Author: " + this.pogo.author + "  - Revision: " + this.pogo.revision);
                if (file.getAbsolutePath().indexOf(PogoDefs.cppExtention) > 0) {
                    this.cppBtn.setSelected(true);
                    this.javaBtn.setSelected(false);
                } else if (file.getAbsolutePath().indexOf(PogoDefs.javaExtention) > 0) {
                    this.cppBtn.setSelected(false);
                    this.javaBtn.setSelected(true);
                }
                try {
                    this.tree.setLanguage(this.getLanguage());
                }
                catch (PogoException pogoException) {}
                this.tree.setHomeDir(this.homeDir);
            }
        }
    }

    private void paletteItemAP(ActionEvent evt) {
        String itemCmd = evt.getActionCommand();
        int idx = 0;
        int i = 0;
        while (i < palette.length) {
            if (itemCmd.equals(palette[i])) {
                idx = i;
            }
            ++i;
        }
        switch (idx) {
            case 0: {
                this.tree.editClassObject();
                break;
            }
            case 3: {
                this.tree.createNewCollectionObject("Commands");
                break;
            }
            case 4: {
                this.tree.createNewCollectionObject("Attributes");
                break;
            }
            case 5: {
                this.tree.createNewCollectionObject("States");
                break;
            }
        }
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        this.tree.paste();
    }

    /*
     * Unable to fully structure code
     */
    private void readSourceFile(String filename) {
        block7: {
            message = null;
            System.out.println("Reading: " + filename);
            try {
                this.pogo = new PogoClass(filename);
                this.tree.setPogoTree(this.pogo);
                this.setPogoDefined(true);
                break block7;
            }
            catch (FileNotFoundException ex) {
                message = ex.toString();
                break block7;
            }
            catch (SecurityException ex) {
                message = ex.toString();
                break block7;
            }
            catch (IOException ex) {
                message = ex.toString();
                break block7;
            }
            catch (PogoException ex) {
                buff = new StringBuffer(String.valueOf(ex.toString()) + ": ");
                i = 0;
                ** while (i < ex.str.length)
            }
lbl-1000:
            // 1 sources

            {
                buff.append(String.valueOf(ex.str[i]) + "\n\t");
                ++i;
                continue;
            }
lbl25:
            // 1 sources

            message = buff.toString();
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Error Window", 0);
        }
    }

    private void resetLanguage() {
        this.cppBtn.setSelected(false);
        this.javaBtn.setSelected(false);
    }

    private void setLanguage() {
        switch (this.pogo.language) {
            case 1: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(true);
                break;
            }
            case 2: {
                this.cppBtn.setSelected(true);
                this.javaBtn.setSelected(false);
                break;
            }
            default: {
                this.cppBtn.setSelected(false);
                this.javaBtn.setSelected(false);
            }
        }
    }

    private void setPogoDefined(boolean state) {
        this.tree.setVisible(state);
        this.geneSrcBtn.setEnabled(state);
        this.geneDocBtn.setEnabled(state);
        this.cutMenuItem.setEnabled(false);
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setEnabled(false);
        this.paletteMenu.setEnabled(state);
        this.prefMenu.setEnabled(state);
        if (state) {
            this.setLanguage();
        }
    }

    private void tracePogo() {
        System.out.println("\n\n");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            System.out.println(String.valueOf(cmd.command) + " -> " + cmd.exec_method);
            ++i;
        }
    }
}

