/*
 * Decompiled with CFR 0.152.
 */
package pogo.appli;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;

public class EditPogoCode
extends Thread
implements PogoDefs {
    private PogoClass pogo;
    private String srcFilename;
    private String editor;
    private String srcCode;
    private int lineNum;

    public EditPogoCode(PogoClass pogo) throws FileNotFoundException, IOException, PogoException {
        this.pogo = pogo;
        this.srcFilename = pogo.language == 2 ? new String(String.valueOf(pogo.output_files) + "/" + pogo.class_name + PogoDefs.cppExtention) : new String(String.valueOf(pogo.output_files) + "/" + pogo.class_name + PogoDefs.javaExtention);
        FileInputStream fidin = new FileInputStream(this.srcFilename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        this.srcCode = new String(inStr);
        this.editor = System.getProperty("EDITOR");
        if (this.editor == null) {
            this.editor = "nc -noask";
        } else if (this.editor.length() == 0) {
            this.editor = "nc -noask";
        } else if (this.editor.equals("vi")) {
            this.editor = "xterm -e vi";
        }
    }

    public void run() {
        try {
            String str1;
            String cmdStr = new String(String.valueOf(this.editor) + " +" + this.lineNum + " " + this.srcFilename);
            Process proc = Runtime.getRuntime().exec(cmdStr);
            InputStream istr = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            StringBuffer sb = new StringBuffer(String.valueOf(cmdStr) + "\n\n");
            while ((str1 = br.readLine()) != null) {
                sb.append(String.valueOf(str1) + "\n");
            }
            int retVal = proc.waitFor();
            if (retVal != 0) {
                System.out.println(String.valueOf(cmdStr) + "\nproc.waitFor() : " + retVal + " !");
            }
            if ((retVal = proc.exitValue()) != 0) {
                System.out.println(String.valueOf(cmdStr) + "\nproc.exitValue() : " + retVal + " !");
            }
        }
        catch (InterruptedException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private int searchLineNumber(String target) throws PogoException {
        int end = this.srcCode.indexOf(target);
        if (end < 0) {
            throw new PogoException(String.valueOf(target) + "\nMethod not found");
        }
        int line = 0;
        int i = 0;
        while (i < end) {
            if (this.srcCode.charAt(i) == '\n') {
                ++line;
            }
            ++i;
        }
        return ++line;
    }

    public void setAttributeTarget() throws PogoException {
        String target = this.pogo.language == 2 ? "void " + this.pogo.class_name + "::read_attr_hardware(vector<long> &attr_list)" : "public void read_attr_hardware(Vector attr_list)";
        this.lineNum = this.searchLineNumber(target);
    }

    public void setCommandTarget(String cmdName) throws FileNotFoundException, IOException, PogoException {
        Cmd cmd = this.pogo.commands.cmdIdx(0);
        int i = 0;
        while (i < this.pogo.commands.size()) {
            cmd = this.pogo.commands.cmdIdx(i);
            if (cmd.command.equals(cmdName)) break;
            ++i;
        }
        String target = this.pogo.language == 2 ? cmd.buildCppExecCmdMethodLine(this.pogo.class_name) : cmd.buildJavaExecCmdMethodLine();
        target = target.substring(0, target.indexOf("(") + 1);
        this.lineNum = this.searchLineNumber(target);
    }
}

