/*
 * Decompiled with CFR 0.152.
 */
package Acme.Widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    public static final int SOLID = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    private int type;
    private int thickness;
    private Panel innerPanel;

    public BorderPanel(int type, int thickness) {
        this.type = type;
        this.thickness = thickness;
        this.build();
    }

    public BorderPanel(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                this.thickness = 2;
                break;
            }
            case 1: {
                this.thickness = 2;
                break;
            }
            case 2: {
                this.thickness = 2;
                break;
            }
            case 3: {
                this.thickness = 2;
                break;
            }
            case 4: {
                this.thickness = 2;
                break;
            }
        }
        this.build();
    }

    private void build() {
        Panel ip = new Panel();
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        gb.setConstraints(ip, gbc);
        this.add((Component)ip, -1);
        this.innerPanel = ip;
    }

    public void paint(Graphics graphics) {
        Dimension size = this.size();
        graphics.setColor(this.getBackground());
        switch (this.type) {
            case 0: {
                graphics.setColor(this.getForeground());
                int i = 0;
                while (i < this.thickness) {
                    graphics.drawRect(i, i, size.width - i * 2 - 1, size.height - i * 2 - 1);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.thickness) {
                    graphics.draw3DRect(i, i, size.width - i * 2 - 1, size.height - i * 2 - 1, true);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.thickness) {
                    graphics.draw3DRect(i, i, size.width - i * 2 - 1, size.height - i * 2 - 1, false);
                    ++i;
                }
                break;
            }
            case 3: {
                graphics.draw3DRect(0, 0, size.width - 1, size.height - 1, false);
                graphics.draw3DRect(this.thickness - 1, this.thickness - 1, size.width - this.thickness * 2 + 1, size.height - this.thickness * 2 + 1, true);
                break;
            }
            case 4: {
                graphics.draw3DRect(0, 0, size.width - 1, size.height - 1, true);
                graphics.draw3DRect(this.thickness - 1, this.thickness - 1, size.width - this.thickness * 2 + 1, size.height - this.thickness * 2 + 1, false);
                break;
            }
        }
    }

    public int countComponents() {
        if (this.innerPanel == null) {
            return super.getComponentCount();
        }
        return this.innerPanel.getComponentCount();
    }

    public Component getComponent(int n) {
        if (this.innerPanel == null) {
            return super.getComponent(n);
        }
        return this.innerPanel.getComponent(n);
    }

    public Insets insets(int n) {
        if (this.innerPanel == null) {
            return super.getInsets();
        }
        return this.innerPanel.getInsets();
    }

    public Component add(Component comp) {
        if (this.innerPanel == null) {
            return super.add(comp);
        }
        return this.innerPanel.add(comp);
    }

    public Component add(Component comp, int pos) {
        if (this.innerPanel == null) {
            return super.add(comp, pos);
        }
        return this.innerPanel.add(comp, pos);
    }

    public Component add(String name, Component comp) {
        if (this.innerPanel == null) {
            return super.add(name, comp);
        }
        return this.innerPanel.add(name, comp);
    }

    public void remove(Component comp) {
        if (this.innerPanel == null) {
            super.remove(comp);
        } else {
            this.innerPanel.remove(comp);
        }
    }

    public void removeAll() {
        if (this.innerPanel == null) {
            super.removeAll();
        } else {
            this.innerPanel.removeAll();
        }
    }

    public LayoutManager getLayout() {
        if (this.innerPanel == null) {
            return super.getLayout();
        }
        return this.innerPanel.getLayout();
    }

    public void setLayout(LayoutManager mgr) {
        if (this.innerPanel == null) {
            super.setLayout(mgr);
        } else {
            this.innerPanel.setLayout(mgr);
        }
    }
}

