/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve.servlet.http;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ChunkedInputStream
extends FilterInputStream {
    private DataInputStream din;
    private int contentLength = 0;
    private byte[] b1 = new byte[1];
    private int chunkCount;
    private Vector footerNames;
    private Vector footerValues;

    public ChunkedInputStream(InputStream in) {
        super(new DataInputStream(in));
        this.din = (DataInputStream)this.in;
    }

    public int read() throws IOException {
        if (this.read(this.b1, 0, 1) == -1) {
            return -1;
        }
        return this.b1[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        int r;
        if (this.chunkCount == 0) {
            this.startChunk();
            if (this.chunkCount == 0) {
                return -1;
            }
        }
        if ((r = this.din.read(b, off, toRead = Math.min(this.chunkCount, len))) != -1) {
            this.chunkCount -= r;
        }
        return r;
    }

    private void startChunk() throws IOException {
        String line = this.din.readLine();
        try {
            this.chunkCount = Integer.parseInt(line, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("malformed chunk");
        }
        this.contentLength += this.chunkCount;
        if (this.chunkCount == 0) {
            this.readFooters();
        }
    }

    private void readFooters() throws IOException {
        String line;
        this.footerNames = new Vector();
        this.footerValues = new Vector();
        while ((line = this.din.readLine()).length() != 0) {
            int colon = line.indexOf(58);
            if (colon == -1) continue;
            String name = line.substring(0, colon).toLowerCase();
            String value = line.substring(colon + 1).trim();
            this.footerNames.addElement(name.toLowerCase());
            this.footerValues.addElement(value);
        }
    }

    public String getFooter(String name) {
        if (!this.isDone()) {
            return null;
        }
        int i = this.footerNames.indexOf(name.toLowerCase());
        if (i == -1) {
            return null;
        }
        return (String)this.footerValues.elementAt(i);
    }

    public Enumeration getFooters() {
        if (!this.isDone()) {
            return null;
        }
        return this.footerNames.elements();
    }

    public int getContentLength() {
        if (!this.isDone()) {
            return -1;
        }
        return this.contentLength;
    }

    public boolean isDone() {
        return this.footerNames != null;
    }
}

