/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Fmt;
import Acme.Serve.ServeUtils;
import Acme.Serve.ThrottleItem;
import Acme.Serve.ThrottledOutputStream;
import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;

public class FileServlet
extends HttpServlet {
    static WildcardDictionary throttleTab = null;

    public FileServlet() {
    }

    public FileServlet(String throttles) throws IOException {
        this();
        this.readThrottles(throttles);
    }

    private void readThrottles(String throttles) throws IOException {
        WildcardDictionary newThrottleTab = ThrottledOutputStream.parseThrottleFile(throttles);
        if (throttleTab == null) {
            throttleTab = newThrottleTab;
        } else {
            Enumeration keys = newThrottleTab.keys();
            Enumeration elements = newThrottleTab.elements();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object element = elements.nextElement();
                throttleTab.put(key, element);
            }
        }
    }

    public String getServletInfo() {
        return "servlet similar to a standard httpd";
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean headOnly;
        if (req.getMethod().equalsIgnoreCase("get")) {
            headOnly = false;
        } else if (!req.getMethod().equalsIgnoreCase("head")) {
            headOnly = true;
        } else {
            res.sendError(501);
            return;
        }
        String path = req.getServletPath();
        if (path == null || path.charAt(0) != '/') {
            res.sendError(400);
            return;
        }
        if (path.indexOf("/../") != -1 || path.endsWith("/..")) {
            res.sendError(403);
            return;
        }
        String pathname = path.substring(1);
        if (pathname.length() == 0) {
            pathname = "./";
        }
        this.dispatchPathname(req, res, headOnly, path, pathname);
    }

    private void dispatchPathname(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, String pathname) throws IOException {
        File file;
        String filename = pathname.replace('/', File.separatorChar);
        if (filename.charAt(filename.length() - 1) == File.separatorChar) {
            filename = filename.substring(0, filename.length() - 1);
        }
        if ((file = new File(filename = this.getServletContext().getRealPath(filename))).exists()) {
            if (!file.isDirectory()) {
                this.serveFile(req, res, headOnly, path, filename, file);
            } else if (pathname.charAt(pathname.length() - 1) != '/') {
                this.redirectDirectory(req, res, path, file);
            } else {
                String indexFilename = String.valueOf(filename) + File.separatorChar + "index.html";
                File indexFile = new File(indexFilename);
                if (indexFile.exists()) {
                    this.serveFile(req, res, headOnly, path, indexFilename, indexFile);
                } else {
                    this.serveDirectory(req, res, headOnly, path, filename, file);
                }
            }
        } else if (pathname.endsWith("/index.html")) {
            this.dispatchPathname(req, res, headOnly, path, pathname.substring(0, pathname.length() - 10));
        } else if (pathname.equals("index.html")) {
            this.dispatchPathname(req, res, headOnly, path, "./");
        } else {
            res.sendError(404);
        }
    }

    private void serveFile(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, String filename, File file) throws IOException {
        this.log("getting " + path);
        if (!file.canRead()) {
            res.sendError(403);
            return;
        }
        res.setStatus(200);
        long lastMod = file.lastModified();
        String ifModSinceStr = req.getHeader("If-Modified-Since");
        long ifModSince = -1L;
        if (ifModSinceStr != null) {
            int semi = ifModSinceStr.indexOf(59);
            if (semi != -1) {
                ifModSinceStr = ifModSinceStr.substring(0, semi);
            }
            try {
                ifModSince = DateFormat.getDateInstance().parse(ifModSinceStr).getTime();
            }
            catch (Exception exception) {}
        }
        if (ifModSince != -1L && ifModSince >= lastMod) {
            res.setStatus(304);
            headOnly = true;
        }
        String rangeStr = req.getHeader("Range");
        res.setContentType(this.getServletContext().getMimeType(filename));
        res.setContentLength((int)file.length());
        res.setDateHeader("Last-modified", lastMod);
        OutputStream out = res.getOutputStream();
        if (!headOnly) {
            ThrottleItem throttleItem;
            if (throttleTab != null && (throttleItem = (ThrottleItem)throttleTab.get(path)) != null) {
                out = new ThrottledOutputStream(out, throttleItem.getMaxBps());
            }
            FileInputStream in = new FileInputStream(file);
            this.copyStream(in, out);
            ((InputStream)in).close();
        }
        out.close();
    }

    public void copyStream(InputStream in, OutputStream out) throws IOException {
        Utils.copyStream(in, out);
    }

    private void serveDirectory(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, String filename, File file) throws IOException {
        this.log("indexing " + path);
        if (!file.canRead()) {
            res.sendError(403);
            return;
        }
        res.setStatus(200);
        res.setContentType("text/html");
        ServletOutputStream out = res.getOutputStream();
        if (!headOnly) {
            PrintStream p = new PrintStream(new BufferedOutputStream(out));
            p.println("<HTML><HEAD>");
            p.println("<TITLE>Index of " + path + "</TITLE>");
            p.println("</HEAD><BODY BGCOLOR=\"#99cc99\">");
            p.println("<H2>Index of " + path + "</H2>");
            p.println("<PRE>");
            p.println("mode     bytes  last-changed  name");
            p.println("<HR>");
            String[] names = file.list();
            Utils.sortStrings(names);
            int i = 0;
            while (i < names.length) {
                String aFilename = String.valueOf(filename) + File.separatorChar + names[i];
                File aFile = new File(aFilename);
                String aFileType = aFile.isDirectory() ? "d" : (aFile.isFile() ? "-" : "?");
                String aFileRead = aFile.canRead() ? "r" : "-";
                String aFileWrite = aFile.canWrite() ? "w" : "-";
                String aFileExe = "-";
                String aFileSize = Fmt.fmt(aFile.length(), 8);
                String aFileDate = Utils.lsDateStr(new Date(aFile.lastModified()));
                String aFileDirsuf = aFile.isDirectory() ? "/" : "";
                String aFileSuf = aFile.isDirectory() ? "/" : "";
                p.println(String.valueOf(aFileType) + aFileRead + aFileWrite + aFileExe + "  " + aFileSize + "  " + aFileDate + "  " + "<A HREF=\"" + names[i] + aFileDirsuf + "\">" + names[i] + aFileSuf + "</A>");
                ++i;
            }
            p.println("</PRE>");
            p.println("<HR>");
            ServeUtils.writeAddress(p);
            p.println("</BODY></HTML>");
            p.flush();
        }
        out.close();
    }

    private void redirectDirectory(HttpServletRequest req, HttpServletResponse res, String path, File file) throws IOException {
        this.log("redirecting " + path);
        res.sendRedirect(String.valueOf(path) + "/");
    }
}

