/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.DoublePoint;
import Acme.GuiUtils;
import Acme.MainFrame;
import Acme.PsgException;
import Acme.PsgMatrix;
import Acme.PsgPathItem;
import Acme.PsgState;
import Acme.PsgTest;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class Psg {
    private Component component;
    private Graphics graphics;
    private PsgState current;
    private Stack gStack;
    private Vector path;
    private PsgPathItem subpathStart;
    private final double segAng = 5.0;
    private final double tStep = 0.025;

    public Psg(Component component) {
        this.component = component;
        this.graphics = component.getGraphics();
        this.initgraphics();
    }

    public Psg(Graphics graphics) {
        this.component = null;
        this.graphics = graphics;
        this.initgraphics();
    }

    public void gsave() {
        PsgState next = (PsgState)this.current.clone();
        this.gStack.push(this.current);
        this.current = next;
    }

    public void grestore() {
        if (this.gStack.empty()) {
            this.initgraphics();
        } else {
            this.current = (PsgState)this.gStack.pop();
            if (this.current.font == null) {
                this.graphics.setFont(this.current.font);
            }
        }
    }

    public void grestoreall() {
        while (!this.gStack.empty()) {
            this.grestore();
        }
    }

    public void initgraphics() {
        this.current = new PsgState();
        this.gStack = new Stack();
        this.path = new Vector();
        this.subpathStart = null;
        Dimension d = this.size();
        this.translate(0.0, d.height);
        this.scale(1.0, -1.0);
        this.erasepage();
    }

    public void setlinewidth(double linewidth) {
        this.current.linewidth = this.wtransform(linewidth);
    }

    public void setcolor(Color color) {
        this.current.color = color;
    }

    public void setgray(float grayVal) {
        this.setrgbcolor(grayVal, grayVal, grayVal);
    }

    public void sethsbcolor(float hue, float saturation, float brightness) {
        this.setcolor(new Color(Color.HSBtoRGB(hue, saturation, brightness)));
    }

    public void setrgbcolor(float r, float g, float b) {
        this.setcolor(new Color(r, g, b));
    }

    public void translate(double tx, double ty) {
        double nx = tx * this.current.matrix.xx + ty * this.current.matrix.yx + this.current.matrix.tx;
        double ny = ty * this.current.matrix.yy + tx * this.current.matrix.xy + this.current.matrix.ty;
        this.current.matrix.tx = nx;
        this.current.matrix.ty = ny;
    }

    public void scale(double sx, double sy) {
        this.current.matrix.xx *= sx;
        this.current.matrix.xy *= sx;
        this.current.matrix.yx *= sy;
        this.current.matrix.yy *= sy;
    }

    public void rotate(double degrees) {
        double radians = Psg.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double sxx = this.current.matrix.xx;
        double sxy = this.current.matrix.xy;
        this.current.matrix.xx = cos * sxx + sin * this.current.matrix.yx;
        this.current.matrix.xy = cos * sxy + sin * this.current.matrix.yy;
        this.current.matrix.yx = cos * this.current.matrix.yx - sin * sxx;
        this.current.matrix.yy = cos * this.current.matrix.yy - sin * sxy;
    }

    public int transform_x(double x, double y) {
        return (int)(x * this.current.matrix.xx + y * this.current.matrix.yx + this.current.matrix.tx);
    }

    public int transform_y(double x, double y) {
        return (int)(y * this.current.matrix.yy + x * this.current.matrix.xy + this.current.matrix.ty);
    }

    public int dtransform_x(double dx, double dy) {
        return (int)(dx * this.current.matrix.xx + dy * this.current.matrix.yx);
    }

    public int dtransform_y(double dx, double dy) {
        return (int)(dy * this.current.matrix.yy + dx * this.current.matrix.xy);
    }

    public double itransform_x(int x, int y) throws PsgException {
        PsgMatrix inv = this.current.matrix.invert();
        return (double)x * inv.xx + (double)y * inv.yx + inv.tx;
    }

    public double itransform_y(int x, int y) throws PsgException {
        PsgMatrix inv = this.current.matrix.invert();
        return (double)y * inv.yy + (double)x * inv.xy + inv.ty;
    }

    public double idtransform_x(int dx, int dy) throws PsgException {
        PsgMatrix inv = this.current.matrix.invert();
        return (double)dx * inv.xx + (double)dy * inv.yx;
    }

    public double idtransform_y(int dx, int dy) throws PsgException {
        PsgMatrix inv = this.current.matrix.invert();
        return (double)dy * inv.yy + (double)dx * inv.xy;
    }

    private int wtransform(double width) {
        int dx = this.dtransform_x(width, width);
        int dy = this.dtransform_y(width, width);
        return (Math.abs(dx) + Math.abs(dy)) / 2;
    }

    public void newpath() {
        this.current.point = null;
        this.path.setSize(0);
        this.subpathStart = null;
    }

    public void moveto(double x, double y) {
        if (this.current.point == null) {
            this.current.point = new DoublePoint();
        }
        this.current.point.x = x;
        this.current.point.y = y;
        PsgPathItem n = new PsgPathItem(this.transform_x(x, y), this.transform_y(x, y), 0, false);
        this.path.addElement(n);
        this.subpathStart = n;
    }

    public void rmoveto(double dx, double dy) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        this.moveto(this.current.point.x + dx, this.current.point.y + dy);
    }

    public void lineto(double x, double y) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        this.current.point.x = x;
        this.current.point.y = y;
        PsgPathItem n = new PsgPathItem(this.transform_x(x, y), this.transform_y(x, y), this.current.linewidth, true);
        this.path.addElement(n);
    }

    public void rlineto(double dx, double dy) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        this.lineto(this.current.point.x + dx, this.current.point.y + dy);
    }

    public void arc(double cx, double cy, double r, double ang1, double ang2) {
        ang1 = Psg.normAngle(ang1);
        if ((ang2 = Psg.normAngle(ang2)) <= ang1) {
            ang2 += 360.0;
        }
        double a = ang1;
        while (a < ang2) {
            this.arcSeg(cx, cy, r, a);
            a += 5.0;
        }
        this.arcSeg(cx, cy, r, ang2);
    }

    public void arcn(double cx, double cy, double r, double ang1, double ang2) {
        ang1 = Psg.normAngle(ang1);
        if ((ang2 = Psg.normAngle(ang2)) >= ang1) {
            ang2 -= 360.0;
        }
        double a = ang1;
        while (a > ang2) {
            this.arcSeg(cx, cy, r, a);
            a -= 5.0;
        }
        this.arcSeg(cx, cy, r, ang2);
    }

    private void arcSeg(double cx, double cy, double r, double a) {
        double x = cx + r * Math.cos(Psg.toRadians(a));
        double y = cy + r * Math.sin(Psg.toRadians(a));
        if (this.current.point == null) {
            this.moveto(x, y);
        } else {
            try {
                this.lineto(x, y);
            }
            catch (PsgException psgException) {
                throw new InternalError();
            }
        }
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        double x0 = this.current.point.x;
        double y0 = this.current.point.y;
        double cx = (x1 - x0) * 3.0;
        double cy = (y1 - y0) * 3.0;
        double bx = (x2 - x1) * 3.0 - cx;
        double by = (y2 - y1) * 3.0 - cy;
        double ax = x3 - x0 - cx - bx;
        double ay = y3 - y0 - cy - by;
        double t = 0.0;
        while (t < 1.0) {
            this.curveSeg(ax, ay, bx, by, cx, cy, x0, y0, t);
            t += 0.025;
        }
        this.curveSeg(ax, ay, bx, by, cx, cy, x0, y0, 1.0);
    }

    private void curveSeg(double ax, double ay, double bx, double by, double cx, double cy, double x0, double y0, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double x = ax * t3 + bx * t2 + cx * t + x0;
        double y = ay * t3 + by * t2 + cy * t + y0;
        try {
            this.lineto(x, y);
        }
        catch (PsgException psgException) {
            throw new InternalError();
        }
    }

    public void rcurveto(double dx1, double dy1, double dx2, double dy2, double dx3, double dy3) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        double x0 = this.current.point.x;
        double y0 = this.current.point.y;
        this.curveto(x0 + dx1, y0 + dy1, x0 + dx2, y0 + dy2, x0 + dx3, y0 + dy3);
    }

    public void closepath() {
        if (this.subpathStart != null) {
            this.path.addElement(new PsgPathItem(this.subpathStart.p.x, this.subpathStart.p.y, this.current.linewidth, true));
        }
        this.current.point = null;
        this.subpathStart = null;
    }

    public void flattenpath() {
    }

    public void clippath() throws PsgException {
        Dimension d = this.size();
        this.rectpath(this.itransform_x(0, 0), this.itransform_y(0, 0), this.idtransform_x(d.width, d.height), this.idtransform_y(d.width, d.height));
    }

    public double[] pathbbox() throws PsgException {
        if (this.path.isEmpty()) {
            throw new PsgException("no current point");
        }
        int ury = Integer.MAX_VALUE;
        int llx = Integer.MAX_VALUE;
        int lly = Integer.MIN_VALUE;
        int urx = Integer.MIN_VALUE;
        Enumeration enumeration = this.path.elements();
        while (enumeration.hasMoreElements()) {
            PsgPathItem pi = (PsgPathItem)enumeration.nextElement();
            llx = Math.min(llx, pi.p.x);
            lly = Math.max(lly, pi.p.y);
            urx = Math.max(urx, pi.p.x);
            ury = Math.min(ury, pi.p.y);
        }
        double[] r = new double[]{this.itransform_x(llx, lly), this.itransform_y(llx, lly), this.itransform_x(urx, ury), this.itransform_y(urx, ury)};
        return r;
    }

    public void erasepage() {
        Dimension d = this.size();
        this.graphics.clearRect(0, 0, d.width, d.height);
    }

    public void fill() {
        Polygon poly = null;
        this.graphics.setColor(this.current.color);
        Enumeration enumeration = this.path.elements();
        while (enumeration.hasMoreElements()) {
            PsgPathItem pi = (PsgPathItem)enumeration.nextElement();
            if (!pi.draw) {
                if (poly != null) {
                    this.graphics.fillPolygon(poly);
                }
                poly = new Polygon();
            }
            poly.addPoint(pi.p.x, pi.p.y);
            int x = pi.p.x;
            int n = pi.p.y;
        }
        if (poly != null) {
            this.graphics.fillPolygon(poly);
        }
        this.newpath();
    }

    public void stroke() {
        int x = 0;
        int y = 0;
        this.graphics.setColor(this.current.color);
        Enumeration enumeration = this.path.elements();
        while (enumeration.hasMoreElements()) {
            PsgPathItem pi = (PsgPathItem)enumeration.nextElement();
            if (pi.draw) {
                if (pi.linewidth < 1) {
                    this.graphics.drawLine(x, y, pi.p.x, pi.p.y);
                } else {
                    GuiUtils.drawThickLine(this.graphics, x, y, pi.p.x, pi.p.y, pi.linewidth);
                }
            }
            x = pi.p.x;
            y = pi.p.y;
        }
        this.newpath();
    }

    public void rectfill(double x, double y, double width, double height) {
        this.gsave();
        this.rectpath(x, y, width, height);
        this.fill();
        this.grestore();
    }

    public void rectstroke(double x, double y, double width, double height) {
        this.gsave();
        this.rectpath(x, y, width, height);
        this.stroke();
        this.grestore();
    }

    private void rectpath(double x, double y, double width, double height) {
        this.newpath();
        this.moveto(x, y);
        try {
            this.rlineto(width, 0.0);
            this.rlineto(0.0, height);
            this.rlineto(-width, 0.0);
        }
        catch (PsgException psgException) {
            throw new InternalError();
        }
        this.closepath();
    }

    public void setfont(String name, int style, double size) {
        this.setfontName(name);
        this.setfontStyle(style);
        this.setfontSize(size);
    }

    public void setfontName(String name) {
        this.current.fontName = new String(name);
        this.current.font = null;
    }

    public void setfontStyle(int style) {
        this.current.fontStyle = style;
        this.current.font = null;
    }

    public void setfontSize(double size) {
        this.current.fontSize = this.dtransform_y(0.0, size);
        this.current.font = null;
    }

    public void show(String str) throws PsgException {
        if (this.current.point == null) {
            throw new PsgException("no current point");
        }
        if (this.current.font == null) {
            this.current.font = new Font(this.current.fontName, this.current.fontStyle, this.current.fontSize);
            this.graphics.setFont(this.current.font);
        }
        this.graphics.drawString(str, this.transform_x(this.current.point.x, this.current.point.y), this.transform_y(this.current.point.x, this.current.point.y));
    }

    public double stringwidth_x(String str) throws PsgException {
        FontMetrics fm = this.graphics.getFontMetrics();
        return this.idtransform_x(fm.stringWidth(str), 0);
    }

    private Dimension size() {
        if (this.component != null) {
            return this.component.size();
        }
        Rectangle r = this.graphics.getClipBounds();
        return new Dimension(r.x + r.width, r.y + r.height);
    }

    private static double normAngle(double a) {
        int circles = (int)(a / 360.0);
        return a - (double)circles * 360.0;
    }

    private static double toRadians(double a) {
        return a * Math.PI / 180.0;
    }

    public static void main(String[] args) {
        new MainFrame(new PsgTest(), args, 350, 350);
    }
}

