/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Fmt;
import Acme.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;

public class NnrpdUtils {
    public static final String serverName = "Acme.Nnrpd";
    public static final String serverVersion = "v0.95 of 19dec96";
    public static final String serverUrl = "http://www.acme.com/java/software/Package-Acme.Nnrpd.html";
    public static final int DEFAULT_PORT = 119;
    public static final int DEFAULT_ACACHESIZE = 10000000;
    public static final int DEFAULT_MAXARTSIZE = 100000;
    public static final int DEFAULT_OCACHESIZE = 50000;
    public static final long INT_IDLETIMEOUT = 900000L;
    public static final long INT_CHECKGROUPS = 1800000L;
    public static final long INT_CHECKGROUPDESCS = 86400000L;
    public static final long INT_CHECKOVERVIEW = 86400000L;
    public static final String CMD_ARTICLE = "ARTICLE";
    public static final String CMD_AUTHINFO = "AUTHINFO";
    public static final String CMD_BODY = "BODY";
    public static final String CMD_DATE = "DATE";
    public static final String CMD_GROUP = "GROUP";
    public static final String CMD_HEAD = "HEAD";
    public static final String CMD_HELP = "HELP";
    public static final String CMD_IHAVE = "IHAVE";
    public static final String CMD_LAST = "LAST";
    public static final String CMD_LIST = "LIST";
    public static final String CMD_LISTGROUP = "LISTGROUP";
    public static final String CMD_MODE = "MODE";
    public static final String CMD_NEWGROUPS = "NEWGROUPS";
    public static final String CMD_NEWNEWS = "NEWNEWS";
    public static final String CMD_NEXT = "NEXT";
    public static final String CMD_POST = "POST";
    public static final String CMD_QUIT = "QUIT";
    public static final String CMD_SLAVE = "SLAVE";
    public static final String CMD_STAT = "STAT";
    public static final String CMD_XGTITLE = "XGTITLE";
    public static final String CMD_XHDR = "XHDR";
    public static final String CMD_XMODE = "XMODE";
    public static final String CMD_XOVER = "XOVER";
    public static final String CMD_XREPLIC = "XREPLIC";
    public static final String CMD_XTHREAD = "XTHREAD";
    public static final String RES_NOSUCHGROUP = "411 no such news group";
    public static final String RES_NOCURRGROUP = "412 no current newsgroup has been selected";
    public static final String RES_NOCURRARTICLE = "420 no current article has been selected";
    public static final String RES_NOSUCHARTICLENUM = "423 no such article number in this group";
    public static final String RES_NOSUCHARTICLE = "430 no such article found";
    public static final String RES_BADCOMMAND = "500 command not recognized";
    public static final String RES_UNIMPLEMENTED = "500 command not implemented";
    public static final String RES_SYNTAXERROR = "501 command syntax error";
    public static final String RES_PROGFAULT = "503 program fault - command not performed";

    public static String readText(DataInputStream din) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = din.readLine()) != null && !line.equals(".")) {
            buf.append(line);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static long rfc977DateTime(String dateStr, String timeStr, boolean gmt, long def) {
        if (dateStr.length() != 6 || timeStr.length() != 6) {
            return def;
        }
        try {
            int year = Integer.parseInt(dateStr.substring(0, 2));
            int month = Integer.parseInt(dateStr.substring(2, 4));
            int day = Integer.parseInt(dateStr.substring(4, 6));
            int hour = Integer.parseInt(timeStr.substring(0, 2));
            int minute = Integer.parseInt(timeStr.substring(2, 4));
            int second = Integer.parseInt(timeStr.substring(4, 6));
            if (year < 50) {
                year += 100;
            }
            --month;
            if (gmt) {
                return Date.UTC(year, month, day, hour, minute, second);
            }
            Date date = new Date(year, month, day, hour, minute, second);
            return date.getTime();
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static String rfc977DateTime(long time) {
        Date date = new Date(time);
        String gmtStr = date.toGMTString();
        String[] strArr = Utils.splitStr(gmtStr);
        int day = Integer.parseInt(strArr[0]);
        String months = "JanFebMarAprMayJunJulAugSepOctNovDec";
        int month = months.indexOf(strArr[1]) / 3 + 1;
        int year = Integer.parseInt(strArr[2]) - 1900;
        if (year >= 100) {
            year -= 100;
        }
        int hour = Integer.parseInt(strArr[3].substring(0, 2));
        int minute = Integer.parseInt(strArr[3].substring(3, 5));
        int second = Integer.parseInt(strArr[3].substring(6, 8));
        return String.valueOf(Fmt.fmt(year, 2, 1)) + Fmt.fmt(month, 2, 1) + Fmt.fmt(day, 2, 1) + " " + Fmt.fmt(hour, 2, 1) + Fmt.fmt(minute, 2, 1) + Fmt.fmt(second, 2, 1) + " GMT";
    }
}

