/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Nnrpd.NewsDb;
import Acme.Nnrpd.NewsDbArticle;
import Acme.Nnrpd.NewsDbException;
import Acme.Nnrpd.NewsDbGroup;
import Acme.Nnrpd.OverviewCache;
import Acme.UnixUser;
import Acme.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class LocalNewsDb
extends NewsDb {
    private static final String SPOOLDIR_1 = "/usr/spool/news";
    private static final String SPOOLDIR_2 = "/var/spool/news";
    private static final String LIBDIR_1 = "/usr/lib/news";
    private static final String LIBDIR_USER_1 = "usenet";
    private static final String LIBDIR_USER_2 = "news";
    private static final String AUXLIBDIR_1 = "/var/news";
    private static String SPOOLDIR;
    private static String LIBDIR;
    private static String AUXLIBDIR;
    private static File ACTIVE;
    private static File HISTORY;
    private static File ACTIVE_TIMES;
    private static File DISTRIB_PATS;
    private static File DISTRIBUTIONS;
    private static File NEWSGROUPS;
    private static File NNRP_ACCESS;
    private static File OVERVIEW_FMT;
    private String[] overviewFmt;
    private OverviewCache overviewCache;
    private Hashtable groupTable;
    private long groupsFetched;
    private Hashtable groupDescsTable;
    private long groupDescsFetched;
    private String[] lastOkNames;

    public LocalNewsDb(int oCacheSize) throws NewsDbException {
        block4: {
            this.initializePaths();
            if (OVERVIEW_FMT == null) break block4;
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(OVERVIEW_FMT));
                String[] lines = new String[100];
                int count = 0;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (line.endsWith(":")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    lines[count++] = line;
                }
                br.close();
                this.overviewFmt = new String[count];
                System.arraycopy(lines, 0, this.overviewFmt, 0, count);
                this.overviewCache = new OverviewCache(oCacheSize);
            }
            catch (IOException iOException) {}
        }
    }

    public boolean authorize(String user, String password) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public boolean getPostingOk() throws NewsDbException {
        return true;
    }

    public NewsDbGroup getGroup(String groupName) throws NewsDbException {
        this.checkGroups();
        return (NewsDbGroup)this.groupTable.get(groupName);
    }

    public NewsDbArticle getArticle(NewsDbGroup group, int artNum) throws NewsDbException {
        if (group.getDbStamp() != this.dbStamp) {
            throw new NewsDbException("mismatched database stamps");
        }
        return this.getArticleFromFile(String.valueOf(group.getName().replace('.', '/')) + "/" + Integer.toString(artNum));
    }

    public NewsDbArticle getArticle(String messageId) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    private NewsDbArticle getArticleFromFile(String filename) throws NewsDbException {
        filename = String.valueOf(SPOOLDIR) + "/" + filename;
        File file = new File(filename);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return null;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            Utils.readFully(is, bytes, 0, bytes.length);
            ((InputStream)is).close();
            return new NewsDbArticle(this.dbStamp, new String(bytes));
        }
        catch (IOException e) {
            throw new NewsDbException("problem reading article: " + e);
        }
    }

    public String[][] getHeaders(String[] names, NewsDbGroup group, int firstArtNum, int lastArtNum) throws NewsDbException {
        if (this.overviewFmt == null) {
            return null;
        }
        if (names != this.lastOkNames) {
            if (!Utils.equalsStrings(names, this.overviewFmt)) {
                return null;
            }
            this.lastOkNames = names;
        }
        if (group.getDbStamp() != this.dbStamp) {
            throw new NewsDbException("mismatched database stamps");
        }
        long now = System.currentTimeMillis();
        long time = this.overviewCache.getLastTime(group);
        if (time == -1L || now - time >= 86400000L) {
            this.readOverview(group);
            this.overviewCache.setLastTime(group);
        }
        int numArts = lastArtNum - firstArtNum + 1;
        String[][] results = new String[numArts][];
        int i = 0;
        while (i < numArts) {
            int artNum = firstArtNum + i;
            results[i] = this.overviewCache.getEntry(group, artNum);
            ++i;
        }
        return results;
    }

    private void readOverview(NewsDbGroup group) throws NewsDbException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(SPOOLDIR) + "/" + group.getName().replace('.', '/') + "/.overview"));
            while ((line = br.readLine()) != null) {
                int artNum;
                int tab = line.indexOf(9);
                try {
                    artNum = Integer.parseInt(line.substring(0, tab));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                String[] overviewEntry = Utils.splitStr(line.substring(tab + 1), '\t');
                if (overviewEntry.length != this.overviewFmt.length) continue;
                this.overviewCache.addEntry(overviewEntry, group, artNum);
            }
            br.close();
        }
        catch (IOException iOException) {}
    }

    public Enumeration getGroups() throws NewsDbException {
        this.checkGroups();
        return this.groupTable.elements();
    }

    public Enumeration getGroups(long since) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public Enumeration getGroups(long since, String distsPat) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public Enumeration getMessageIds(String groupsPat, long since) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public Enumeration getMessageIds(String groupsPat, long since, String distsPat) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public void post(String artText) throws NewsDbException {
        throw new NewsDbException("not implemented yet");
    }

    public void close() {
    }

    private void initializePaths() throws NewsDbException {
        if (new File(SPOOLDIR_1).exists()) {
            SPOOLDIR = SPOOLDIR_1;
        } else if (new File(SPOOLDIR_2).exists()) {
            SPOOLDIR = SPOOLDIR_2;
        } else {
            throw new NewsDbException("can't find spooldir");
        }
        if (LIBDIR_1 != null && new File(LIBDIR_1).exists()) {
            LIBDIR = LIBDIR_1;
        } else {
            try {
                LIBDIR = new UnixUser(LIBDIR_USER_1).getHomeDir();
            }
            catch (IOException iOException) {
                try {
                    LIBDIR = new UnixUser(LIBDIR_USER_2).getHomeDir();
                }
                catch (IOException iOException2) {
                    throw new NewsDbException("can't find libdir");
                }
            }
        }
        AUXLIBDIR = AUXLIBDIR_1 != null && new File(AUXLIBDIR_1).exists() ? AUXLIBDIR_1 : LIBDIR;
        ACTIVE = new File(String.valueOf(LIBDIR) + "/" + "active");
        if (!ACTIVE.exists() && !(ACTIVE = new File(String.valueOf(AUXLIBDIR) + "/" + "active")).exists()) {
            throw new NewsDbException("can't find active");
        }
        HISTORY = new File(String.valueOf(LIBDIR) + "/" + "history");
        if (!HISTORY.exists() && !(HISTORY = new File(String.valueOf(AUXLIBDIR) + "/" + "history")).exists()) {
            throw new NewsDbException("can't find history");
        }
        NEWSGROUPS = new File(String.valueOf(LIBDIR) + "/" + "newsgroups");
        if (!NEWSGROUPS.exists()) {
            NEWSGROUPS = null;
        }
        if (!(NNRP_ACCESS = new File(String.valueOf(LIBDIR) + "/" + "nnrp.access")).exists()) {
            NNRP_ACCESS = null;
        }
        if (!(ACTIVE_TIMES = new File(String.valueOf(LIBDIR) + "/" + "active.times")).exists()) {
            ACTIVE_TIMES = null;
        }
        if (!(DISTRIBUTIONS = new File(String.valueOf(LIBDIR) + "/" + "distributions")).exists()) {
            DISTRIBUTIONS = null;
        }
        if (!(DISTRIB_PATS = new File(String.valueOf(LIBDIR) + "/" + "distrib.pats")).exists()) {
            DISTRIB_PATS = null;
        }
        if (!(OVERVIEW_FMT = new File(String.valueOf(LIBDIR) + "/" + "overview.fmt")).exists()) {
            OVERVIEW_FMT = null;
        }
    }

    private synchronized void checkGroups() throws NewsDbException {
        this.checkGroupDescs();
        long now = System.currentTimeMillis();
        if (this.groupTable != null && now - this.groupsFetched < 1800000L) {
            return;
        }
        this.groupTable = new Hashtable();
        this.groupsFetched = now;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(ACTIVE));
            while ((line = br.readLine()) != null) {
                int firstArtNum;
                int lastArtNum;
                String[] words = Utils.splitStr(line);
                String groupName = words[0];
                try {
                    lastArtNum = Integer.parseInt(words[1]);
                    firstArtNum = Integer.parseInt(words[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                char flag = words[3].charAt(0);
                NewsDbGroup group = new NewsDbGroup(this.dbStamp, groupName, lastArtNum - firstArtNum + 1, firstArtNum, lastArtNum, flag, (String)this.groupDescsTable.get(groupName));
                this.groupTable.put(group.getName(), group);
            }
            br.close();
        }
        catch (IOException e) {
            throw new NewsDbException("problem reading groups: " + e);
        }
    }

    private synchronized void checkGroupDescs() throws NewsDbException {
        long now = System.currentTimeMillis();
        if (this.groupDescsTable != null && now - this.groupDescsFetched < 86400000L) {
            return;
        }
        this.groupDescsFetched = now;
        this.groupDescsTable = new Hashtable();
        if (NEWSGROUPS == null) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(NEWSGROUPS));
            while ((line = br.readLine()) != null) {
                int ws = Utils.strCSpan(line, " \t");
                int nws = ws + Utils.strSpan(line, " \t", ws);
                String groupName = line.substring(0, ws);
                String groupDesc = line.substring(nws);
                this.groupDescsTable.put(groupName, groupDesc);
            }
            br.close();
        }
        catch (IOException e) {
            throw new NewsDbException("problem reading group descriptions: " + e);
        }
    }
}

