/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.LruHashtableEnumerator;
import java.util.Enumeration;
import java.util.Hashtable;

public class LruHashtable
extends Hashtable {
    private static final int nBuckets = 2;
    private float loadFactor;
    private int threshold;
    private int eachCapacity;
    private Hashtable oldTable;
    private Hashtable newTable;

    public LruHashtable(int initialCapacity, float loadFactor) {
        super(1);
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor) - 1;
        this.eachCapacity = initialCapacity / 2 + 1;
        this.oldTable = new Hashtable(this.eachCapacity, loadFactor);
        this.newTable = new Hashtable(this.eachCapacity, loadFactor);
    }

    public LruHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public int size() {
        return this.newTable.size() + this.oldTable.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized Enumeration keys() {
        return new LruHashtableEnumerator(this.oldTable, this.newTable, true);
    }

    public synchronized Enumeration elements() {
        return new LruHashtableEnumerator(this.oldTable, this.newTable, false);
    }

    public synchronized boolean contains(Object value) {
        if (this.newTable.contains(value)) {
            return true;
        }
        return this.oldTable.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        if (this.newTable.containsKey(key)) {
            return true;
        }
        if (this.oldTable.containsKey(key)) {
            Object value = this.oldTable.get(key);
            this.newTable.put(key, value);
            this.oldTable.remove(key);
            return true;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        Object value = this.newTable.get(key);
        if (value != null) {
            return value;
        }
        value = this.oldTable.get(key);
        if (value != null) {
            this.newTable.put(key, value);
            this.oldTable.remove(key);
            return value;
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        Object oldValue = this.newTable.put(key, value);
        if (oldValue != null) {
            return oldValue;
        }
        oldValue = this.oldTable.get(key);
        if (oldValue != null) {
            this.oldTable.remove(key);
        } else if (this.size() >= this.threshold) {
            this.oldTable = this.newTable;
            this.newTable = new Hashtable(this.eachCapacity, this.loadFactor);
        }
        return oldValue;
    }

    public synchronized Object remove(Object key) {
        Object oldValue = this.newTable.remove(key);
        if (oldValue == null) {
            oldValue = this.oldTable.remove(key);
        }
        return oldValue;
    }

    public synchronized void clear() {
        this.newTable.clear();
        this.oldTable.clear();
    }

    public synchronized Object clone() {
        LruHashtable n = (LruHashtable)super.clone();
        n.newTable = (Hashtable)n.newTable.clone();
        n.oldTable = (Hashtable)n.oldTable.clone();
        return n;
    }
}

