/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM;

import Acme.GuiUtils;
import Acme.JPM.Encoders.GifEncoder;
import Acme.JPM.Encoders.ImageEncoder;
import Acme.JPM.Encoders.PpmEncoder;
import Acme.JPM.Filters.EdgeDetect;
import Acme.JPM.Filters.Enlarge;
import Acme.JPM.Filters.Flip;
import Acme.JPM.Filters.Gamma;
import Acme.JPM.Filters.Invert;
import Acme.JPM.Filters.Margin;
import Acme.JPM.Filters.Oil;
import Acme.JPM.Filters.Rotate;
import Acme.JPM.Filters.ScaleCopy;
import Acme.JPM.Filters.Shear;
import Acme.JPM.Filters.Shrink;
import Acme.JPM.Filters.Smooth;
import Acme.JPM.Filters.Tile;
import Acme.JPM.JPMUtils;
import Acme.Widgets.ImageLabel;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;
import java.io.OutputStream;

public class JPMTest
extends Frame {
    private static JPMTest jpmTest;
    private ImageLabel origImageLabel;
    private ImageLabel filt1ImageLabel;
    private ImageLabel filt2ImageLabel;
    private Image origImage;
    private Image filt1Image;
    private Image filt2Image;
    private Choice filt1Choice;
    private Choice filt2Choice;
    private Choice outputChoice;
    private static final int GIF = 0;
    private static final int PPM = 1;
    private static final int NONE = 0;
    private static final int SHRINK2 = 1;
    private static final int ENLARGE2 = 2;
    private static final int SCALE051 = 3;
    private static final int SCALE199 = 4;
    private static final int OIL = 5;
    private static final int SMOOTH2 = 6;
    private static final int EDGEDETECT = 7;
    private static final int GAMMA2 = 8;
    private static final int TILE400 = 9;
    private static final int FLIPLR = 10;
    private static final int FLIPTB = 11;
    private static final int FLIPCW = 12;
    private static final int INVERT = 13;
    private static final int MARGIN = 14;
    private static final int SHEAR30 = 15;
    private static final int ROTATE30 = 16;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: JPMTest [filename]");
            System.exit(1);
        }
        jpmTest = new JPMTest(args[0]);
    }

    public JPMTest(String fileName) {
        this.setTitle("JPMTest");
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        Panel panel = new Panel();
        GridBagLayout gb2 = new GridBagLayout();
        panel.setLayout(gb2);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = new Insets(5, 5, 5, 5);
        Label label = new Label(fileName);
        gbc2.gridwidth = 1;
        gb2.setConstraints(label, gbc2);
        panel.add(label);
        this.filt1Choice = new Choice();
        this.addChoiceItems(this.filt1Choice);
        gbc2.gridwidth = 1;
        gb2.setConstraints(this.filt1Choice, gbc2);
        panel.add(this.filt1Choice);
        this.filt2Choice = new Choice();
        this.addChoiceItems(this.filt2Choice);
        gbc2.gridwidth = 0;
        gb2.setConstraints(this.filt2Choice, gbc2);
        panel.add(this.filt2Choice);
        this.origImageLabel = new ImageLabel(GuiUtils.brokenIcon(this));
        gbc2.gridwidth = 1;
        gb2.setConstraints(this.origImageLabel, gbc2);
        panel.add(this.origImageLabel);
        this.filt1ImageLabel = new ImageLabel(GuiUtils.brokenIcon(this));
        gbc2.gridwidth = 1;
        gb2.setConstraints(this.filt1ImageLabel, gbc2);
        panel.add(this.filt1ImageLabel);
        this.filt2ImageLabel = new ImageLabel(GuiUtils.brokenIcon(this));
        gbc2.gridwidth = 0;
        gb2.setConstraints(this.filt2ImageLabel, gbc2);
        panel.add(this.filt2ImageLabel);
        gb.setConstraints(panel, gbc);
        this.add(panel);
        panel = new Panel();
        gb2 = new GridBagLayout();
        panel.setLayout(gb2);
        this.outputChoice = new Choice();
        this.outputChoice.addItem("GIF");
        this.outputChoice.addItem("PPM");
        gbc2.gridwidth = 1;
        gb2.setConstraints(this.outputChoice, gbc2);
        panel.add(this.outputChoice);
        Button button = new Button("Write");
        gbc2.gridwidth = 1;
        gb2.setConstraints(button, gbc2);
        panel.add(button);
        button = new Button("Quit");
        gbc2.gridwidth = 0;
        gb2.setConstraints(button, gbc2);
        panel.add(button);
        gb.setConstraints(panel, gbc);
        this.add(panel);
        this.pack();
        this.validate();
        this.show();
        this.origImage = this.getToolkit().getImage(fileName);
        this.origImageLabel.setImage(this.origImage);
        this.filt1Choice.select(0);
        this.filt2Choice.select(0);
        this.filter1();
        this.filter2();
    }

    private void addChoiceItems(Choice choice) {
        choice.addItem("NONE");
        choice.addItem("Shrink 2");
        choice.addItem("Enlarge 2");
        choice.addItem("ScaleCopy 0.51");
        choice.addItem("ScaleCopy 1.99");
        choice.addItem("Oil");
        choice.addItem("Smooth 2");
        choice.addItem("EdgeDetect");
        choice.addItem("Gamma 2");
        choice.addItem("Tile 400");
        choice.addItem("Flip -lr");
        choice.addItem("Flip -tb");
        choice.addItem("Flip -cw");
        choice.addItem("Invert");
        choice.addItem("Margin");
        choice.addItem("Shear 30");
        choice.addItem("Rotate 30");
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 1001: {
                if (evt.arg.equals("Quit")) {
                    System.exit(0);
                    break;
                }
                if (evt.arg.equals("Write")) {
                    this.write();
                    break;
                }
                if (evt.target == this.filt1Choice) {
                    this.filter1();
                    this.filter2();
                    break;
                }
                if (evt.target != this.filt2Choice) break;
                this.filter2();
                break;
            }
        }
        return super.handleEvent(evt);
    }

    private void write() {
        try {
            ImageEncoder encoder = null;
            switch (this.outputChoice.getSelectedIndex()) {
                case 0: {
                    encoder = new GifEncoder(this.filt2Image.getSource(), (OutputStream)System.out);
                    break;
                }
                case 1: {
                    encoder = new PpmEncoder(this.filt2Image.getSource(), (OutputStream)System.out);
                    break;
                }
            }
            encoder.encode();
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
    }

    private void filter1() {
        this.filt1Image = this.filterImage(this.filt1Choice.getSelectedIndex(), this.origImage);
        this.filt1ImageLabel.setImage(this.filt1Image);
    }

    private void filter2() {
        this.filt2Image = this.filterImage(this.filt2Choice.getSelectedIndex(), this.filt1Image);
        this.filt2ImageLabel.setImage(this.filt2Image);
    }

    private Image filterImage(int which, Image image) {
        switch (which) {
            case 0: {
                return image;
            }
            case 1: {
                return JPMUtils.filterImage(this, new Shrink(image.getSource(), 2));
            }
            case 2: {
                return JPMUtils.filterImage(this, new Enlarge(image.getSource(), 2));
            }
            case 3: {
                return JPMUtils.filterImage(this, new ScaleCopy(image.getSource(), 0.51));
            }
            case 4: {
                return JPMUtils.filterImage(this, new ScaleCopy(image.getSource(), 1.99));
            }
            case 5: {
                return JPMUtils.filterImage(this, new Oil(image.getSource()));
            }
            case 6: {
                return JPMUtils.filterImage(this, new Smooth(image.getSource(), 2));
            }
            case 7: {
                return JPMUtils.filterImage(this, new EdgeDetect(image.getSource()));
            }
            case 8: {
                return JPMUtils.filterImage(this, new Gamma(image.getSource(), 2.0));
            }
            case 9: {
                return JPMUtils.filterImage(this, new Tile(image.getSource(), 400, 400));
            }
            case 10: {
                return JPMUtils.filterImage(this, new Flip(image.getSource(), 1));
            }
            case 11: {
                return JPMUtils.filterImage(this, new Flip(image.getSource(), 2));
            }
            case 12: {
                return JPMUtils.filterImage(this, new Flip(image.getSource(), 4));
            }
            case 13: {
                return JPMUtils.filterImage(this, new Invert(image.getSource()));
            }
            case 14: {
                return JPMUtils.filterImage(this, new Margin(image.getSource(), Color.black, 10));
            }
            case 15: {
                return JPMUtils.filterImage(this, new Shear(image.getSource(), 30.0));
            }
            case 16: {
                return JPMUtils.filterImage(this, new Rotate(image.getSource(), 30.0));
            }
        }
        return null;
    }
}

