/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class Oil
extends RGBAllFilter {
    private int n;

    public Oil(ImageProducer producer, int n) {
        super(producer);
        this.n = n;
    }

    public Oil(ImageProducer producer) {
        this(producer, 3);
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        int[] rHist = new int[256];
        int[] gHist = new int[256];
        int[] bHist = new int[256];
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                int i = 0;
                while (i < 256) {
                    bHist[i] = 0;
                    gHist[i] = 0;
                    rHist[i] = 0;
                    ++i;
                }
                int drow = row - this.n;
                while (drow <= row + this.n) {
                    if (drow >= 0 && drow < height) {
                        int dcol = col - this.n;
                        while (dcol <= col + this.n) {
                            if (dcol >= 0 && dcol < width) {
                                int rgb = rgbPixels[drow][dcol];
                                int n = rgb >> 16 & 0xFF;
                                rHist[n] = rHist[n] + 1;
                                int n2 = rgb >> 8 & 0xFF;
                                gHist[n2] = gHist[n2] + 1;
                                int n3 = rgb & 0xFF;
                                bHist[n3] = bHist[n3] + 1;
                            }
                            ++dcol;
                        }
                    }
                    ++drow;
                }
                int r = 0;
                int g = 0;
                int b = 0;
                int i2 = 1;
                while (i2 < 256) {
                    if (rHist[i2] > rHist[r]) {
                        r = i2;
                    }
                    if (gHist[i2] > gHist[g]) {
                        g = i2;
                    }
                    if (bHist[i2] > bHist[b]) {
                        b = i2;
                    }
                    ++i2;
                }
                newPixels[row][col] = 0xFF000000 | r << 16 | g << 8 | b;
                ++col;
            }
            ++row;
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        int n = -1;
        int argc = args.length;
        int argn = 0;
        while (argn < argc && args[argn].charAt(0) == '-') {
            if (args[argn].equals("-n") && argn + 1 < argc) {
                n = Integer.parseInt(args[++argn]);
            } else {
                Oil.usage();
            }
            ++argn;
        }
        if (argn != argc) {
            Oil.usage();
        }
        Oil filter = n == -1 ? new Oil(null) : new Oil(null, n);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Oil [-n N]");
        System.exit(1);
    }
}

