/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBAllFilter;
import java.awt.image.ImageProducer;

public class EdgeDetect
extends RGBAllFilter {
    private static final double SCALE = 1.8;

    public EdgeDetect(ImageProducer producer) {
        super(producer);
    }

    public void filterRGBAll(int width, int height, int[][] rgbPixels) {
        int[][] newPixels = new int[height][width];
        int col = 0;
        while (col < width) {
            newPixels[0][col] = -16777216;
            newPixels[height - 1][col] = -16777216;
            ++col;
        }
        int row = 1;
        while (row < height - 1) {
            newPixels[row][0] = -16777216;
            newPixels[row][width - 1] = -16777216;
            int col2 = 1;
            while (col2 < width - 1) {
                long sum1 = ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col2 + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col2 - 1]) + 2 * (ImageFilterPlus.rgbModel.getRed(rgbPixels[row][col2 + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row][col2 - 1])) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col2 + 1]) - ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col2 - 1]);
                long sum2 = ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col2]) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row + 1][col2 + 1]) - (ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col2]) + ImageFilterPlus.rgbModel.getRed(rgbPixels[row - 1][col2 + 1]));
                double sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int r = Math.min((int)sum, 255);
                sum1 = ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col2 + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col2 - 1]) + 2 * (ImageFilterPlus.rgbModel.getGreen(rgbPixels[row][col2 + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row][col2 - 1])) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col2 + 1]) - ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col2 - 1]);
                sum2 = ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col2]) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row + 1][col2 + 1]) - (ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col2]) + ImageFilterPlus.rgbModel.getGreen(rgbPixels[row - 1][col2 + 1]));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int g = Math.min((int)sum, 255);
                sum1 = ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col2 + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col2 - 1]) + 2 * (ImageFilterPlus.rgbModel.getBlue(rgbPixels[row][col2 + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row][col2 - 1])) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col2 + 1]) - ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col2 - 1]);
                sum2 = ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col2]) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row + 1][col2 + 1]) - (ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col2 - 1]) + 2 * ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col2]) + ImageFilterPlus.rgbModel.getBlue(rgbPixels[row - 1][col2 + 1]));
                sum = Math.sqrt(sum1 * sum1 + sum2 * sum2) / 1.8;
                int b = Math.min((int)sum, 255);
                newPixels[row][col2] = 0xFF000000 | r << 16 | g << 8 | b;
                ++col2;
            }
            ++row;
        }
        this.setPixels(width, height, newPixels);
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            EdgeDetect.usage();
        }
        EdgeDetect filter = new EdgeDetect(null);
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: EdgeDetect");
        System.exit(1);
    }
}

