/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DevRestartCmd;
import fr.esrf.TangoDs.DevStateCmd;
import fr.esrf.TangoDs.DevStatusCmd;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.MultiClassAttribute;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;

public abstract class DeviceClass
implements TangoConst {
    protected String name;
    protected String doc_url;
    protected Vector command_list;
    protected Vector device_list;
    protected DbClass db_class;
    protected MultiClassAttribute class_attr;

    protected DeviceClass(String string) {
        this.name = string;
        this.db_class = null;
        this.command_list = new Vector();
        this.device_list = new Vector();
        this.command_list.addElement(new DevStatusCmd(new String("DevStatus"), 0, 8, new String("Device status")));
        this.command_list.addElement(new DevStateCmd(new String("DevState"), 0, 19, new String("Device state")));
        this.command_list.addElement(new DevRestartCmd(new String("DevRestart"), 0, 0));
        this.get_class_system_resource();
        this.class_attr = new MultiClassAttribute();
    }

    public void attribute_factory(Vector vector) {
    }

    public abstract void command_factory();

    public Any command_handler(DeviceImpl deviceImpl, String string, Any any) throws DevFailed {
        StringBuffer stringBuffer;
        Any any2 = Util.instance().get_orb().create_any();
        Util.out4.println("Entering DeviceClass::command_handler() method");
        int n = 0;
        while (n < this.command_list.size()) {
            if (((Command)this.command_list.elementAt(n)).get_name().equals(string)) {
                deviceImpl.always_executed_hook();
                if (!((Command)this.command_list.elementAt(n)).is_allowed(deviceImpl, any)) {
                    stringBuffer = new StringBuffer("Command ");
                    stringBuffer.append(string);
                    stringBuffer.append(" not allowed when the device is in ");
                    stringBuffer.append(TangoConst.Tango_DevStateName[deviceImpl.get_state().value()]);
                    stringBuffer.append(" state");
                    Except.throw_exception("API_CommandNotAllowed", new String(stringBuffer), new String("DeviceClass.command_handler"));
                }
                any2 = ((Command)this.command_list.elementAt(n)).execute(deviceImpl, any);
                break;
            }
            ++n;
        }
        if (n == this.command_list.size()) {
            Util.out3.println("DeviceClass.command_handler(): command " + string + " not found");
            stringBuffer = new StringBuffer("Command ");
            stringBuffer.append(string);
            stringBuffer.append(" not found");
            Except.throw_exception("API_CommandNotFound", new String(stringBuffer), new String("DeviceClass.command_handler"));
        }
        Util.out4.println("Leaving DeviceClass.command_handler() method");
        return any2;
    }

    public abstract void device_factory(String[] var1) throws DevFailed;

    protected void export_device(DeviceImpl deviceImpl) throws DevFailed {
        Util.out4.println("DeviceClass::export_device() arrived");
        Util util = Util.instance();
        Util.out4.println("Leaving DeviceClass::export_device method()");
    }

    public MultiClassAttribute get_class_attr() {
        return this.class_attr;
    }

    private void get_class_system_resource() {
        block6: {
            Util.instance();
            if (Util._UseDb) {
                try {
                    DbDatum dbDatum = this.db_class.get_property(new String("doc_url"));
                    if (dbDatum.is_empty()) {
                        Util.out4.println("doc_url property for class " + this.name + " is not defined in database");
                        this.doc_url = "http://www.ulla.com";
                        break block6;
                    }
                    this.doc_url = dbDatum.extractString();
                }
                catch (Tango.DevFailed devFailed) {
                    this.doc_url = "http://www.ulla.com";
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    this.doc_url = "http://www.ulla.com";
                }
            } else {
                this.doc_url = "http://www.ulla.com";
            }
        }
    }

    public Vector get_command_list() {
        return this.command_list;
    }

    public DbClass get_db_class() {
        return this.db_class;
    }

    public Vector get_device_list() {
        return this.device_list;
    }

    public String get_doc_url() {
        return this.doc_url;
    }

    public String get_name() {
        return this.name;
    }
}

