/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import com.ooc.OCI.Current;
import com.ooc.OCI.CurrentHelper;
import com.ooc.OCI.IIOP.TransportInfo;
import com.ooc.OCI.IIOP.TransportInfoHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.BlackBoxElt;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

class BlackBox
implements TangoConst {
    private BlackBoxElt[] box;
    private int insert_elt;
    private int nb_elt;
    private int max_elt;
    private StringBuffer elt_str;
    private Current current;

    public BlackBox() {
        this.box = new BlackBoxElt[25];
        int n = 0;
        while (n < 25) {
            this.box[n] = new BlackBoxElt();
            ++n;
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = 25;
        Util util = Util.instance();
        Object object = null;
        try {
            object = util.get_orb().resolve_initial_references("OCICurrent");
            this.current = CurrentHelper.narrow((Object)object);
        }
        catch (InvalidName invalidName) {
            this.current = null;
        }
    }

    public BlackBox(int n) {
        this.box = new BlackBoxElt[n];
        int n2 = 0;
        while (n2 < n) {
            this.box[n2] = new BlackBoxElt();
            ++n2;
        }
        this.insert_elt = 0;
        this.nb_elt = 0;
        this.max_elt = n;
        Util util = Util.instance();
        Object object = null;
        try {
            object = util.get_orb().resolve_initial_references("OCICurrent");
            this.current = CurrentHelper.narrow((Object)object);
        }
        catch (InvalidName invalidName) {
            this.current = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void build_info_as_str(int n) {
        block24: {
            block25: {
                block23: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SS");
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("ECT"));
                    String string = simpleDateFormat.format(this.box[n].when);
                    this.elt_str = new StringBuffer(string);
                    this.elt_str.append(" : ");
                    if (this.box[n].req_type != 1) break block23;
                    this.elt_str.append("Operation ");
                    switch (this.box[n].op_type) {
                        case 1: {
                            this.elt_str.append("command_inout (cmd = ");
                            this.elt_str.append(this.box[n].cmd_name);
                            this.elt_str.append(") ");
                            break block24;
                        }
                        case 3: {
                            this.elt_str.append("ping ");
                            break block24;
                        }
                        case 4: {
                            this.elt_str.append("info ");
                            break block24;
                        }
                        case 2: {
                            this.elt_str.append("blackbox ");
                            break block24;
                        }
                        case 5: {
                            this.elt_str.append("command_list_query ");
                            break block24;
                        }
                        case 6: {
                            this.elt_str.append("command_query ");
                            break block24;
                        }
                        case 7: {
                            this.elt_str.append("get_attribute_config ");
                            break block24;
                        }
                        case 8: {
                            this.elt_str.append("set_attribute_config ");
                            break block24;
                        }
                        case 9: {
                            this.elt_str.append("read_attributes ");
                            break block24;
                        }
                        case 10: {
                            this.elt_str.append("write_attributes ");
                            break block24;
                        }
                        case 0: {
                            this.elt_str.append("unknown operation !!!!!");
                            return;
                        }
                        default: {
                            if (this.box[n].host.equals("Unknown")) return;
                        }
                    }
                }
                if (this.box[n].req_type != 2) break block25;
                this.elt_str.append("Attribute ");
                switch (this.box[n].attr_type) {
                    case 1: {
                        this.elt_str.append("name ");
                        break block24;
                    }
                    case 2: {
                        this.elt_str.append("description ");
                        break block24;
                    }
                    case 4: {
                        this.elt_str.append("status ");
                        break block24;
                    }
                    case 3: {
                        this.elt_str.append("state ");
                        break block24;
                    }
                    case 0: {
                        this.elt_str.append("unknown attribute !!!!!");
                        return;
                    }
                    default: {
                        if (this.box[n].host.equals("Unknown")) return;
                    }
                }
            }
            this.elt_str.append("Unknown CORBA request type !!!!!");
            return;
        }
        if (this.box[n].host.equals("Unknown")) return;
        int[] nArray = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            nArray[n2] = this.box[n].host_ip[n2] < 0 ? 255 + this.box[n].host_ip[n2] + 1 : this.box[n].host_ip[n2];
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(nArray[0]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[1]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[2]);
        stringBuffer.append(".");
        stringBuffer.append(nArray[3]);
        this.elt_str.append("requested from ");
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(stringBuffer.toString());
            this.elt_str.append(inetAddress.getHostName());
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.elt_str.append(stringBuffer.toString());
        }
    }

    private void get_client_host() {
        if (this.current != null) {
            com.ooc.OCI.TransportInfo transportInfo = this.current.get_oci_transport_info();
            TransportInfo transportInfo2 = TransportInfoHelper.narrow((Object)transportInfo);
            if (transportInfo2 != null) {
                this.box[this.insert_elt].host_ip = transportInfo2.remote_addr();
                this.box[this.insert_elt].host = new String("Defined");
            } else {
                this.box[this.insert_elt].host = new String("Unknown");
            }
        }
    }

    private void inc_indexes() {
        ++this.insert_elt;
        if (this.insert_elt == this.max_elt) {
            this.insert_elt = 0;
        }
        if (this.nb_elt != this.max_elt) {
            ++this.nb_elt;
        }
    }

    public void insert_attr(int n) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = n;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public void insert_attr(int n, String string) {
        this.box[this.insert_elt].req_type = 2;
        this.box[this.insert_elt].attr_type = n;
        this.box[this.insert_elt].op_type = 0;
        this.box[this.insert_elt].host = string;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public void insert_cmd(String string) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = 1;
        this.box[this.insert_elt].cmd_name = string;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public void insert_cmd(String string, String string2) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = 1;
        this.box[this.insert_elt].cmd_name = string;
        this.box[this.insert_elt].host = string2;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public void insert_op(int n) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = n;
        this.box[this.insert_elt].when = new Date();
        this.get_client_host();
        this.inc_indexes();
    }

    public void insert_op(int n, String string) {
        this.box[this.insert_elt].req_type = 1;
        this.box[this.insert_elt].attr_type = 0;
        this.box[this.insert_elt].op_type = n;
        this.box[this.insert_elt].host = string;
        this.box[this.insert_elt].when = new Date();
        this.inc_indexes();
    }

    public String[] read(int n) throws DevFailed {
        if (n <= 0) {
            Except.throw_exception("API_BlackBoxArgument", "Argument to read black box out of range", "BlackBox::read");
        }
        if (this.nb_elt == 0) {
            Except.throw_exception("API_BlackBoxArgument", "Nothing stored yet in black-box", "BlackBox::read");
        }
        if (n > this.max_elt) {
            n = this.max_elt;
        }
        if (n > this.nb_elt) {
            n = this.nb_elt;
        }
        String[] stringArray = new String[n];
        int n2 = this.insert_elt == 0 ? this.max_elt - 1 : this.insert_elt - 1;
        int n3 = 0;
        while (n3 < n) {
            this.build_info_as_str(n2);
            stringArray[n3] = new String(this.elt_str);
            if (--n2 < 0) {
                n2 = this.max_elt - 1;
            }
            ++n3;
        }
        return stringArray;
    }
}

