/*static char RcsId[] = "$Header: python.c,v 1.9 2000/07/20 17:10:03 meyer Rel $";*/
/*********************************************************************
 *
 *File:		Python.c
 *
 *Project:	Python device server
 *
 *Description:	Supports a device server class written in Python
 *
 *Author(s):	J. Meyer
 *
 *Original:	June 2000
 *
 *$Log:	python.c,v $
 * Revision 1.9  2000/07/20  17:10:03  17:10:03  meyer (J.Meyer)
 * Cleaned-up sources
 * 
 * Revision 1.8  2000/07/20  17:06:59  17:06:59  meyer (J.Meyer)
 * cleaned-up sources.
 * 
 * Revision 1.7  2000/06/23  15:50:07  15:50:07  meyer (J.Meyer)
 * Added methode to read command name string to Server.c
 * 
 * Revision 1.6  2000/06/22  13:09:55  13:09:55  meyer (Jens MEYER)
 * Can handle several Python classes
 * 
 * Revision 1.5  2000/06/22  08:50:41  08:50:41  meyer (Jens MEYER)
 * Correct memory treatment with arrays.
 * 
 * Revision 1.4  2000/06/16  18:26:22  18:26:22  meyer (Jens MEYER)
 * First running version
 * 
 * Revision 1.2  2000/06/15  14:31:52  14:31:52  meyer (Jens MEYER)
 * *** empty log message ***
 * 
 * Revision 1.1  2000/06/08  12:18:41  12:18:41  meyer (Jens MEYER)
 * Initial revision
 * 
 *Copyright(c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *File generated by the Automatic Class Generation Tool
 *
 *********************************************************************/

#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Admin.h>

#include <DevServerP.h>
#include <pythonP.h>
#include <python.h>


/*
 * external python object
 */
 
extern PyObject 	*Py_devices;
extern PyObject		*ErrorObject;
extern PyThreadState	*thread_state;
 
/*
 * public methods
 */

static long class_initialise(long *error);
static long object_create(char *name,DevServer *ds_ptr,long *error);
static long object_initialise(Python ds,long *error);
static long state_handler(Python ds,DevCommand cmd,long *error);

static	DevMethodListEntry methods_list[] = {
   	{DevMethodClassInitialise,	class_initialise},
   	{DevMethodInitialise,		object_initialise},
  	{DevMethodCreate,		object_create},
   	{DevMethodStateHandler,		state_handler},
   };


PythonClassRec pythonClassRec = {
   /* n_methods */        sizeof(methods_list)/sizeof(DevMethodListEntry),
   /* methods_list */     methods_list,
   };

PythonClass pythonClass = (PythonClass)&pythonClassRec;

/*
 * public commands
 */

static long dev_exec_cmd (Python ds,DevVoid *argin, DevVoid *argout, long *error);


/*
 * reserve space for a default copy of the python object
 */

static PythonRec pythonRec;
static Python python = (Python)&pythonRec;


/*======================================================================
 Function:      static long class_initialise()

 Description:	routine to be called the first time a device is 
 		created which belongs to this class (or is a subclass
		thereof. This routine will be called only once.

 Arg(s) In:	none

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long class_initialise(long *error)
{
   *error = 0; 

   /*
    * PythonClass is a subclass of the DevServerClass
    */

   pythonClass->devserver_class.superclass = devServerClass;
   pythonClass->devserver_class.class_inited = 1;
          		
   /*
    * initialise object with default values. These will be used
    * for every Python object created.
    */

   python->devserver.class_pointer = (DevServerClass)pythonClass;
   python->devserver.state         = DEVUNKNOWN;
  
   return(DS_OK);
}



/*======================================================================
 Function:	static long object_create()

 Description:	routine to be called on creation of a device object

 Arg(s) In:	char *name - name to be given to device

 Arg(s) Out:	DevServer *ds_ptr - pointer to created device
		long *error       - pointer to error code, 
				    in case routine fails
 =======================================================================*/

static long object_create(char *name,DevServer *ds_ptr, long *error)
{
   Python ds;

   ds = (Python)malloc(sizeof(PythonRec));

/*
 * initialise device with default object
 */

   *(PythonRec*)ds = *(PythonRec*)python;

/*
 * finally initialise the non-default values
 */

   ds->devserver.name = (char*)malloc(strlen(name)+1);
   sprintf(ds->devserver.name,"%s",name);
   
   printf ("device_name = %s\n", ds->devserver.name);

   *ds_ptr = (DevServer)ds;

   return(DS_OK);
}

/*============================================================================

Function:	static long object_initialise()

Description:	routine to be called on initialisation of a device object

Arg(s) In:	Python ds	- object to initialise

Arg(s) Out:	long *error     - pointer to error code, in case routine fails
=============================================================================*/
static long object_initialise (Python ds, long *error)
{
	PythonClass	object_class;
   	PyObject 	*Py_device;
   	PyObject 	*py_cmd_list;
   	PyObject 	*py_cmd_list_keys;
   	PyObject 	*py_key;
   	PyObject 	*py_cmd_list_item;
   	PyObject	*py_argin_type;
   	PyObject	*py_argout_type;
   	PyObject 	*py_name;
	
   	long 		nu_of_cmds;
   	char		*class_name;
   	short		i;	
	
	*error = 0;
	
	/*
	 * Allocate a new class structure for every object.
	 * This class is a generic class which can export serveral
	 * pyhton classes at the same time.
	 */
	 
	object_class = (PythonClass) calloc (1, sizeof(PythonClassRec));
	
	/*
	 * Copy the references from the global pyhton class object
	 */
	 
	object_class->devserver_class.n_methods = 
				pythonClass->devserver_class.n_methods;
	object_class->devserver_class.methods_list = 
				pythonClass->devserver_class.methods_list;
	object_class->devserver_class.superclass = 
				pythonClass->devserver_class.superclass; 
	object_class->devserver_class.class_inited = 
				pythonClass->devserver_class.class_inited; 
				
	/*
 	 * Read the class name from the python object
 	 */
	 
   	py_name    = PyObject_CallMethod 
				(ds->python.Py_device, "get_class_name", NULL);
   	class_name = PyString_AsString(py_name);
   	printf ("class name = %s\n", class_name);

   	object_class->devserver_class.class_name = 
				(char*)malloc(strlen(class_name)+1);
   	sprintf (object_class->devserver_class.class_name, class_name);
   
   	/*
    	 * Initialise the command list from the Python object!
    	 */
    
   	/*
    	 * Get the number of available commands
    	 */
    
   	py_cmd_list      = PyObject_CallMethod 
				(ds->python.Py_device, "get_cmd_list", NULL);	 
   	py_cmd_list_keys = PyDict_Keys (py_cmd_list);
   	nu_of_cmds       = PyList_Size (py_cmd_list_keys);       
   	object_class->devserver_class.n_commands = nu_of_cmds;
   
   	/*
    	 * Allocate space for the command list
    	 */
    
   	object_class->devserver_class.commands_list = 
     	(DevCommandListEntry *) calloc (nu_of_cmds, sizeof(DevCommandListEntry));  

   	/*
    	 * Fill the command list
    	 */
    
   	for (i=0; i<nu_of_cmds; i++)
      	   {
           /* Get the command */
           py_key = PyList_GetItem (py_cmd_list_keys, i);
           object_class->devserver_class.commands_list[i].cmd = 
	   						PyInt_AsLong(py_key);
      
           /* Store the command function pointer */
           object_class->devserver_class.commands_list[i].fn = dev_exec_cmd;
      
           /* Get the input and output argument data types */
           py_cmd_list_item = PyDict_GetItem (py_cmd_list, py_key);
           py_argin_type    = PyList_GetItem (py_cmd_list_item, 0);
           py_argout_type   = PyList_GetItem (py_cmd_list_item, 1);
      
           object_class->devserver_class.commands_list[i].argin_type = 
      						PyInt_AsLong(py_argin_type);
           object_class->devserver_class.commands_list[i].argout_type = 
      						PyInt_AsLong(py_argout_type);  
           }  
        		
	 /*
 	  * initialise object with default values. These will be used
 	  * for every Python object created.
 	  */

   	ds->devserver.class_pointer = (DevServerClass)object_class;

	/*
 	 * Free allocated memory
 	 */
 
   	Py_XDECREF (py_name);
   	Py_XDECREF (py_cmd_list);
   	Py_XDECREF (py_cmd_list_keys);
     				 
   	return(DS_OK);
}

/*======================================================================
 Function:      static long state_handler()

 Description:	this routine is reserved for checking wether the command
		requested can be executed in the present state.

 Arg(s) In:	Python ds - device on which command is to executed
		DevCommand cmd - command to be executed

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long state_handler (Python ds, DevCommand cmd, long *error)
{
   *error = 0;

   /*
    * Store the command to treat
    */
       
   ds->python.cmd_code = cmd;
   
   return (DS_OK);
}



/*============================================================================
 Function:       static long dev_exec_cmd()

 Description:	 A command function called for all incomming commands.
 		 Searches in the command list of the Python object the
		 python method to be called.

 Arg(s) In:	 Python   ds 	  - pointer to C object
		 DevVoid  *argin  - Arguments to be passed to Python
		 		    object
   				  
 Arg(s) Out:	 DevVoid  *argout - Arguments returned from Python 
 			            Object
		 long     *error  - pointer to error code, 
		 		    in case routine fails

============================================================================*/

static long dev_exec_cmd (Python ds, DevVoid *argin, 
                          DevVoid *argout, long *error)
{
	static PyObject *py_argout	= NULL;
	static PyObject *py_error	= NULL;
	static char	*sequence_ptr   = NULL;
	
	PyObject *py_argin		= NULL;
	PyObject *py_cmd_list		= NULL;
	PyObject *py_cmd_list_keys	= NULL;
	PyObject *py_key		= NULL;
	PyObject *py_cmd_list_item	= NULL;
	PyObject *py_method_name	= NULL;
	PyObject *py_argout_type	= NULL;
	PyObject *py_argin_type		= NULL;
	PyObject *py_exception		= NULL;


	char	 error_msg[256];	
	long 	 nu_of_cmds;
	char	 *method_name;
	long	 argout_type;
	long	 argin_type;
	long	 is_single;
	long	 is_array;
	long	 is_special;
	short	 i;
			
   	*error = 0;

        /*
         * Acquire the global interpreter lock and restore the tread state
	 */

	PyEval_RestoreThread (thread_state);
	
	/*
 	 * Free allocated memory from last call
 	 */
	 	
	Py_XDECREF (py_argout);
        Py_XDECREF (py_error);
	if (sequence_ptr != NULL)
	   {
	   free (sequence_ptr);
	   };	   
	  
	/*
	 * Read the command list
	 */
	    	
	py_cmd_list = PyObject_CallMethod (ds->python.Py_device, 
	                                   "get_cmd_list", NULL);
	
	/*
	 * Get the list of commands
	 */
	 
	py_cmd_list_keys = PyDict_Keys (py_cmd_list);
	nu_of_cmds       = PyList_Size (py_cmd_list_keys);
	
	/*
	 * Search the command in list
	 */
	 
	for (i=0; i<nu_of_cmds; i++)
	   {
	   py_key = PyList_GetItem (py_cmd_list_keys, i);
	    
	   if ( ds->python.cmd_code == PyInt_AsLong(py_key) )
	      {
	      /*
	       * Get the python methode to execute
	       */
	       
	      py_cmd_list_item = PyDict_GetItem (py_cmd_list, py_key);
	      py_method_name  = PyList_GetItem (py_cmd_list_item, 2);
	      method_name     = PyString_AsString (py_method_name);
	      
	      /*
	       * Clear all pending python errors
	       */
	       
	      PyErr_Clear(); 
	       
	      /*
	       * convert the incoming data
	       */
	       
	      py_argin_type   = PyList_GetItem (py_cmd_list_item, 0);
	      argin_type      = PyInt_AsLong(py_argin_type);

	      /*
	       * Check the output argument type
	       */
	       
	      is_single	 = 0;
	      is_array   = 0;
	      is_special = 0;      
	      if (check_type (argin_type, &is_single, &is_array,
	                      &is_special) == DS_NOTOK )
	         {
		 printf("unknown input argument type\n");
		 *error = DevErr_DevArgTypeNotRecognised;
		 }
	      else
	         {		 
		 /* If the argument contains only a single value */
		 if ( is_single )
		    {
		    /*
		     * function is called argout, becauase it was 
		     * created for the client part! 
		     */
		     
		    if ( get_argout_single (argin, argin_type,
			                    &py_argin, error_msg) == DS_NOTOK)
		       {
		       printf ("Error: %s\n", error_msg);
		       *error = DevErr_PythonDataConversionError;
		       }
		    }
		 else
		    {
		    /* conver TACO array to python tuple */
		    if ( is_array )
		       {
		       /*
		        * function is called argout, becauase it was 
		        * created for the client part! 
		        */
		     
		       if ( get_argout_array (argin, argin_type,
			                       &py_argin, error_msg)==DS_NOTOK)
		          {
		          printf ("Error: %s\n", error_msg);
		          *error = DevErr_PythonDataConversionError;
			  }		
		       }
		    }
		    
		 if ( argin_type != D_VOID_TYPE )
		    {
		    py_argout = PyObject_CallMethod (ds->python.Py_device, 
			                          method_name, "O", py_argin);
		    }
		 else
		    {
		    py_argout = PyObject_CallMethod (ds->python.Py_device, 
			                          method_name, NULL);
		    }   	      	      
		 }	      
	      
	      /*
 	       * Free allocated memory before any return
 	       */

	       
   	      Py_XDECREF (py_cmd_list_keys);	      
   	      Py_XDECREF (py_cmd_list);
	      Py_XDECREF (py_argin);
	      		 
	      /*
	       * Check for exceptions from the python module
	       */
	       
	      if ( py_argout == NULL )
	         {
		 if ( PyErr_ExceptionMatches (ErrorObject) 
		      == True )
		    {
		    printf ("received a TACO style exception!\n");
		    
		    py_error = PyObject_GetAttrString (ErrorObject, "taco_error");
		    printf ("error = %d \n", PyInt_AsLong(py_error));
									    
		    *error = PyInt_AsLong (py_error);
		    }
		 else
		    {
		    PyErr_Print();
		    
		    *error = DevErr_PythonException;
		    }

        	 /*
         	  * release the global interpreter lock and save 
		  * the thread state
	 	  */

		 thread_state = PyEval_SaveThread();
		 return (DS_NOTOK);
	         }		 				       
	     
	      
	      /*
	       * convert the outgoing data
	       */
	       
	      py_argout_type   = PyList_GetItem (py_cmd_list_item, 1);
	      argout_type      = PyInt_AsLong(py_argout_type);

	      /*
	       * Check the output argument type
	       */
	      
	      is_single	 = 0;
	      is_array   = 0;
	      is_special = 0;      
	      if (check_type (argout_type, &is_single, &is_array,
	                      &is_special) == DS_NOTOK )
	         {
		 printf("unknown output argument type\n");
		 *error = DevErr_DevArgTypeNotRecognised;
		 }
	      else
	         {
		 /*
		  * Set the sequence pointer to NULL if no
		  * array type was requested
		  */
		  
		 if ( !is_array )
		    {
		    sequence_ptr = NULL;
		    } 
		  
		 /* If the argument contains only a single value */
		 if ( is_single )
		    {
		    /*
		     * function is called argin, becauase it was 
		     * created for the client part! 
		     */

		    if ( get_argin_single (argout, argout_type,
			                   py_argout, error_msg) == DS_NOTOK)
		       {
		       printf ("Error: %s\n", error_msg);
		       *error = DevErr_PythonDataConversionError;
		       }	       
		    }
		 else
		    {
		    if ( is_array )
   		       {
      		       /* convert python tuple to TACO variable length array */
		       
                      if ( get_argin_array (argout, argout_type,
		                             py_argout, error_msg) == DS_NOTOK)
                          {
			  printf ("Error: %s\n", error_msg);
		          *error = DevErr_PythonDataConversionError;
		          }
			  
		       /*
		        * Get the sequence pointer which needs to be freed
		        */
		     
		       sequence_ptr = ((DevVarCharArray *)(argout))->sequence;		       
		       }
		    }
		 }
	      }

	   }
	   	   
        /*
         * release the global interpreter lock and save the thread state
	 */
	 
	thread_state = PyEval_SaveThread();

	if ( *error == DS_OK )
  		return(DS_OK);
	else
		return (DS_NOTOK);
}



