/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcClientAuth;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;

public abstract class OncRpcClient {
    protected InetAddress host;
    protected int timeout = 30000;
    protected int program;
    protected int version;
    protected int port;
    protected int xid;
    protected OncRpcClientAuth auth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OncRpcClient(InetAddress inetAddress, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this.host = inetAddress;
        this.program = n;
        this.version = n2;
        long l = System.currentTimeMillis();
        this.xid = (int)l ^ (int)(l >>> 32);
        if (n3 == 0 && n4 != -42) {
            OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(inetAddress);
            try {
                n3 = oncRpcPortmapClient.getPort(n, n2, n4);
            }
            finally {
                oncRpcPortmapClient.close();
            }
        }
        this.port = n3;
    }

    public static OncRpcClient newOncRpcClient(InetAddress inetAddress, int n, int n2, int n3) throws OncRpcException, IOException {
        return OncRpcClient.newOncRpcClient(inetAddress, n, n2, 0, n3);
    }

    public static OncRpcClient newOncRpcClient(InetAddress inetAddress, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        switch (n4) {
            case 17: {
                return new OncRpcUdpClient(inetAddress, n, n2, n3);
            }
            case 6: {
                return new OncRpcTcpClient(inetAddress, n, n2, n3);
            }
        }
        throw new OncRpcException(17);
    }

    public void close() throws OncRpcException {
    }

    public synchronized void call(int n, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        this.call(n, this.version, xdrAble, xdrAble2);
    }

    public abstract void call(int var1, int var2, XdrAble var3, XdrAble var4) throws OncRpcException;

    public void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can not be negative.");
        }
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getProgram() {
        return this.program;
    }

    public int getVersion() {
        return this.version;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAuth(OncRpcClientAuth oncRpcClientAuth) {
        this.auth = oncRpcClientAuth;
    }

    public OncRpcClientAuth getAuth() {
        return this.auth;
    }

    public abstract void setCharacterEncoding(String var1);

    public abstract String getCharacterEncoding();

    protected void nextXid() {
        ++this.xid;
    }
}

