CREATE TABLE NAMES(
	DEVICE_SERVER_CLASS	CHAR(23)	NOT NULL,
	DEVICE_SERVER_NAME	CHAR(11)	NOT NULL,
	INDEX_NUMBER		INTEGER(10)	NOT NULL,
	DOMAIN			CHAR(8)		NOT NULL,
	FAMILY			CHAR(19)	NOT NULL,
	MEMBER			CHAR(19)	NOT NULL,
	HOSTNAME		CHAR(19)	DEFAULT "not_exp",
	PROGRAM_NUMBER		INTEGER(10)	DEFAULT 0,
	VERSION_NUMBER		SMALLINT(4)	DEFAULT 0,
	DEVICE_TYPE		CHAR(23)	DEFAULT "unknown",
	DEVICE_CLASS		CHAR(23)	DEFAULT "unknown",
	PROCESS_ID		SMALLINT(6)	DEFAULT 0,
	PROCESS_NAME		CHAR(39)	DEFAULT "unknown",
	DOMAIN			CHAR(8)		NOT NULL,
	FAMILY			CHAR(19)	NOT NULL,
	MEMBER			CHAR(19)	NOT NULL
);
CREATE UNIQUE INDEX prim ON NAMES(DEVICE_SERVER_CLASS, DEVICE_SERVER_NAME, INDEX_NUMBER);
CREATE UNIQUE INDEX names_dev_idx_1 ON NAMES(DOMAIN, FAMILY, MEMBER);
CREATE TABLE RESOURCE (
	DOMAIN		CHAR(8)		NOT NULL,
	FAMILY		CHAR(19)	NOT NULL,
	MEMBER		CHAR(19)	NOT NULL,
	NAME		CHAR(31)	NOT NULL,
	INDEX_RES	INTEGER(8)	NOT NULL,
	RESVAL		TEXT		NOT NULL
);
CREATE UNIQUE INDEX res_prim ON RESOURCE(DOMAIN, FAMILY, MEMBER, NAME, INDEX_RES);
CREATE INDEX res_idx_1 ON RESOURCE(DOMAIN, FAMILY, MEMBER, NAME);
CREATE TABLE PS_NAMES(
	DOMAIN		CHAR(8)		NOT NULL,
	FAMILY		CHAR(19)	NOT NULL,
	MEMBER		CHAR(19)	NOT NULL,
	HOST		CHAR(19)	NOT NULL,
	PROCESS_ID	SMALLINT(6)	NOT NULL,
	POLL		INTEGER(10)	NOT NULL
);	
CREATE UNIQUE INDEX ps_names_idx_1 ON PS_NAMES(DOMAIN, FAMILY, MEMBER);
