/******************************************************************************
 * Toolkit for building distributed control systems or any other distributed system.
 *
 * Copyright (c) 1990-2005 by European Synchrotron Radiation Facility,
 *                            Grenoble, France
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File:        DevXdrKernel.h
 *
 * Project:     Device Servers with sun-rpc
 *
 * Description: Public include file for all applications
 *		using the standard device server XDR types.
 *		Only the minimal set of types defined in the 
 *		ESRF control system kernel.
 *
 * Author(s):  	Jens Meyer
 * 		$Author: jkrueger1 $
 *
 * Original:	November 1993
 *
 * Version:	$Revision: 1.4 $
 *
 * Date:	$Date: 2008/04/06 09:07:20 $
 *
 *******************************************************************-*/

#ifndef DEVXDRKERNEL_H
#define DEVXDRKERNEL_H

/*
 *  standart header string to use the "what" or "ident".
 */
#ifdef _IDENT
static char DevXdrKernelh[] =
"@(#)$Header: /cvsroot/taco/taco/lib/xdr/DevXdrKernel.h,v 1.4 2008/04/06 09:07:20 jkrueger1 Exp $";
#endif /* _IDENT */


#include <DevErrors.h>

/*
 * include XDR data types for the kernel.
 */
#include <API_xdr.h>
#include <dev_xdr.h>


/* 
 * Define the XDR data type list structure and its size.
 */

#ifdef __cplusplus
extern "C" {
typedef bool_t (*DevDataFunction)(...);
typedef long   (*DevDataLengthFunction)(...);
}
#else
typedef bool_t (*DevDataFunction)();
typedef long   (*DevDataLengthFunction)();
#endif /* __cplusplus */
typedef long   DevType;

#define MAX_NUMBER_OF_XDR_TYPES		150
#define NUMBER_OF_GENERAL_XDR_TYPES	100

typedef struct _DevDataListEntry {
				long                   type;
                                DevDataFunction        xdr;
				long                   size;
				DevDataLengthFunction  xdr_length;
} DevDataListEntry;

/*
 * Function definitions
 */

#ifdef __cplusplus
extern "C" {
#endif
extern long _DLLFunc xdr_load_type
		  	PT_( (long type, DevDataFunction xdr,
			      long size, DevDataLengthFunction xdr_length,
			      DevLong *error) );
extern long _DLLFunc xdr_get_type
		     	PT_( (long type, DevDataListEntry *xdr_type,
			      DevLong *error) );
extern long _DLLFunc xdr_load_kernel
		     	PT_( (DevLong *error) );
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _DevXdrKernel_h */

