static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/ram_xdr.c,v 5.20 2001/01/08 12:17:35 goetz Rel $";

/*+*******************************************************************

 File:          ram_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for Radiation Monitor data types.

 Author(s):	Jens Meyer

 Original:	July 1992

$Revision: 5.20 $
$Date: 2001/01/08 12:17:35 $

$Author: goetz $

$Log: ram_xdr.c,v $
Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:42  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:03  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:39  15:16:39  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:38  13:58:38  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:43  10:08:43  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:32  16:48:32  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:48  goetz
Check

 * Revision 4.28  96/10/21  16:22:24  16:22:24  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:17  16:40:17  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:01:02  10:01:02  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:06  16:23:06  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:41  15:01:41  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:19  13:10:19  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:27  11:07:27  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:37  18:37:37  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:38  13:31:38  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:23  17:40:23  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:33  10:33:33  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:15  16:05:15  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:55  10:27:55  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:45  09:56:45  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:02  17:19:02  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:02  14:27:02  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:23  13:19:23  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:54  15:24:54  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:16  17:04:16  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:33  16:59:33  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:28  16:34:28  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:43  15:07:43  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:43  18:15:43  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:51  08:55:51  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:53  18:50:53  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:20  18:22:20  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:46  10:50:46  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:31  18:17:31  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:24  14:36:24  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:08  10:52:08  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:01  10:29:01  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:24  16:34:24  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:58  09:38:58  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.2  93/12/01  17:30:56  17:30:56  meyer (Jens Meyer)
 * *** empty log message ***
 * 
 * Revision 1.1  93/12/01  15:21:53  15:21:53  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/


#include <dev_xdr.h>
#include <ram_xdr.h>


/*
 *  xdr_routines for NE Technologies Gamma- and Neutron Monitor types
 */

bool_t
xdr_DevNeg14StatusRec(xdrs, objp)
	XDR *xdrs;
	DevNeg14StatusRec *objp;
{
	if (!xdr_int(xdrs, &objp->unit_type)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->unitrange)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->samplermode)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->last_update)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->monitorerror)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->msgalarm)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->unitstatus)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->unitfaultcode)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->checksum, UNIT_MSG_SIZE, 
			sizeof(char), (xdrproc_t)xdr_char)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->aritherrorcode, UNIT_MSG_SIZE, 
			sizeof(char), (xdrproc_t)xdr_char)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->alarmstatus)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->doserate)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->lowalarmth)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->highalarmth)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->alertalarmth)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->primingdoserate)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->AlarmResponseOpts, UNIT_MSG_SIZE, 
			sizeof(char), (xdrproc_t)xdr_char)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevNeg14StatusRec(objp)
	DevNeg14StatusRec *objp;
{
	long 	length = 0;

        length = length + xdr_length_DevLong ((long *)&objp->unit_type);
        length = length + xdr_length_DevFloat (&objp->unitrange);
        length = length + xdr_length_DevLong (&objp->samplermode);
	length = length + xdr_length_DevLong ((long *)&objp->last_update);
        length = length + xdr_length_DevLong (&objp->monitorerror);
        length = length + xdr_length_DevChar (&objp->msgalarm);
        length = length + xdr_length_DevLong (&objp->unitstatus);
        length = length + xdr_length_DevLong (&objp->unitfaultcode);
	length = length + 
	(UNIT_MSG_SIZE * xdr_length_DevChar (&objp->checksum[0]));
	length = length + 
	(UNIT_MSG_SIZE * xdr_length_DevChar (&objp->aritherrorcode[0]));
        length = length + xdr_length_DevLong (&objp->alarmstatus);
        length = length + xdr_length_DevFloat (&objp->doserate);
        length = length + xdr_length_DevDouble (&objp->lowalarmth);
        length = length + xdr_length_DevDouble (&objp->highalarmth);
        length = length + xdr_length_DevDouble (&objp->alertalarmth);
        length = length + xdr_length_DevDouble (&objp->primingdoserate);
	length = length + 
	(UNIT_MSG_SIZE * xdr_length_DevChar (&objp->AlarmResponseOpts[0]));

	return (length);
}


bool_t
xdr_DevRadiationDoseValue(xdrs, objp)
	XDR *xdrs;
	DevRadiationDoseValue *objp;
{
	if (!xdr_short(xdrs, &objp->state)) {
		return (FALSE);
	}
	if (!xdr_short(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->read)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevRadiationDoseValue(objp)
	DevRadiationDoseValue *objp;
{
	long 	length = 0;

        length = length + xdr_length_DevShort (&objp->state);
        length = length + xdr_length_DevShort (&objp->type);
        length = length + xdr_length_DevFloat (&objp->read);

	return (length);
}

