static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/dev_xdr.c,v 5.20 2001/01/08 12:17:35 goetz Rel $";

/*+*******************************************************************

 File:          dev_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for device server data passing.

 Author(s):	Jens Meyer

 Original:	January 1991

$Revision: 5.20 $
$Date: 2001/01/08 12:17:35 $

$Author: goetz $

$Log: dev_xdr.c,v $
Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:35  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:57  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:09  15:16:09  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:34  13:58:34  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:38  10:08:38  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:27  16:48:27  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:44  goetz
Check

 * Revision 4.28  96/10/21  16:22:16  16:22:16  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:00  16:40:00  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:58  10:00:58  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:02  16:23:02  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:34  15:01:34  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:14  13:10:14  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:19  11:07:19  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:34  18:37:34  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:34  13:31:34  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:19  17:40:19  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:23  10:33:23  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:11  16:05:11  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:46  10:27:46  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:33  09:56:33  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:51  17:18:51  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:41  14:26:41  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:13  13:19:13  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:45  15:24:45  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:06  17:04:06  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:23  16:59:23  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:19  16:34:19  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:33  15:07:33  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:35  18:15:35  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:34  08:55:34  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:45  18:50:45  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:01  18:22:01  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:38  10:50:38  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:22  18:17:22  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:16  14:36:16  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:00  10:52:00  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:53  10:28:53  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:15  16:34:15  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:48  09:38:48  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#include <dev_xdr.h>

/*
 *  Simple definitions of the xdr length of the
 *  basic data types.
 */

#define STD_XDR_LENGTH	   4       /* Standart length of a XDR data block */


/* D_VOID_TYPE */

long
xdr_length_DevVoid(objp)
	DevVoid *objp;
{
	return (0);
}


/* D_BOOLEAN_TYPE */

long
xdr_length_DevBoolean(objp)
	DevBoolean *objp;
{
	return (STD_XDR_LENGTH);
}


/* D_CHAR_TYPE */

long
xdr_length_DevChar(objp)
	DevChar *objp;
{
	return (STD_XDR_LENGTH);
}


/* D_USHORT_TYPE */

long 
xdr_length_DevUShort(objp)
     	DevUShort *objp;
{
  	return (STD_XDR_LENGTH);
}


/* D_SHORT_TYPE */

long
xdr_length_DevShort(objp)
	DevShort *objp;
{
	return (STD_XDR_LENGTH);
}


/* D_ULONG_TYPE */

long 
xdr_length_DevULong(objp)
     	DevULong *objp;
{
  	return (STD_XDR_LENGTH);
}


/* D_LONG_TYPE */

long
xdr_length_DevLong(objp)
	DevLong *objp;
{
	return (STD_XDR_LENGTH);
}


/* D_FLOAT_TYPE */

long
xdr_length_DevFloat(objp)
	DevFloat *objp;
{
	return (STD_XDR_LENGTH);
}


/* D_DOUBLE_TYPE */

long
xdr_length_DevDouble(objp)
	DevDouble *objp;
{
	return (2*STD_XDR_LENGTH);
}


/* D_STRING_TYPE */

bool_t
xdr_DevString(xdrs, objp)
	XDR *xdrs;
	DevString *objp;
{
	if (!xdr_string(xdrs, objp, MAXU_INT)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevString (objp)
	DevString *objp;
{
	long  length = 0;
	short add_bytes;

	/* number of bytes coded as unsigned int */
	length = STD_XDR_LENGTH;

	/* length of the string in bytes */
	length = length + strlen (*objp);

	/* only packets of four bytes can be send by XDR
	 * Calculate the next multiple of four. */

	if ( (add_bytes = (STD_XDR_LENGTH - 
			  (length - (STD_XDR_LENGTH * 
			  (int)(length / STD_XDR_LENGTH))))) == STD_XDR_LENGTH)
	   {
	   add_bytes = 0;
	   }

	length = length + add_bytes;

	return (length);
}


/* D_INT_FLOAT_TYPE */

bool_t
xdr_DevIntFloat(xdrs, objp)
	XDR *xdrs;
	DevIntFloat *objp;
{
	if (!xdr_long(xdrs, &objp->state)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->value)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevIntFloat(objp)
	DevIntFloat *objp;
{
	long  length = 0;

	length = length + xdr_length_DevLong  (&objp->state);
	length = length + xdr_length_DevFloat (&objp->value);

	return (length);
}



/* D_FLOAT_READPOINT */

bool_t
xdr_DevFloatReadPoint(xdrs, objp)
	XDR *xdrs;
	DevFloatReadPoint *objp;
{
	if (!xdr_float(xdrs, &objp->set)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->read)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevFloatReadPoint(objp)
	DevFloatReadPoint *objp;
{
	long  length = 0;

	length = length + xdr_length_DevFloat (&objp->set);
	length = length + xdr_length_DevFloat (&objp->read);

	return (length);
}


/* D_STATE_FLOAT_READPOINT */

bool_t
xdr_DevStateFloatReadPoint(xdrs, objp)
	XDR *xdrs;
	DevStateFloatReadPoint *objp;
{
	if (!xdr_short(xdrs, &objp->state)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->set)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->read)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevStateFloatReadPoint(objp)
	DevStateFloatReadPoint *objp;
{
	long  length = 0;

	length = length + xdr_length_DevShort (&objp->state);
	length = length + xdr_length_DevFloat (&objp->set);
	length = length + xdr_length_DevFloat (&objp->read);

	return (length);
}



/* D_LONG_READPOINT */

bool_t
xdr_DevLongReadPoint(xdrs, objp)
	XDR *xdrs;
	DevLongReadPoint *objp;
{
	if (!xdr_long(xdrs, &objp->set)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->read)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevLongReadPoint(objp)
	DevLongReadPoint *objp;
{
	long  length = 0;

	length = length + xdr_length_DevLong (&objp->set);
	length = length + xdr_length_DevLong (&objp->read);

	return (length);
}



/* D_DOUBLE_READPOINT */

bool_t
xdr_DevDoubleReadPoint(xdrs, objp)
	XDR *xdrs;
	DevDoubleReadPoint *objp;
{
	if (!xdr_double(xdrs, &objp->set)) {
		return (FALSE);
	}
	if (!xdr_double(xdrs, &objp->read)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevDoubleReadPoint(objp)
	DevDoubleReadPoint *objp;
{
	long  length = 0;

	length = length + xdr_length_DevDouble (&objp->set);
	length = length + xdr_length_DevDouble (&objp->read);

	return (length);
}



/*
 *  xdr_routines for variable length arrays 
 */

/* D_VAR_CHARARR */

bool_t
xdr_DevVarCharArray(xdrs, objp)
	XDR *xdrs;
	DevVarCharArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(char), (xdrproc_t)xdr_char)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarCharArray (objp)
	DevVarCharArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevBoolean(&objp->sequence[0]) );

	return (length);
}



/* D_VAR_STRINGARR */

bool_t
xdr_DevVarStringArray(xdrs, objp)
	XDR *xdrs;
	DevVarStringArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(DevString), (xdrproc_t)xdr_DevString)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarStringArray (objp)
	DevVarStringArray *objp;
{
	long 	type_length;
	long 	length = 0;
	short	i;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now find the lengthes of all strings in the array
	 *  and add the up.
	 */

	for (i=0; (u_long)i<objp->length; i++ )
	   {
	   if ( (type_length = xdr_length_DevString (&objp->sequence[i])) 
		 == -1 )
		return (-1);

	   length = length + type_length;
	   }

	return (length);
}



/* D_VAR_USHORTARR */

bool_t 
xdr_DevVarUShortArray (xdrs, objp)
     	XDR               *xdrs;
     	DevVarUShortArray *objp;
{
  	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(u_short), (xdrproc_t)xdr_u_short)) {
    		return (FALSE);
	}
  	return (TRUE);
}

long 
xdr_length_DevVarUShortArray (objp)
     	DevVarUShortArray *objp;
{
  	long length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

  	length = length + xdr_length_DevLong ((long *)&objp->length);
	
	/*
	 *  now calculate the length of the array
	 */

  	length = length + 
		 ( objp->length * xdr_length_DevUShort(&objp->sequence[0]) );

  	return (length);
}



/* D_VAR_SHORTARR */

bool_t
xdr_DevVarShortArray(xdrs, objp)
	XDR *xdrs;
	DevVarShortArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(short), (xdrproc_t)xdr_short)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarShortArray (objp)
	DevVarShortArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevShort(&objp->sequence[0]) );

	return (length);
}


/* D_VAR_ULONGARR */

bool_t
xdr_DevVarULongArray(xdrs, objp)
	XDR *xdrs;
	DevVarULongArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(unsigned long), (xdrproc_t)xdr_long)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarULongArray (objp)
	DevVarULongArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevLong((long *)&objp->sequence[0]) );

	return (length);
}


/* D_VAR_LONGARR */

bool_t
xdr_DevVarLongArray(xdrs, objp)
	XDR *xdrs;
	DevVarLongArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(long), (xdrproc_t)xdr_long)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarLongArray (objp)
	DevVarLongArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevLong(&objp->sequence[0]) );

	return (length);
}



/* D_VAR_FLOATARR */

bool_t
xdr_DevVarFloatArray(xdrs, objp)
	XDR *xdrs;
	DevVarFloatArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(float), (xdrproc_t)xdr_float)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarFloatArray (objp)
	DevVarFloatArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevFloat(&objp->sequence[0]) );

	return (length);
}


/* D_VAR_DOUBLEARR */

bool_t
xdr_DevVarDoubleArray(xdrs, objp)
	XDR *xdrs;
	DevVarDoubleArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(double), (xdrproc_t)xdr_double)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarDoubleArray (objp)
	DevVarDoubleArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + 
		 ( objp->length * xdr_length_DevDouble(&objp->sequence[0]) );

	return (length);
}




/* D_VAR_FRPARR */

bool_t
xdr_DevVarFloatReadPointArray(xdrs, objp)
	XDR *xdrs;
	DevVarFloatReadPointArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(DevFloatReadPoint), 
	    (xdrproc_t)xdr_DevFloatReadPoint)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarFloatReadPointArray (objp)
	DevVarFloatReadPointArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + (objp->length * 
		 xdr_length_DevFloatReadPoint(&objp->sequence[0]) );

	return (length);
}



/* D_VAR_SFRPARR */

bool_t
xdr_DevVarStateFloatReadPointArray(xdrs, objp)
	XDR *xdrs;
	DevVarStateFloatReadPointArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(DevStateFloatReadPoint), 
	    (xdrproc_t)xdr_DevStateFloatReadPoint)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarStateFloatReadPointArray (objp)
	DevVarStateFloatReadPointArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + (objp->length * 
		 xdr_length_DevStateFloatReadPoint(&objp->sequence[0]) );

	return (length);
}



/* D_VAR_LRPARR */

bool_t
xdr_DevVarLongReadPointArray(xdrs, objp)
	XDR *xdrs;
	DevVarLongReadPointArray *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence, 
	    (u_int *)&objp->length, MAXU_INT, sizeof(DevLongReadPoint), 
	    (xdrproc_t)xdr_DevLongReadPoint)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevVarLongReadPointArray (objp)
	DevVarLongReadPointArray *objp;
{
	long 	length = 0;

	/*
	 *  four bytes for the number of array elements
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the array
	 */

	length = length + (objp->length * 
		 xdr_length_DevLongReadPoint(&objp->sequence[0]) );

	return (length);
}





/*
 *  Opaque data type to transfer blocks of data
 */

/* D_OPAQUE_TYPE */

bool_t
xdr_DevOpaque(xdrs, objp)
	XDR *xdrs;
	DevOpaque *objp;
{
        if (!xdr_bytes(xdrs, (char **)&objp->sequence, 
		      (u_int *)&objp->length, MAXU_INT)) {
			return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevOpaque (objp)
	DevOpaque *objp;
{
	long 	length = 0;
	short   add_bytes;

	/*
	 *  four bytes for the number of bytes
	 */

	length = length + xdr_length_DevLong ((long *)&objp->length);

	/*
	 *  now calculate the length of the byte array
	 */

	length = length + objp->length;

	/* only packets of four bytes can be send by XDR
	 * Calculate the next multiple of four. */


	if ( (add_bytes = (STD_XDR_LENGTH - 
			  (length - (STD_XDR_LENGTH * 
			  (int)(length / STD_XDR_LENGTH))))) 
			  == STD_XDR_LENGTH)
	   {
	   add_bytes = 0;
	   }
	length = length + add_bytes;

	return (length);
}

