static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/bpm_xdr.c,v 5.20 2001/01/08 12:17:35 goetz Rel $";

/*+*******************************************************************

 File:          bpm_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for beam position monitor types.

 Author(s):	Jens Meyer

 Original:	January 1991

$Revision: 5.20 $
$Date: 2001/01/08 12:17:35 $

$Author: goetz $

$Log: bpm_xdr.c,v $
Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:36  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:57  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:04  15:16:04  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:34  13:58:34  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:39  10:08:39  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:28  16:48:28  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:45  goetz
Check

 * Revision 4.28  96/10/21  16:22:16  16:22:16  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:39:54  16:39:54  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:58  10:00:58  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:02  16:23:02  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:35  15:01:35  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:14  13:10:14  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:20  11:07:20  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:34  18:37:34  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:34  13:31:34  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:19  17:40:19  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:24  10:33:24  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:11  16:05:11  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:47  10:27:47  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:34  09:56:34  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:52  17:18:52  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:44  14:26:44  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:14  13:19:14  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:46  15:24:46  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:07  17:04:07  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:24  16:59:24  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:20  16:34:20  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:34  15:07:34  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:36  18:15:36  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:37  08:55:37  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:45  18:50:45  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:03  18:22:03  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:39  10:50:39  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:22  18:17:22  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:17  14:36:17  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:00  10:52:00  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:54  10:28:54  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:16  16:34:16  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:49  09:38:49  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  10:54:55  10:54:55  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/


#include <dev_xdr.h>
#include <bpm_xdr.h>



/*
 *  xdr for beam position monitor types
 */

bool_t
xdr_DevBpmElec(xdrs, objp)
	XDR *xdrs;
	DevBpmElec objp;
{
	if (!xdr_vector(xdrs, (char *)objp, 4, sizeof(float), (xdrproc_t)xdr_float)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmElec (objp)
        DevBpmElec objp;
{
        long    length = 0;

        length = length + (4 * xdr_length_DevFloat (&objp[0]));

        return (length);
}



bool_t
xdr_DevBpmMeasHead(xdrs, objp)
	XDR *xdrs;
	DevBpmMeasHead *objp;
{
	if (!xdr_u_short(xdrs, &objp->mn)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->gms)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->momint.sequence, (u_int *)&objp->momint.length, MAXU_INT, sizeof(DevBpmElec), (xdrproc_t)xdr_DevBpmElec)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmMeasHead (objp)
        DevBpmMeasHead *objp;
{
        long    length = 0;

        length = length + xdr_length_DevShort ((short *)&objp->mn);
        length = length + xdr_length_DevShort ((short *)&objp->gms);

        /*
         *  four bytes for the number of array elements
         */
        length = length + xdr_length_DevLong ((long *)&objp->momint.length);
        /*
         *  now calculate the length of the array
         */
        length = length + (objp->momint.length *
                 xdr_length_DevBpmElec( objp->momint.sequence[0]) );

        return (length);
}



bool_t
xdr_DevBpmPos(xdrs, objp)
	XDR *xdrs;
	DevBpmPos *objp;
{
	if (!xdr_u_short(xdrs, &objp->mms)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->xcoord)) {
		return (FALSE);
	}
	if (!xdr_float(xdrs, &objp->zcoord)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmPos (objp)
        DevBpmPos *objp;
{
        long    length = 0;

        length = length + xdr_length_DevShort ((short *)&objp->mms);
        length = length + xdr_length_DevFloat (&objp->xcoord);
        length = length + xdr_length_DevFloat (&objp->zcoord);

        return (length);
}



bool_t
xdr_DevBpmPosMeasure(xdrs, objp)
	XDR *xdrs;
	DevBpmPosMeasure *objp;
{
	if (!xdr_DevBpmMeasHead(xdrs, &objp->meashead)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->posdata.sequence, (u_int *)&objp->posdata.length, MAXU_INT, sizeof(DevBpmPos), (xdrproc_t)xdr_DevBpmPos)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmPosMeasure (objp)
        DevBpmPosMeasure *objp;
{
        long    length = 0;

        length = length + xdr_length_DevBpmMeasHead (&objp->meashead);

        /*
         *  four bytes for the number of array elements
         */
        length = length + xdr_length_DevLong ((long *)&objp->posdata.length);
        /*
         *  now calculate the length of the array
         */
        length = length + (objp->posdata.length *
                 xdr_length_DevBpmPos(&objp->posdata.sequence[0]) );

        return (length);
}



bool_t
xdr_DevBpmElecMeasure(xdrs, objp)
	XDR *xdrs;
	DevBpmElecMeasure *objp;
{
	if (!xdr_DevBpmMeasHead(xdrs, &objp->meashead)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->elecdata.sequence, (u_int *)&objp->elecdata.length, MAXU_INT, sizeof(DevBpmElec), (xdrproc_t)xdr_DevBpmElec)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmElecMeasure (objp)
        DevBpmElecMeasure *objp;
{
        long    length = 0;

        length = length + xdr_length_DevBpmMeasHead (&objp->meashead);

        /*
         *  four bytes for the number of array elements
         */
        length = length + xdr_length_DevLong ((long *)&objp->elecdata.length);
        /*
         *  now calculate the length of the array
         */
        length = length + (objp->elecdata.length *
                 xdr_length_DevBpmElec( objp->elecdata.sequence[0]) );

        return (length);
}



bool_t
xdr_DevBpmMeasParm(xdrs, objp)
	XDR *xdrs;
	DevBpmMeasParm *objp;
{
	if (!xdr_long(xdrs, &objp->expbeamint)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->timewind)) {
		return (FALSE);
	}
	if (!xdr_vector(xdrs, (char *)objp->delaytim, 6, 
			sizeof(long), (xdrproc_t)xdr_long)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmMeasParm (objp)
        DevBpmMeasParm *objp;
{
        long    length = 0;

        length = length + xdr_length_DevLong (&objp->expbeamint);
        length = length + xdr_length_DevLong (&objp->timewind);
        length = length + (6 * xdr_length_DevLong (&objp->delaytim[0]));

        return (length);
}




bool_t
xdr_DevBpmInjectHead(xdrs, objp)
	XDR *xdrs;
	DevBpmInjectHead *objp;
{
	if (!xdr_u_short(xdrs, &objp->min)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->gis)) {
		return (FALSE);
	}
	if (!xdr_DevBpmMeasParm(xdrs, &objp->bpm_measpar)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmInjectHead (objp)
        DevBpmInjectHead *objp;
{
        long    length = 0;

        length = length + xdr_length_DevShort ((short*)&objp->min);
        length = length + xdr_length_DevLong ((long *)&objp->gis);
        length = length + xdr_length_DevBpmMeasParm (&objp->bpm_measpar);

        return (length);
}



bool_t
xdr_DevBpmPosField(xdrs, objp)
	XDR *xdrs;
	DevBpmPosField *objp;
{
	if (!xdr_DevBpmInjectHead(xdrs, &objp->injhead)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->posmeas.sequence, 
			     (u_int *)&objp->posmeas.length, 
			     MAXU_INT, sizeof(DevBpmPosMeasure), 
			     (xdrproc_t)xdr_DevBpmPosMeasure)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmPosField (objp)
        DevBpmPosField *objp;
{
        long    length = 0;

        length = length + xdr_length_DevBpmInjectHead (&objp->injhead);

        /*
         *  four bytes for the number of array elements
         */
        length = length + xdr_length_DevLong ((long *)&objp->posmeas.length);
        /*
         *  now calculate the length of the array
         */
        length = length + (objp->posmeas.length *
                 xdr_length_DevBpmPosMeasure(&objp->posmeas.sequence[0]) );

        return (length);
}




bool_t
xdr_DevBpmElecField(xdrs, objp)
	XDR *xdrs;
	DevBpmElecField *objp;
{
	if (!xdr_DevBpmInjectHead(xdrs, &objp->injhead)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (caddr_t *)&objp->elecmeas.sequence, 
			     (u_int *)&objp->elecmeas.length, 
			     MAXU_INT, sizeof(DevBpmElecMeasure), 
			     (xdrproc_t)xdr_DevBpmElecMeasure)) {
		return (FALSE);
	}
	return (TRUE);
}

long
xdr_length_DevBpmElecField (objp)
        DevBpmElecField *objp;
{
        long    length = 0;

        length = length + xdr_length_DevBpmInjectHead (&objp->injhead);

        /*
         *  four bytes for the number of array elements
         */
	length = length + xdr_length_DevLong ((long *)&objp->elecmeas.length);
        /*
         *  now calculate the length of the array
         */
        length = length + (objp->elecmeas.length *
                 xdr_length_DevBpmElecMeasure(&objp->elecmeas.sequence[0]) );

        return (length);
}

