
static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/api_xdr_vers3.c,v 5.20 2001/01/08 12:17:35 goetz Rel $";
/*+*******************************************************************

 File:          api_xdr_vers3.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for API-library functions for the
		old version3. This file is needed for compatibility
		reasons.

 Author(s): 	Jens Meyer

 Original:      November 1994


$Revision: 5.20 $
$Date: 2001/01/08 12:17:35 $

$Author: goetz $

$Log: api_xdr_vers3.c,v $
Revision 5.20  2001/01/08 12:17:35  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:45  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:34  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:23:56  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:02  15:16:02  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:33  13:58:33  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:38  10:08:38  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:26  16:48:26  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:43  goetz
Check

 * Revision 4.28  96/10/21  16:22:14  16:22:14  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:39:45  16:39:45  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:56  10:00:56  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:01  16:23:01  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:33  15:01:33  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:13  13:10:13  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:17  11:07:17  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:33  18:37:33  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:33  13:31:33  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:18  17:40:18  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:22  10:33:22  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:10  16:05:10  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:45  10:27:45  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:31  09:56:31  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:49  17:18:49  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:13  14:27:13  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:11  13:19:11  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:44  15:24:44  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:05  17:04:05  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 1.1  94/11/28  17:00:58  17:00:58  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#include <DevXdrKernel.h>
#include <API_xdr_vers3.h>

/*
 *  xdr_routines for data structures used in the dev_putget(),
 *  dev_put() and dev_putget_raw() calls.
 */


bool_t
xdr__server_data_3 (xdrs, objp)
	XDR *xdrs;
	_server_data_3 *objp;
{
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->cmd)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argin_type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argout_type)) {
		return (FALSE);
	}

	/*
	 * Get the XDR data type from the loaded type list
	 */

	if ( xdr_get_type(objp->argin_type, &data_type, &error) == DS_NOTOK)
	   {
		char msg[512];
        sprintf (msg, "xdr__server_data() : error = %d", error);
#ifdef _NT
		PRINTF(msg);
#else
        printf ("%s\n", msg);
#endif
	   return (FALSE);
	   }

	if (!xdr_pointer(xdrs, (char **)&objp->argin, 
			 data_type.size,
			 (xdrproc_t)data_type.xdr )) {
		return (FALSE);
  	}
 	return (TRUE);
}


bool_t
xdr__client_data_3 (xdrs, objp)
	XDR *xdrs;
	_client_data_3 *objp;
{
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->argout_type)) {
		return (FALSE);
	}

	/*
	 * Get the XDR data type from the loaded type list
	 */

	if ( xdr_get_type(objp->argout_type, &data_type, &error) == DS_NOTOK)
	   {
		char msg[512];
        sprintf (msg, "xdr__client_data() : error = %d", error);
#ifdef _NT
		PRINTF(msg);
#else
        printf ("'%s\n", msg);
#endif

	   objp->argout   = NULL;
	   data_type.size = 0;
	   data_type.xdr  = (DevDataFunction)xdr_void;
	   }

	if (!xdr_pointer(xdrs, (char **)&objp->argout,
			 data_type.size,
			 (xdrproc_t)data_type.xdr )) {
	  	return (FALSE);
	}
  	return (TRUE);
}



/*
 *  xdr function used by dev_putget_raw to decode return
 *  arguments of a device server in raw opaque format.
 */

bool_t
xdr__client_raw_data_3 (xdrs, objp)
	XDR *xdrs;
	_client_raw_data_3 *objp;
{
	DevOpaque 		*opaque;
	DevDataListEntry	data_type;
	long			error;	

	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->deser_argout_type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->xdr_length)) {
		return (FALSE);
	}
	/*  On the server side encode the data with the data
	 *  type specified for the command as return argument.
	 */
	if ( xdrs->x_op == XDR_ENCODE )
	   {
	   /*
	    * Get the XDR data type from the loaded type list
	    */

	   if ( xdr_get_type(objp->ser_argout_type, &data_type, &error) 
		== DS_NOTOK)
	      {
		   char msg[512];
		   sprintf (msg, "xdr__client_raw_data() : error = %d", error);
#ifdef _NT
		   PRINTF(msg);
#else
           printf ("%s\n", msg);
#endif
	      return (FALSE);
	      }

	   if (!xdr_pointer(xdrs, (char **)&objp->argout,
			    data_type.size,
			    (xdrproc_t)data_type.xdr )) {
	  	   return (FALSE);
	   }
	   }
	else
	   {
	   /*
	    *  On the client side decode the arguments as a
	    *  stream of bytes with the length calculated
	    * on the server side (xdr_length).
	    */

	   /*
	    * Get the XDR data type from the loaded type list
	    */

	   if ( xdr_get_type(objp->deser_argout_type, &data_type, &error) 
		== DS_NOTOK)
	      {
		   char msg[512];
           sprintf (msg, "xdr__client_raw_data() : error = %d", error);
#ifdef _NT
		   PRINTF(msg);
#else
           printf ("%s\n", msg);
#endif
	      return (FALSE);
	      }

	   opaque = (DevOpaque *)objp->argout;
	   opaque->length       = objp->xdr_length;

	   if (!xdr_pointer(xdrs, (char **)&objp->argout,
			    data_type.size,
		  	    (xdrproc_t)xdr_DevOpaqueRaw )) {
	  	   return (FALSE);
	      }
	   }
  	return (TRUE);
}




/*
 *  internal xdr_routines for device service  
 */

bool_t
xdr__dev_import_in_3 (xdrs, objp)
	XDR *xdrs;
	_dev_import_in_3 *objp;
{
        if (!xdr_string(xdrs, &objp->device_name, MAXU_INT)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr__dev_import_out_3 (xdrs, objp)
	XDR *xdrs;
	_dev_import_out_3 *objp;
{
        if (!xdr_opaque(xdrs, (caddr_t)objp->server_name, LONG_NAME_SIZE)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr__dev_free_in_3 (xdrs, objp)
	XDR *xdrs;
	_dev_free_in_3 *objp;
{
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	return (TRUE);
}


bool_t
xdr__dev_free_out_3 (xdrs, objp)
	XDR *xdrs;
	_dev_free_out_3 *objp;
{
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	return (TRUE);
}



/*
 *  xdr_routines for dev_cmd_query()  
 */

bool_t
xdr__dev_query_in_3 (xdrs, objp)
	XDR *xdrs;
	_dev_query_in_3 *objp;
{
	if (!xdr_long(xdrs, &objp->ds_id)) {
		return (FALSE);
	}
	return (TRUE);
}	



bool_t
xdr__dev_query_out_3(xdrs, objp)
	XDR *xdrs;
	_dev_query_out_3 *objp;
{
	if (!xdr_array(xdrs, (caddr_t *)&objp->sequence,
            (u_int *)&objp->length, MAXU_INT, sizeof(_dev_cmd_info),
	     (xdrproc_t)xdr__dev_cmd_info)) {
		return (FALSE);
	}
	if (!xdr_opaque(xdrs, (caddr_t)objp->class_name, 20)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->error)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->status)) {
		return (FALSE);
	}
	return (TRUE);
}	


bool_t
xdr__manager_data_3 (xdrs, objp)
        XDR *xdrs;
        _manager_data_3 *objp;
{
        if (!xdr__register_data(xdrs, &objp->msg_info)) {
                return (FALSE);
        }
        if (!xdr__register_data(xdrs, &objp->db_info)) {
                return (FALSE);
        }
        if (!xdr_long(xdrs, &objp->status)) {
                return (FALSE);
        }
        if (!xdr_long(xdrs, &objp->error)) {
                return (FALSE);
        }
        return (TRUE);
}

