static char RcsId[] =
"@(#)$Header: /segfs/dserver/system/xdr/src/RCS/DevXdrKernel.c,v 5.20 2001/01/08 12:17:35 goetz Rel $";

/*+*******************************************************************

 File:          DevXdrKernel.c

 Project:       Device Servers with sun-rpc

 Description:   Contains the the list of all loaded XDR data types
		and the functions to load or retrieve a data type.

 Author(s):  	Jens Meyer

 Original:	November 1993


 $Revision: 5.20 $
 $Date: 2001/01/08 12:17:35 $

 $Author: goetz $

 $Log: DevXdrKernel.c,v $
 Revision 5.20  2001/01/08 12:17:35  goetz
 added patch by B.Pedersen to support querying events

 Revision 5.19  2000/10/02 12:08:45  goetz
 removed stderr from api_xdr.c

 Revision 5.18  1999/07/08 14:10:46  goetz
 changed _LPfd_set type for Linux in macros.h

 Revision 5.17  1998/05/25 17:59:34  klotz
 fixed C++ prototypes in api_xdr.h

 Revision 5.16  1998/04/29 10:23:56  goetz
 macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:15:34  15:15:34  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:33  13:58:33  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:38  10:08:38  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:27  16:48:27  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
 Revision 4.31  1996/11/18 17:28:44  goetz
 Check

 * Revision 4.28  96/10/21  16:22:15  16:22:15  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:38:55  16:38:55  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:00:57  10:00:57  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:01  16:23:01  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:33  15:01:33  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:14  13:10:14  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:18  11:07:18  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:33  18:37:33  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:34  13:31:34  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:19  17:40:19  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:23  10:33:23  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:10  16:05:10  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:45  10:27:45  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:32  09:56:32  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:18:50  17:18:50  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:26:39  14:26:39  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:12  13:19:12  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:44  15:24:44  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:05  17:04:05  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:23  16:59:23  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:18  16:34:18  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:32  15:07:32  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:34  18:15:34  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:55:33  08:55:33  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:44  18:50:44  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:21:59  18:21:59  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:37  10:50:37  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:21  18:17:21  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:15  14:36:15  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:51:58  10:51:58  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:28:52  10:28:52  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:14  16:34:14  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.32  94/01/12  16:31:20  16:31:20  meyer (Jens Meyer)
 * Declared the XDR type array as a global. For E.Taurel.
 * 
 * Revision 3.31  93/12/02  09:38:35  09:38:35  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.10  93/12/01  18:05:52  18:05:52  meyer (Jens Meyer)
 * *** empty log message ***
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/

#include <DevXdrKernel.h>
#include <Admin.h>

/*
 * For the library version with all XDR data types include all *.h files.
 */

#ifdef _XDR_ALL
#include <bpm_xdr.h>
#include <bpss_xdr.h>
#include <ct_xdr.h>
#include <gpib_xdr.h>
#include <haz_xdr.h>
#include <maxe_xdr.h>
#include <pss_xdr.h>
#include <ram_xdr.h>
#include <rf_xdr.h>
#include <thc_xdr.h>
#include <union_xdr.h>
#include <vgc_xdr.h>
#include <vrif_xdr.h>
#include <ws_xdr.h>
#include <seism_xdr.h>
#include <atte_xdr.h>
#include <slit_xdr.h>
#include <icv101_xdr.h>
#include <mstat_xdr.h>
#include <m4_xdr.h>
#include <pin_xdr.h>
#include <grp_xdr.h>
#endif /* _XDR_ALL */

/*
 * Define the list which contains all loaded XDR data types.
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * This list is defined as global variable on special
 * request of E.Taurel.
 * To access the XDR data types with maximum speed from
 * the data collector libray.
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 */

DevDataListEntry DevData_List [MAX_NUMBER_OF_XDR_TYPES] 
			       = { 0, NULL, 0, NULL };

/*
 * Set the number of loaded, private XDR data types to zero.
 */

static long		number_of_private_xdr_types = 0;


#ifdef __STDC__
long xdr_load_type (long type, DevDataFunction xdr, long size,
			 DevDataLengthFunction xdr_length, long *error)
#else
/**/
long xdr_load_type (type, xdr, size, xdr_length, error)
/*+**********************************************************************
 Function   :   extern long xdr_load_type()

 Description:   Loads a new XDR data type into the global list 
		of available data types.
 		All loaded data types can be used for data transfer 
		between device servers and clients.
 		A general purpose data type is loaded directly into 
		the list field specified by his XDR data type number 
		to avoid later searches in the list.
 		Private data types are loaded into list fields
 		>= NUMBER_OF_GENERAL_XDR_TYPES with increasing numbers. 
		To retrieve a private data type, the list of available 
		private data types has to be searched.

 Arg(s) In  :   long type           - XDR data type number.
	    :   DevDataFunction xdr - Function pointer of the XDR function.
	    :   long size           - The size (in bytes) of the XDR data 
				      type (calculated by sizeof()). 
            :   DevDataLengthFunction xdr_length - function pointer
				      of the XDR length calculation function.
 Arg(s) Out :   long *error         - Will contain an appropriate error
                                      code if the corresponding call
                                      returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	long 			type;
	DevDataFunction 	xdr;
	long 			size;
	DevDataLengthFunction 	xdr_length;
	long			*error;
#endif /* __STDC__ */
{
	int	i;

	*error = 0;

#ifdef EBUG
        dev_printdebug (DBG_TRACE | DBG_API,
                        "\nxdr_load_type() : entering routine\n");
#endif /* EBUG */

	/*
	 * Check error conditions.
	 */

	if ( type       < 0     ||
	     xdr        == NULL ||
		  size       < 0 )
	   {
	   *error = DevErr_BadXdrDataTypeDefinition;
	   return (DS_NOTOK);
	   }

	if ( (NUMBER_OF_GENERAL_XDR_TYPES + number_of_private_xdr_types) 
	      == MAX_NUMBER_OF_XDR_TYPES )
	   {
	   *error = DevErr_XdrTypeListOverflow;
	   return (DS_NOTOK);
	   }

#ifdef EBUG
        dev_printdebug ( DBG_API,
                        "\nxdr_load_type() : req_type = %d", type);
#endif /* EBUG */

	/*
	 * General XDR data types have a type 
	 * number < NUMBER_OF_GENERAL_XDR_TYPES
	 * and are stored directly in the list with this
	 * type number. For fast retrieval without search.
	 */

	if ( type < NUMBER_OF_GENERAL_XDR_TYPES )
	   {
	   /*
	    * If a XDR data type was already loaded, do nothing.
	    */
	   if ( DevData_List[type].type == type )
	      {
	      return (DS_OK);
	      }

	   DevData_List[type].type 	= type;
	   DevData_List[type].xdr  	= xdr;
	   DevData_List[type].size 	= size;
	   DevData_List[type].xdr_length = xdr_length;

	   return (DS_OK);
	   } 

	/*
         * If a private XDR data type will be loaded,
	 * it has to be stored in the next free field of the
	 * list >= NUMBER_OF_GENERAL_XDR_TYPES.
	 */

	/*
	 * Check wether the same XDR data type is already 
	 * loaded.
	 */

	for ( i=0; i<number_of_private_xdr_types; i++ )
	   {
	   if ( DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + i].type == type )
	      {
	      return (DS_OK);
	      }
	   }
	
	/*
	 * The XDR data type is not yet loaded!
	 */

	DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		    number_of_private_xdr_types].type       = type;
	DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		    number_of_private_xdr_types].xdr        = xdr;
	DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		    number_of_private_xdr_types].size  	    = size;
	DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		    number_of_private_xdr_types].xdr_length = xdr_length;

	number_of_private_xdr_types++;

#ifdef EBUG
        dev_printdebug (DBG_TRACE | DBG_API,
                        "\nxdr_load_type() : leaving routine");
#endif /* EBUG */

	return (DS_OK);
}

/*
 * By default load the small kernel of general purpose data types.
 * Only with the compile option "XDR_ALL" load all former data
 * types into the kernel.
 */
#ifndef _XDR_ALL

#ifdef __STDC__
long xdr_load_kernel ( long *error )
#else
/**/
long xdr_load_kernel ( error )
/*+**********************************************************************
 Function   :   extern long xdr_load_kernel()

 Description:   Loads all XDR data types, which are defined in
		the kernel to the list of available datatypes. 

 Arg(s) In  :   none

 Arg(s) Out :   long *error       - Will contain an appropriate error
                                    code if the corresponding call
                                    returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	long			*error;
#endif /* __STDC__ */
{
	*error = 0;

	if ( LOAD_VOID_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_BOOLEAN_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_USHORT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_SHORT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_ULONG_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_LONG_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_FLOAT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_DOUBLE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_STRING_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_INT_FLOAT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_FLOAT_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_STATE_FLOAT_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_LONG_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_DOUBLE_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_CHARARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_STRINGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_USHORTARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_SHORTARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_ULONGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_LONGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_FLOATARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_DOUBLEARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_FRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_SFRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_LRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_OPAQUE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	return (DS_OK);
}


#else /* _XDR_ALL */


#ifdef __STDC__
long xdr_load_kernel ( long *error )
#else
/**/
long xdr_load_kernel ( error )
/*+**********************************************************************
 Function   :   extern long xdr_load_kernel()

 Description:   Loads all XDR data types, which are defined in
		the kernel to the list of available datatypes. 

 Arg(s) In  :   none

 Arg(s) Out :   long *error       - Will contain an appropriate error
                                    code if the corresponding call
                                    returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	long			*error;
#endif /* __STDC__ */
{
	*error = 0;

	if ( LOAD_VOID_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_BOOLEAN_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_USHORT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_SHORT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_ULONG_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_LONG_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_FLOAT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_DOUBLE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_STRING_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_INT_FLOAT_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_FLOAT_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_STATE_FLOAT_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_LONG_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_DOUBLE_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_CHARARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_STRINGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_USHORTARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_SHORTARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_ULONGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_LONGARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_FLOATARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_DOUBLEARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_FRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_SFRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_VAR_LRPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
        if ( LOAD_OPAQUE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);


	if ( LOAD_BPM_POSFIELD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_BPM_ELECFIELD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_WS_BEAMFITPARM(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VGC_STATUS(error) == DS_NOTOK ) 
		return (DS_NOTOK);
	if ( LOAD_VGC_GAUGE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VGC_CONTROLLER(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_UNION_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_NEG_STATUS(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_RAD_DOSE_VALUE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_THARR(error) == DS_NOTOK ) 
		return (DS_NOTOK);
	if ( LOAD_HAZ_STATUS(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VRIF_WDOG(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VRIF_STATUS(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VRIF_POWERSTATUS(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_GPIB_WRITE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_GPIB_MUL_WRITE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_STATE_INDIC(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_BPSS_STATE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_BPSS_READPOINT(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_GPIB_RES(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_GPIB_LOC(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_PSS_STATUS(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_RF_SIGCONFIG(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_BPSS_LINE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_CT_LIFETIME(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_MULMOVE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_SEISM_EVENT(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_SEISM_STAT(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_LIEN_STATE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_BLADE_STATE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_PSLIT_STATE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_ATTE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_MOTOR_LONG(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_MOTOR_FLOAT(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_PATTERNARR(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_ICV_MODE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_MSTATARR(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_LONGFLOATSET(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_LONGREAD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_POSREAD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_AXEREAD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_PARREAD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_ERRREAD(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_GRPFP_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_VAR_GRPFPARR(error) == DS_NOTOK )
		return (DS_NOTOK);
	if ( LOAD_PINSTATE_TYPE(error) == DS_NOTOK )
		return (DS_NOTOK);
	return (DS_OK);
}

#endif /* _XDR_ALL */


#ifdef __STDC__
long xdr_get_type (long type, DevDataListEntry *xdr_type, long *error)
#else
/**/
long xdr_get_type (type, xdr_type, error)
/*+**********************************************************************
 Function   :   extern long xdr_get_type()

 Description:   Gets a XDR data type from the global list of available 
		data types.
 		Via the pointers in the returned structure, the XDR 
		function and the XDR length calculation function 
		can be accessed.
 		A general purpose data type is read directly from 
		the list field specified by his XDR data type number 
		to avoid searching in the list.
 		Private data types are read from list fields
 		>= NUMBER_OF_GENERAL_XDR_TYPES. A private data type has to be
 		searched in the list of available private data types.


 Arg(s) In  :   long type         - XDR data type number.

 Arg(s) Out :   DevDataListEntry *xdr_type - A pointer to a structure 
				    describing the XDR data type.
				    
            :   long *error       - Will contain an appropriate error
                                    code if the corresponding call
                                    returns a non-zero value.

 Return(s)  :   DS_OK or DS_NOTOK
***********************************************************************-*/
	long 			type;
	DevDataListEntry 	*xdr_type;
	long			*error;
#endif /* __STDC__ */
{
	int	i;

	*error = 0;

#ifdef EBUG
        dev_printdebug (DBG_TRACE | DBG_API,
                        "\nxdr_get_type() : entering routine\n");
#endif /* EBUG */

	/*
	 * Check error conditions.
	 */

	if ( type < 0 )
	   {
	   *error = DevErr_BadXdrDataTypeDefinition;
	   return (DS_NOTOK);
	   }

	/*
	 * General XDR data types have a type 
	 * number < NUMBER_OF_GENERAL_XDR_TYPES
	 * and are stored directly in the list with this
	 * type number. For fast retrieval without search.
	 */

	if ( type < NUMBER_OF_GENERAL_XDR_TYPES )
	   {
	   if ( DevData_List[type].type != type )
	      {
	      *error = DevErr_XdrDataTypeNotLoaded;
	      return (DS_NOTOK);
	      }

#ifdef EBUG
           dev_printdebug ( DBG_API,
                        "\nxdr_get_type() : req_type = %d , list_type = %d",
			type, DevData_List[type].type);
#endif /* EBUG */

	   xdr_type->type       = DevData_List[type].type;
	   xdr_type->xdr        = DevData_List[type].xdr;
	   xdr_type->size       = DevData_List[type].size;
	   xdr_type->xdr_length = DevData_List[type].xdr_length;

#ifdef EBUG
           dev_printdebug (DBG_TRACE | DBG_API,
                        "\nxdr_get_type() : leaving routine");
#endif /* EBUG */
	   return (DS_OK);
	   }
	
	/*
	 * Search for a private XDR data type in the list.
	 */

	for ( i=0; i<number_of_private_xdr_types; i++ )
	   {
	   if ( DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + i].type == type )
	      {
#ifdef EBUG
              dev_printdebug ( DBG_API,
                        "\nxdr_get_type() : req_type = %d , list_number = %d",
			type, (NUMBER_OF_GENERAL_XDR_TYPES + i));
#endif /* EBUG */
	      xdr_type->type       = DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		                     i].type;
	      xdr_type->xdr        = DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		                     i].xdr;
	      xdr_type->size       = DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		                     i].size;
	      xdr_type->xdr_length = DevData_List[NUMBER_OF_GENERAL_XDR_TYPES + 
		                     i].xdr_length;

#ifdef EBUG
              dev_printdebug (DBG_TRACE | DBG_API,
                        "\nxdr_get_type() : leaving routine");
#endif /* EBUG */
	      return (DS_OK);
	      }
	   }
	
	*error = DevErr_XdrDataTypeNotLoaded;
	return (DS_NOTOK);
}
