/*static char RcsId[] =$Header: /segfs/dserver/system/xdr/include/RCS/m4_xdr.h,v 5.20 2001/01/08 12:17:37 goetz Rel $";*/ 

/*+*******************************************************************

 File:          m4_xdr.h

 Project:       Data types for m4 (four mirrors device)

 Description:  

 Author(s):  	C. Dominguez

 Original:	May 93

$Log: m4_xdr.h,v $
Revision 5.20  2001/01/08 12:17:37  goetz
added patch by B.Pedersen to support querying events

Revision 5.19  2000/10/02 12:08:48  goetz
removed stderr from api_xdr.c

Revision 5.18  1999/07/08 14:10:49  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 18:00:01  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:24  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:22:27  15:22:27  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:51  13:58:51  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:55  10:08:55  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:46  16:48:46  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:29:02  goetz
Check

 * Revision 4.28  96/10/21  16:22:48  16:22:48  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:45:52  16:45:52  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.26  96/07/19  10:01:13  10:01:13  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:18  16:23:18  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:54  15:01:54  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:32  13:10:32  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:39  11:07:39  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:48  18:37:48  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:48  13:31:48  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:34  17:40:34  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:56  10:33:56  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:26  16:05:26  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:28:25  10:28:25  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:57:29  09:57:29  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:31  17:19:31  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:32  14:27:32  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:51  13:19:51  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:25:19  15:25:19  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:44  17:04:44  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:56  16:59:56  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:53  16:34:53  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:08:07  15:08:07  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:16:06  18:16:06  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:19  08:56:19  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:51:16  18:51:16  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:45  18:22:45  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:51:09  10:51:09  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:52  18:17:52  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:46  14:36:46  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:31  10:52:31  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:20  10:29:20  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:49  16:34:49  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:39:29  09:39:29  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/11/16  17:58:40  17:58:40  meyer (Jens Meyer)
 * Initial revision
 * 

Copyright (c) 1990 by European Synchrotron Radiation Facility,
		      Grenoble, France

*******************************************************************-*/

#ifndef _m4_xdr_h
#define _m4_xdr_h


/* Structures for the four mirror device */

struct DevVarLongFloatSet
{
	long length;
	long *axis;
	long *value;
        float *valuef;
};
typedef struct DevVarLongFloatSet DevVarLongFloatSet;
bool_t 	_DLLFunc xdr_DevVarLongFloatSet
		 PT_((XDR *xdrs, DevVarLongFloatSet *objp));
#define D_VAR_LONGFLOATSET      59
#define LOAD_VAR_LONGFLOATSET(A) xdr_load_type ( D_VAR_LONGFLOATSET, \
                                                xdr_DevVarLongFloatSet, \
                                                sizeof(DevVarLongFloatSet), \
                                                NULL, \
                                                A )


struct DevVarLongRead
{
	long length;
        long *value;
	long *stat;
	long *err;
};
typedef struct DevVarLongRead 	DevVarLongRead; 
bool_t 	_DLLFunc xdr_DevVarLongRead
		 PT_((XDR *xdrs, DevVarLongRead *objp));
#define D_VAR_LONGREAD          60
#define LOAD_VAR_LONGREAD(A)    xdr_load_type ( D_VAR_LONGREAD, \
                                                xdr_DevVarLongRead, \
                                                sizeof(DevVarLongRead), \
                                                NULL, \
                                                A )


struct DevVarPosRead
{
	long length;
	float *pos;
	long *stat;
	long *err;
};
typedef struct DevVarPosRead 	DevVarPosRead; 
bool_t 	_DLLFunc xdr_DevVarPosRead PT_((XDR *xdrs, DevVarPosRead *objp));
#define D_VAR_POSREAD           61
#define LOAD_VAR_POSREAD(A)     xdr_load_type ( D_VAR_POSREAD, \
                                                xdr_DevVarPosRead, \
                                                sizeof(DevVarPosRead), \
                                                NULL, \
                                                A )


struct DevVarAxeRead
{
	long length;
	float *m_pos;
	float *s_pos;
	long *m_stat;
	long *s_stat;
	long *swit;
        long *clutch;
	long *err;
};
typedef struct DevVarAxeRead 	DevVarAxeRead; 
bool_t 	_DLLFunc xdr_DevVarAxeRead PT_((XDR *xdrs, DevVarAxeRead *objp));
#define D_VAR_AXEREAD           62
#define LOAD_VAR_AXEREAD(A)     xdr_load_type ( D_VAR_AXEREAD, \
                                                xdr_DevVarAxeRead, \
                                                sizeof(DevVarAxeRead), \
                                                NULL, \
                                                A )


struct DevVarParRead
{
	long length;
	float *veloc;
	float *acc;
	float *fstep;
	float *hslew;
        float *backlash;
	long *stepmode;
	long *unit;
	long *err;
};
typedef struct DevVarParRead 	DevVarParRead; 
bool_t 	_DLLFunc xdr_DevVarParRead PT_((XDR *xdrs, DevVarParRead *objp));
#define D_VAR_PARREAD           63
#define LOAD_VAR_PARREAD(A)     xdr_load_type ( D_VAR_PARREAD, \
                                                xdr_DevVarParRead, \
                                                sizeof(DevVarParRead), \
                                                NULL, \
                                                A )


struct DevVarErrRead
{
	long length;
	long *err;
};
typedef struct DevVarErrRead 	DevVarErrRead; 
bool_t 	_DLLFunc xdr_DevVarErrRead PT_((XDR *xdrs, DevVarErrRead *objp));
#define D_VAR_ERRREAD           64
#define LOAD_VAR_ERRREAD(A)     xdr_load_type ( D_VAR_ERRREAD, \
                                                xdr_DevVarErrRead, \
                                                sizeof(DevVarErrRead), \
                                                NULL, \
                                                A )

#endif /* _m4_xdr_h */

