static char RcsId[] = "@(#)$Header: dc_inits.c,v 3.3 96/02/27 16:49:09 taurel Exp $";

/* $Log:	dc_inits.c,v $
 * Revision 3.3  96/02/27  16:49:09  16:49:09  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.2  95/12/19  14:17:44  14:17:44  taurel (Emmanuel TAUREL)
 * Remove command parameter.
 * 
 * Revision 3.1  93/06/14  17:00:10  17:00:10  taurel (Emmanuel TAUREL)
 * New specific case for SUN system in the create_sem function.
 * 
 * Revision 3.0  93/05/19  09:53:02  09:53:02  taurel (Emmanuel TAUREL)
 * Adapted to SUN release of the dc (without RTDB).
 * 
 * Revision 3.0  93/05/17  17:33:21  17:33:21  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.1  93/02/03  11:27:01  11:27:01  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <errno.h>

#include <dcP.h>

/* Some global variables used to retrieve resources */

db_resource res1[] = {
	{"dev_number",D_LONG_TYPE},
	{"cellar_number",D_LONG_TYPE},
	{"data_size",D_LONG_TYPE},
		    };
int res1_size = sizeof(res1) / sizeof(db_resource);

/* The shared memory segment id and address */

int shmid_ptr,shmid_datbuf,shmid_alloc;
char *shmadr_datbuf,*shmadr_ptr,*shmadr_alloc;


/****************************************************************************
*                                                                           *
*		Code for dc_inits command                                   *
*                        --------                                           *
*                                                                           *
*    Command rule : To initialize the data collector system.	            *
*		    This initialisation can be done from scrach or from     *
* 		    a previously backuped database                          *
*                                                                           *
*    Synopsis : dc_inits						    *
*                                                                           *
****************************************************************************/

void main(argc,argv)
int argc;
char *argv[];
{
	int ds;
	long error;
	char *tmp;
	unsigned int diff;
	static long dev_num;
	static long dat_size;
	static long cell_num;
	int nb_tot;
	char hostna[32];
	char dev_name[40];
	int ptr_size,alloc_size;

/* Arguments number test */

	if(argc != 1) {
		printf("dc_inits usage : dc_inits\n");
		exit(-1);
		}

/* Import static database */

	if (db_import(&error)) {
		printf("dc_inits : Can't import static database\n");
		printf("dc_inits : Check your NETHOST environment variable\n");
		exit(-1);
				}

/* Build device name. It is a function of the host name */

	gethostname(hostna,sizeof(hostna));
	if ((tmp = strchr(hostna,'.')) != NULL) {
		diff = (u_int)(tmp - hostna);
		hostna[diff] = 0;
						}
	strcpy(dev_name,"CLASS/DC/");
	strcat(dev_name,hostna);

/* Retrieve data collector memories size */

	dev_num = dat_size = cell_num = 0;
	res1[0].resource_adr = &dev_num;
	res1[1].resource_adr = &cell_num;
	res1[2].resource_adr = &dat_size;
	if (db_getresource(dev_name,res1,res1_size,&error)) {
		printf("dc_inits : Can't retrieve resources\n");
		printf("dc_inits : Error code : %d\n",error);
		exit(-1);
								  }
	if (dev_num == 0 || dat_size == 0 || cell_num == 0) {
		printf("dc_inits : Resource dev_number, cellar_number or data_size not defined\n");
		printf("dc_inits : Sorry but I exit !\n");
		exit(-1);
					   }

/* Compute pointers area size and allocation table size */

	nb_tot = dev_num + cell_num;
	ptr_size = (int)((nb_tot * sizeof(dc_dev_param)) + (nb_tot * sizeof(int_level)));
	alloc_size = (int)(dat_size / 256);

/* Create memories and semaphores */

	from_scratch(ptr_size,alloc_size,dat_size,nb_tot);

}



/****************************************************************************
*                                                                           *
*		Code for from_scratch  function                             *
*                        ------------                                       *
*                                                                           *
*    Function rule : To create the database part of the data collector from *
*                    scratch.    					    *
*                                                                           *
*    Argin : - The pointer shared memory segment size			    *
*	     - The allocation table size				    *
*	     - The data buffer size					    *
*	     - The sum of device number and element in the cellar table     *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

from_scratch(ptr_size,alloc_size,dat_size,nb_tot)
int ptr_size;
int alloc_size;
int dat_size;
int nb_tot;
{

#ifdef DEBUG
	printf("From scratch");
#endif /* DEBUG */

/* Reserve buffers in shared memory */

	get_shm_buffer(ptr_size,alloc_size,dat_size,nb_tot);

/* Create the semaphore */

	create_sem();

}



/****************************************************************************
*                                                                           *
*		Code for get_shm_buffer  function                           *
*                        --------------                                     *
*                                                                           *
*    Function rule : To reserve and clear the three buffers in three        *
*		     different shared memory segments. Thses three buffers  *
*                    are : 	    					    *
*			- The data buffer				    *
*			- The pointers buffer				    *
*			- The allocation area				    *
*                                                                           *
*    Argin : - The pointers shared memory segment size			    *
*	     - The allocation table size				    *
*	     - The data buffer size					    *
*	     - The number of devices plus the number of elements in the     *
*	       cellar area.						    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

get_shm_buffer(ptr_size,alloc_size,dat_size,nb_tot)
int ptr_size;
int alloc_size;
int dat_size;
int nb_tot;
{
	int i;
	int *tmp_ptr;
	int tmp_size;
	dc_dev_param *array;

/* Reserve the data buffer in a shared memory segment */

	if ((shmid_datbuf = shmget((key_t)KEY_DATBUF,(size_t)dat_size,IPC_CREAT | 0666)) == -1) {
		printf("dc_inits : Can't get the data buffer\n");
		printf("dc_inits : Error code : %d\n",errno);
		exit(-1);
					}
#ifdef DEBUG
	printf("Data buffer shm id : %d\n",shmid_datbuf);
#endif /* DEBUG */

	if ((shmadr_datbuf = (char *)shmat(shmid_datbuf,(char *)0,0)) == (char *)-1) {
		printf("dc_inits : Can't attach to the data buffer shred memory segment\n");
		printf("dc_inits : Error code : %d\n",errno);
		exit(-1);
					}

/* Reserve the pointers buffer in shared memory */

	if ((shmid_ptr = shmget((key_t)KEY_PTR,(size_t)ptr_size,IPC_CREAT | 0666)) == -1) {
		printf("dc_inits : Can't get the pointers buffer\n");
		printf("dc_inits : Error code : %d\n",errno);
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		exit(-1);
					}
#ifdef DEBUG
	printf("Pointer buffer shm id : %d\n",shmid_ptr);
#endif /* DEBUG */
	
	if ((shmadr_ptr = (char *)shmat(shmid_ptr,(char *)0,0)) == (char *)-1) {
		printf("dc_inits : Can't attach to the pointers buffer shred memory segment\n");
		printf("dc_inits : Error code : %d\n",errno);
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmctl(shmid_ptr,IPC_RMID,0);
		exit(-1);
					}

/* Reserve the allocation table also in shared memory */

	if ((shmid_alloc = shmget((key_t)KEY_ALLOC,(size_t)alloc_size,IPC_CREAT | 0666)) == -1) {
		printf("dc_inits : Can't get the allocation table\n");
		printf("dc_inits : Error code : %d\n",errno);
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		exit(-1);
					}
#ifdef DEBUG
	printf("Allocation table shm id : %d\n",shmid_alloc);
#endif /* DEBUG */

	if ((shmadr_alloc = (char *)shmat(shmid_alloc,(char *)0,0)) == (char *)-1) {
		printf("dc_inits : Can't attach to the allocation area shred memory segment\n");
		printf("dc_inits : Error code : %d\n",errno);
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
					}

/* Clear the allocation area */

	tmp_size = alloc_size >> 2;
	tmp_ptr = (int *)shmadr_alloc;
	for (i = 0;i < tmp_size;i++) {
		*tmp_ptr = 0;
		tmp_ptr++;
				     }

/* Clear the pointers table and set all the next records value to 1 */

	for (i = 0;i < ptr_size;i++)
		shmadr_ptr[i] = 0;
	array = (dc_dev_param *)shmadr_ptr;
	for (i = 0;i < nb_tot;i++)
		array[i].next_rec = 1;

}



/****************************************************************************
*                                                                           *
*		Code for create_sem  function                               *
*                        ----------                                         *
*                                                                           *
*    Function rule : To create and initialise the semaphore used to protect *
*		     the allocation area.				    *
*									    *
*    Argin : No argin							    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
****************************************************************************/

create_sem()
{
	int semid;
	int semval;
	int semid1;

/* Get the semaphore to protect the allocation area */

	if ((semid = semget((key_t)SEM_KEY,1,IPC_CREAT | 0666)) == -1) {
		printf("dc_inits : Can't get the semaphore\n");
		perror("dc_inits ");
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmdt(shmadr_alloc);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
									}

/* Set the initial value of the semaphore to one. One means free and 0
   means occupied ! */

	semval = 1;
#ifdef sun
	if (semctl(semid,0,SETVAL,&semval) == -1) {
#else
	if (semctl(semid,0,SETVAL,semval) == -1) {
#endif /* sun */
		printf("dc_inits : Can't initialise the semaphore\n");
		perror("dc_inits ");
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmdt(shmadr_alloc);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
						}

/* Get the semaphores set to protect the pointers memory */

	if ((semid1 = semget((key_t)SEMPTR_KEY,2,IPC_CREAT | 0666)) == -1) {
		printf("dc_inits : Can't get the semaphore\n");
		perror("dc_inits ");
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmdt(shmadr_alloc);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
									}

/* Set the initial value of the semaphore to one. One means free and 0
   means occupied ! */

#ifdef sun
	if (semctl(semid1,0,SETVAL,&semval) == -1) {
#else
	if (semctl(semid1,0,SETVAL,semval) == -1) {
#endif /* sun */
		printf("dc_inits : Can't initialise the semaphore\n");
		perror("dc_inits ");
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmdt(shmadr_alloc);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
						}

#ifdef sun
	if (semctl(semid1,1,SETVAL,&semval) == -1) {
#else
	if (semctl(semid1,1,SETVAL,semval) == -1) {
#endif /* sun */
		printf("dc_inits : Can't initialise the semaphore\n");
		perror("dc_inits ");
		shmdt(shmadr_datbuf);
		shmctl(shmid_datbuf,IPC_RMID,0);
		shmdt(shmadr_ptr);
		shmctl(shmid_ptr,IPC_RMID,0);
		shmdt(shmadr_alloc);
		shmctl(shmid_alloc,IPC_RMID,0);
		exit(-1);
						}

}
