static char RcsId[] = "@(#)$Header: /segfs/dserver/system/dc/svc/RCS/dc_put.c,v 3.21 2000/12/03 07:19:13 goetz Rel goetz $";

/* $Log: dc_put.c,v $
 * Revision 3.21  2000/12/03 07:19:13  goetz
 * ported to Linux
 *
 * Revision 3.20  2000/03/13 15:28:29  taurel
 * Adapted to the new release of gettranscient (DSAIPI release 7.8 and above)
 *
 * Revision 3.19  99/07/05  14:24:20  14:24:20  taurel (E.Taurel)
 * Porte dto new release of gettranscienr_ut. I don't understand how it worked
 * before !!
 * 
 * Revision 3.18  99/06/02  16:06:24  16:06:24  taurel (E.Taurel)
 * Fix bug when transferring time for dc_devget_history
 * 
 * Revision 3.17  99/02/08  15:23:38  15:23:38  taurel (E.Taurel)
 * No change done
 * 
 * Revision 3.16  96/12/06  11:30:12  11:30:12  taurel (E.Taurel)
 * Adapted to new directory structure and incl. files
 * 
 * Revision 3.15  96/11/04  16:50:04  16:50:04  taurel (E.Taurel)
 * Change in the db_register function to fulfill
 * db software release 5 (process name).
 * 
 * Revision 3.14  96/06/14  11:25:42  11:25:42  taurel (E.Taurel)
 * In the still updated test, now manage the case where the update
 * period is 0. This means that no tests are needed.
 * 
 * Revision 3.13  96/02/28  09:13:10  09:13:10  taurel (Emmanuel TAUREL)
 * Ported to Solaris.
 * 
 * Revision 3.12  96/01/05  16:07:04  16:07:04  taurel (Emmanuel TAUREL)
 * Checked out for the two XDR files which have been
 * modified for the library port to Solaris (compatibility mode only).
 * 
 * Revision 3.11  95/12/15  17:26:30  17:26:30  taurel (Emmanuel TAUREL)
 * Check out for debug purpose. No change.
 * 
 * Revision 3.10  95/10/10  14:08:15  14:08:15  taurel (Emmanuel TAUREL)
 * Return date in the dc_devget_history function even if the command failed.
 * 
 * Revision 3.2  93/09/30  09:18:11  09:18:11  taurel (Emmanuel TAUREL)
 * Change for the DS_WARNING stuff and fix the timeout bug in the add_data
 * function.
 * 
 * Revision 3.1  93/08/13  08:43:26  08:43:26  taurel (Emmanuel Taurel)
 * This file has been check out just for test purpose. Nothing has been changed.
 * 
 * Revision 3.0  93/05/17  17:43:29  17:43:29  taurel (Emmanuel Taurel)
 * Modified to port the dc system to SUN (without RTDB).
 * 
 * Revision 1.2  93/02/04  10:24:11  10:24:11  taurel (Emmanuel Taurel)
 * Major chage to cope with the distributed release of the data collector
 * system.
 * 
 * Revision 1.1  92/10/29  13:06:28  13:06:28  taurel (Emmanuel Taurel)
 * Initial revision
 *  */

#include <API.h>
#include <DevErrors.h>
#include <DserverTeams.h>

#include <dc_xdr.h>
#include <dcP.h>

#include <stdlib.h>
#include <time.h>

/* Variables defined in dc_svc.c */

extern hash_info mem;

extern char *addr_ptr,*addr_alloc,*addr_data;
extern int semid;
extern int req_call;


/****************************************************************************
*                                                                           *
*		Server code for dc_dataput function                         *
*                               ----------                                  *
*                                                                           *
*    Function rule : To store in the data collector some command result.    *
*		     The command result are stored in a shared memory area  *
*		     often called "data buffer"				    *
*                                                                           *
*    Argin : A pointer to a structure of the "arr1" type                    *
*            The definition of the arr1 type is :                           *
*            struct {                                                       *
*              u_int arr1_len;     The number of strings                    *
*              char **arr1_val;    A pointer to the array of strings        *
*                  }                                                        *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns a pointer to a structure of the "db_res" type.   *
*    The definition of this structure is :                                  *
*    struct {                                                               *
*      arr1 rev_val;   A structure of the arr1 type (see above) with the    *
*                     resources values information transferred as strings   *
*      int db_err;    The database error code                               *
*                     0 if no error                                         *
*          }                                                                *
*                                                                           *
*****************************************************************************/

dc_xdr_error *dc_dataput_1(rece)
dev_datarr *rece;
{
	int dev_number;
	int i,j,k;
	static dc_xdr_error ret_err;
	int err_code;
	int nb_cmd;
	int cmd_size;
	int cmd_err;

/* Miscellaneous initializations */

	dev_number = rece->dev_datarr_len;
	ret_err.error_code = 0;
	ret_err.dev_error = 0;

#ifdef DEBUG
	printf("\nDc_dataput call for %d devices\n",dev_number);
	for (i = 0; i < dev_number;i++) {
		printf("Device name : %s\n",rece->dev_datarr_val[i].xdev_name);
		nb_cmd = rece->dev_datarr_val[i].xcmd_dat.xcmd_dat_len;
		printf("%d commands for this device\n",nb_cmd);
		for (j = 0;j < nb_cmd;j++) {
		printf("Cmd : %d\n",rece->dev_datarr_val[i].xcmd_dat.xcmd_dat_val[j].xcmd);
		cmd_err = rece->dev_datarr_val[i].xcmd_dat.xcmd_dat_val[j].xcmd_error;
		printf("Error code : %d\n",cmd_err);
		if (cmd_err == 0) {
		cmd_size = rece->dev_datarr_val[i].xcmd_dat.xcmd_dat_val[j].xsequence.xsequence_len;
		printf("Cmd size : %d\n",cmd_size);
				}
					    }
					}
#endif /* DEBUG */

/* Init. the req_call parameter for this call */

	req_call = dev_number;

/* Call the dev_add_data function for every device */

	for (i = 0;i < dev_number;i++) {
		if (dev_add_data(&(rece->dev_datarr_val[i]),&err_code)) {
			ret_err.error_code = err_code;
			ret_err.dev_error = i + 1;
			return(&ret_err);
				}
					}


/* Leave server */

#ifdef DEBUG
	printf("end dc_dataput\n");
#endif /* DEBUG */
	return(&ret_err);

}



/****************************************************************************
*                                                                           *
*		Code for dev_add_data function                              *
*                        ------------                                       *
*                                                                           *
*    Function rule : To verify that the device from wich we want to store   *
*		     command results in the data buffer is defined for the  *
*		     data collector. If OK, store command results in the    *
*		     data buffer					    *
*                                                                           *
*    Argin : - A pointer to the structure which contains the device         *
*	     information (dev_dat type)					    *
*	     - A pointer to the error code				    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if no error occurs. Otherwise, this function   *
*    set the error code and returns -1					    *
*                                                                           *
*****************************************************************************/

int dev_add_data(dev_info,perr)
dev_dat *dev_info;
int *perr;
{
	char d_name[60];
	int resu;
	int ind;
	dc_dev_param data;
	long error;

/* Try to retrieve a record in the device_info part of the pointers area with
   the same device name */

	strcpy(d_name,dev_info->xdev_name);
	resu = search_dev(d_name,&data,&mem,&ind,&error);

	if (resu == -1) {

/* Search error */

		if (error != DcErr_DeviceNotInPtrsMemory ) {
#ifdef DEBUG
			printf("endf dev_add_data\n");
#endif /* DEBUG */
			 *perr = error;
			 return(-1);
							   }

/* Device does not exists in database */

		else {
			  *perr = DcErr_DeviceNotDefined;
			  return(-1);
		     }
			}

/* The device exists so, store new data in the data buffer */

	if (add_data(dev_info,&data,ind,perr))
		return(-1);
			
/* Leave function */

	return(0);
}




/****************************************************************************
*                                                                           *
*		Code for add_data function                                  *
*                        --------                                           *
*                                                                           *
*    Function rule : To store in the "data buffer" the command results for  *
*		     only one device					    *
*                                                                           *
*    Argin : - A pointer to the structure which contains the device         *
*	     information (dev_dat type)					    *
*	     - The address of the device information stucture		    * 
*	     - The indice of the device info in the pointers area array	    *
*	     - A pointer to the error code				    *
*                                                                           *
*    Argout : No argout                                                     *
*                                                                           *
*    This function returns 0 if no error occurs. Otherwise, this function   *
*    set the error code and returns -1					    *
*                                                                           *
*****************************************************************************/

int add_data(dev_info,pdata,ind,perr)
dev_dat *dev_info;
dc_dev_param *pdata;
int ind;
int *perr;
{
	unsigned int nb_cmd;
	char bad_cmd = False;
	int cmd;
	int i,j,k,l;
	int buf_size;
	cmd_sz cmd_info[MAX_CMD];
	int_level *int_array;
	struct timeval time;
	struct timezone tzone;
	unsigned int time_ten;
	unsigned int *ptr;
	cmd_dat *tmp_ptr;
	unsigned char *tmp_ptr1;
	dc_dev_param *array;
	long error;
	unsigned int *old_ptr;
	int old_ind;

/* Init pointer to itermediate level pointers buffer */

	array = (dc_dev_param *)addr_ptr;
	int_array = (int_level *)&array[mem.hash_table_size + mem.cellar_size];

/* Verify that the command number and command code are those defined in the
   data collector database */

	nb_cmd = dev_info->xcmd_dat.xcmd_dat_len;
	if (nb_cmd != pdata->nb_cmd) {
		*perr = DcErr_BadCmdNumber;
		return(-1);
				     }

	for (i = 0;i < nb_cmd;i++) {
		cmd = dev_info->xcmd_dat.xcmd_dat_val[i].xcmd;
		for (j = 0; j < pdata->nb_cmd;j++) {
			if (pdata->poll_cmd[j].cmd == cmd) {
				bad_cmd = False;
				break;
					     }
			else 
				bad_cmd = True;
				   }

		if (bad_cmd == True) {
			*perr = DcErr_CmdNotDefinedForDevice;
			return(-1);
				    }
		else
			continue;
				    }

/* Change command result size to be a multiple of four (Command results are
   stored by packet of 4 bytes) */

	for (i = 0;i < nb_cmd;i++) {
		if ((dev_info->xcmd_dat.xcmd_dat_val[i].xcmd_error != 0) &&
		    (((dev_info->xcmd_dat.xcmd_dat_val[i].xcmd_error >> DS_CAT_SHIFT ) & DS_CAT_MASK) != WarningError) ) {
			cmd_info[i].cmd = 0;
			cmd_info[i].extra = 4;
			cmd_info[i].nb_loop = 0;
									}
		else {
			cmd_info[i].cmd = dev_info->xcmd_dat.xcmd_dat_val[i].xsequence.xsequence_len;
			switch(cmd_info[i].cmd & 0x3) {
				case 0 : cmd_info[i].extra = 0;
					 break;

				case 1 : cmd_info[i].cmd = cmd_info[i].cmd + 3;
					 cmd_info[i].extra = 3;
					 break;

				case 2 : cmd_info[i].cmd = cmd_info[i].cmd + 2;
					 cmd_info[i].extra = 2;
					 break;

				case 3 : cmd_info[i].cmd = cmd_info[i].cmd + 1;
					 cmd_info[i].extra = 1;
					 break;
						 }
			cmd_info[i].nb_loop = (cmd_info[i].cmd >> 2) - 1;
			}
					  }

/* Compute buffer size */

	buf_size = BUF_HEADER_SIZE;
	for (i = 0;i < nb_cmd;i++)
		buf_size = buf_size + cmd_info[i].cmd + CMD_HEADER_SIZE;
	if ((buf_size & MASK_BLK_SIZE) != 0)	
		buf_size = (buf_size & 0xFFFFFFE0) + BLOC_SIZE;

/* Get UNIX time */

	gettimeofday(&time,&tzone);
	time_ten = ((time.tv_sec - TIME_OFF) * 10) + (time.tv_usec / 100000);

/* If intermediate level pointer is NULL, allocate memory (in the data buffer)
   for these new command results and init pointer */

	old_ptr = int_array[ind].data_buf[pdata->ind_write];
	if (old_ptr == NULL) {
		ptr = (unsigned int *)dcmem_alloc((unsigned char *)addr_data,
					(char *)addr_alloc,
				  	buf_size,ALLOC_SIZE,semid,&error);
		if (ptr == NULL) {
			*perr = DcErr_DatBufAllocError;
			return(-1);
			     }
		int_array[ind].data_buf[pdata->ind_write] = ptr;

/* Create the buffer in the data collector data buffer */

		ptr[0] = time_ten;
		ptr[1] = buf_size;
		i = 2;
		for (l = 0;l < nb_cmd;l++) {
			tmp_ptr = &(dev_info->xcmd_dat.xcmd_dat_val[l]);
			ptr[i] = tmp_ptr->xcmd;
			if (cmd_info[l].cmd == 0)
				ptr[i + 1] = 0;
			else
				ptr[i + 1] = (cmd_info[l].cmd) + (cmd_info[l].extra << 24);
			ptr[i + 2] = tmp_ptr->xcmd_error;
			i = i + 3;
			k = 0;
			tmp_ptr1 = (unsigned char *)tmp_ptr->xsequence.xsequence_val;
			for (j = 0;j < cmd_info[l].nb_loop;j++) {
#ifndef linux
				ptr[i + j] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8) + (tmp_ptr1[k + 3]);
#else
				ptr[i + j] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16) + (tmp_ptr1[k + 3] << 24);
#endif
				k = k + 4;
							}
			i = i + j;
			switch(cmd_info[l].extra) {
				case 0 : 
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8) + (tmp_ptr1[k + 3]);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16) + (tmp_ptr1[k + 3] << 24);
#endif
				break;

				case 1 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16);
#endif
				break;

				case 2 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8);
#endif
				break;

				case 3 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24);
#else
				ptr[i] = (tmp_ptr1[k]);
#endif
				break;

				case 4 :
				break;
						}
			if (cmd_info[l].cmd != 0)
				i++;
					   }
									}

	else {

/* Get data collector buffer size and compare it to actual buffer size */

		ptr = int_array[ind].data_buf[pdata->ind_write];
		if (ptr[1] != buf_size) {

/* Free the old buffer */

		if (dcmem_free((unsigned char *)addr_alloc,
			       (unsigned char *)addr_data,(unsigned char *)ptr,
				ptr[1],semid,&error)) {
			*perr = DcErr_CantFreeDataBuffer;
			return(-1);
								}

/* Allocate a new buffer with the right size */

		ptr = (unsigned int *)dcmem_alloc((unsigned char *)addr_data,
					(char *)addr_alloc,
				  	buf_size,ALLOC_SIZE,semid,&error);
			if (ptr == NULL) {
				*perr = DcErr_DatBufAllocError;
				return(-1);
				     }
			int_array[ind].data_buf[pdata->ind_write] = ptr;
			                }

/* Create the buffer in the data collector data buffer */

		ptr[0] = time_ten;
		ptr[1] = buf_size;
		i = 2;
		for (l = 0;l < nb_cmd;l++) {
			tmp_ptr = &(dev_info->xcmd_dat.xcmd_dat_val[l]);
			ptr[i] = tmp_ptr->xcmd;
			if (cmd_info[l].cmd == 0)
				ptr[i + 1] = 0;
			else
				ptr[i + 1] = (cmd_info[l].cmd) + (cmd_info[l].extra << 24);
			ptr[i + 2] = tmp_ptr->xcmd_error;
			i = i + 3;
			k = 0;
			tmp_ptr1 = (unsigned char *)tmp_ptr->xsequence.xsequence_val;
			for (j = 0;j < cmd_info[l].nb_loop;j++) {
#ifndef linux
				ptr[i + j] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8) + (tmp_ptr1[k + 3]);
#else
				ptr[i + j] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16) + (tmp_ptr1[k + 3] << 24);
#endif
				k = k + 4;
							}
			i = i + j;
			switch(cmd_info[l].extra) {
				case 0 : 
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8) + (tmp_ptr1[k + 3]);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16) + (tmp_ptr1[k + 3] << 24);
#endif
				break;

				case 1 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16) + (tmp_ptr1[k + 2] << 8);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8) + (tmp_ptr1[k + 2] << 16);
#endif
				break;

				case 2 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24) + (tmp_ptr1[k + 1] << 16);
#else
				ptr[i] = (tmp_ptr1[k]) + (tmp_ptr1[k + 1] << 8);
#endif
				break;

				case 3 :
#ifndef linux
				ptr[i] = (tmp_ptr1[k] << 24);
#else
				ptr[i] = (tmp_ptr1[k]);
#endif
				break;

				case 4 :
				break;
						}
			if (cmd_info[l].cmd != 0)
				i++;
					   }
	     }

/* Prepare the stucture used to update the device_info part of the data 
   collector (change read and write indexes and time)
   Don't forget that the read and write indexes must be managed as a circuler
   buffer indexes */

	old_ind = pdata->ind_write;
	if (pdata->ind_read == 0 && pdata->ind_write == 0) {
		pdata->ind_write++;
		if (pdata->ind_write == HIST)
			pdata->ind_write = 0;
							}
	else {
		pdata->ind_write++;
		if (pdata->ind_write == HIST)
			pdata->ind_write = 0;
		pdata->ind_read++;
		if (pdata->ind_read == HIST)
			pdata->ind_read = 0;
		}

/* For each command, update the command time in device_info part */

	for (i = 0;i < nb_cmd;i++) {
		cmd = dev_info->xcmd_dat.xcmd_dat_val[i].xcmd;
		for (j = 0;j < pdata->nb_cmd;j++) {
			if (cmd == pdata->poll_cmd[j].cmd)
				break;
						}
		pdata->poll_cmd[j].cmd_time = dev_info->xcmd_dat.xcmd_dat_val[i].xcmd_time;
				   }
	pdata->time = time_ten;

/* Update device record. If it fails, free the previously allocated memory
   and restore the old pointer in the pointers area. */

	if (update_dev(ind,pdata,&mem,&error)) {
		dcmem_free((unsigned char *)addr_alloc,(unsigned char*)addr_data,
			   (unsigned char *)ptr,buf_size,semid,&error);
		int_array[ind].data_buf[old_ind] = old_ptr;
		*perr = error;
		return(-1);
								}

/* Leave function */

	return(0);

}
