static char RcsId[]      =
"@(#)$Header: dev_states.c,v 4.28 98/12/22 10:08:49 taurel Exp $";

/*+*******************************************************************

 File:		dev_states.c

 Project:	Device Servers

 Description:	List of device states in text

 Author(s):	Andy Goetz

 Original:	March 1992

 $Log:	dev_states.c,v $
 * Revision 4.28  98/12/22  10:08:49  10:08:49  taurel (E.Taurel)
 * Added a "const" keyword.
 * 
 * Revision 4.27  97/10/14  15:38:57  15:38:57  meyer (Jens Meyer)
 * Added DEVSTANDBY_NOT_REACHED and DEVON_NOT_REACHED.
 * 
 * Revision 4.26  97/02/05  13:42:21  13:42:21  meyer (J.Meyer)
 * Added test for DEVDISABLED.
 * 
 * Revision 4.25  96/09/17  17:06:31  17:06:31  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 4.24  95/02/15  18:57:57  18:57:57  dserver ()
 * checked windows version: compiles wthout errors.
 * 
 * Revision 4.7  94/07/20  17:08:17  17:08:17  meyer (Jens Meyer)
 * Version with MSDOS include files.
 * The same version number as API-lib.
 * 
 * Revision 3.27  94/07/20  16:54:28  16:54:28  meyer (Jens Meyer)
 * Changed include file names for MSDOS.
 * 
 * Revision 3.26  93/12/23  14:03:54  14:03:54  chaize (Jean Michel Chaize)
 * added DEVALARM string .
 * 
 * Revision 3.25  93/09/24  17:26:46  17:26:46  meyer (Jens Meyer)
 * Release with error and command resources.
 * 
 * Revision 3.21  93/08/11  12:11:59  12:11:59  meyer (Jens Meyer)
 * Changed shift bits for Team Number and DS Identification.
 * 
 * Revision 3.20  93/08/05  18:39:00  18:39:00  meyer (Jens Meyer)
 * Database support for commands and errors.
 * 
 * Revision 3.5  93/02/19  17:29:09  17:29:09  epaud (Francis Epaud)
 * Add LECROY 1551 counter and CAEN V462 gate generator device servers
 * 
 * Revision 3.4  93/02/19  17:12:51  17:12:51  meyer
 * *** empty log message ***
 * 
 * Revision 3.3  92/09/03  15:36:40  15:36:40  meyer ()
 * added new states for LINAC.
 * 
 * Revision 3.2  92/08/13  13:49:24  13:49:24  meyer ()
 * corrected spelling error.
 * 
 * Revision 3.1  92/06/17  16:39:29  16:39:29  meyer ()
 * added states for LINAC device.
 * 
 * Revision 3.0  92/03/31  09:49:35  09:49:35  meyer ()
 * New major library release (3.x)
 * 
 * Revision 2.2  92/03/30  16:58:14  16:58:14  meyer ()
 * corrected the external definition of DEVSTATES.
 * 
 * Revision 2.1  92/03/25  17:19:50  17:19:50  meyer ()
 * New list of device states as C-file.
 * 

 Copyright (c) 1992 by European Synchrotron Radiation Facility, 
                       Grenoble, France

********************************************************************-*/
#include <macros.h>
#include <DevStates.h>

/*
 * a globally defined dictionary for known device states
 */

_DLLFunc const char 	*DEVSTATES[] = 	   { 
	"Unknown",

	"Off",
	"On",

	"Device is Close",
	"Device is Open",

	"Low",
	"High",

	"Inserted",
	"Extracted",
	"Moving",

	"Warmup",
	"Init",

	"Standby",
	"Service",
	"Run",

	"Local",
	"Remote",
	"Automatic",

	"Ramp",
	"Tripped",
	"High Voltage Enable",
	"Beam Enable",

	"Blocked",
	"Fault",

	"Starting",
	"Stopping",
	"Starting requested but not initialised",
	"Stopping requested but not initialised",

	"Positive End Stop",
	"Negative End Stop",

	"Bake requested but not started",
	"Bakeing",
	"Bake is stopping",

	"Device forced open",
	"Device forced close",

	"off, restarting not authorised",
	"on, temp. not regulated",
	"resetting",
	"Device is forbidden",
	"Device is opening",
	"Device is closing",
	"Device is in an undetermined state",
	"Device is counting",
	"Device has been stopped",
	"Device is running",
	"Alarm detected",
	"Externally disabled",

	"Standby not reached",
	"On not reached",
};

