
/*+*******************************************************************

 File:		API.h

 Project:	Device Servers with sun-rpc

 Description:	Public include for applications using
		the applications programmers interface.

 Author(s):	Jens Meyer

 Original:	January 1991


 $Revision: 8.20 $
 $Date: 2001/01/08 13:11:53 $

 $Author: goetz $

 $Log:	API.h,v $
 * Revision 8.20  2001/01/08  13:11:53  13:11:53  goetz (Andy Goetz)
 * added patch by B.Pedersen to support querying events
 * 
 Revision 8.31  2000/07/28 09:59:52  dserver
 BP: added dev_query_event to get event parameters
     -> new data struture  for event list in server
        events have to be registered by the server,
        similar to commands.

 Revision 8.19  2000/12/11 12:06:39  goetz
 fixed bugs with TANGO interface returning unsigned values and states

 Revision 8.18  2000/11/12 13:24:02  goetz
 added dynamic error handling; improved TANGO error treatment

 Revision 8.17  1900/09/26 13:36:28  goetz
 tango_dev_putget() and tango_dev_putget_raw() implement immediate reconnection

 * Revision 8.16  2000/09/25  14:50:15  14:50:15  goetz (Andy Goetz)
 * tango_api implements TANGO_HOST, stateless import and reimport
 * 
 * Revision 8.15  20/0./7.  1.:6.:9.  1.:6.:9.  goetz (Andy Goetz)
 * changed from tango database to host mysql, added support for float and double arrays
 * 
 * Revision 8.14  20/0./6.  2.:4.:0.  2.:4.:0.  goetz (Andy Goetz)
 * fixed bug in dev_event_listen() which caused server to crash
 * 
 Revision 8.13  2000/06/02 21:56:43  goetz
 _DEVICE_H now _TANGO_DEVICE_H in Device.H; (char*)taco_tango

 Revision 8.12  2000/06/02 15:58:02  goetz
 dev_event_fire() now device specific; ported to SuSE V6.4

 Revision 8.11  2000/05/31 07:47:48  goetz
 tango_api has local copies of argc and argv, ported to HP-UX

 * Revision 8.10  2000/05/29  21:39:14  21:39:14  goetz (Andrew GOETZ)
 * fixed prototyping problems with C++ on HP-UX
 * 
 * Revision 8.9  2000/05/29  18:13:25  18:13:25  goetz (Andrew GOETZ)
 * fixed bug in dev_import_timeout() which prevented timeouts < 2s
 * 
 Revision 8.8  2000/05/02 15:32:08  goetz
 added prototype for tsleep() for OS9 C++

 * Revision 8.7  2000/05/02  14:19:00  14:19:00  goetz (Andy Goetz)
 * removed check for device server running on different host
 * 
 * Revision 8.6  2000/05/02  13:28:10  13:28:10  goetz (Andy Goetz)
 * added random sleep to gettransient + 3 retries
 * 
 Revision 8.5  2000/03/27 17:13:44  goetz
 declared pmap_getmaps() as external C function for OS9 C++

 Revision 8.4  2000/03/13 14:50:01  goetz
 import timeout now programmable using dev_import_timeout()

 Revision 8.3  2000/03/13 10:31:34  goetz
 added Jens' modifications to fix bug in local putget

 Revision 8.2  2000/03/10 17:01:22  goetz
 dev_synch() now excludes udp clients and new imports

 Revision 8.1  2000/01/18 16:48:42  goetz
 tango_dev_import() now only called in dev_import if -DTANGO

 Revision 8.0  1999/12/28 14:18:30  goetz
 added TANGO support for TACO dev_xxx() calls via -DTANGO for C++

 Revision 7.10  1999/11/25 08:27:12  goetz
 replaced fprintf(stderr) with printf; made startup() C++ compatible

 Revision 7.9  1999/11/22 20:18:59  goetz
 removed const from gettransient() prototype

 Revision 7.8  1999/11/21 20:45:37  goetz
 included all M.Diehl's patches (major changes to gettransient() + main())

 Revision 7.7  1999/11/18 22:28:55  goetz
 fixed event multi-client bug, free client handle after event_listen, timeout in dev_synch()

 Revision 7.6  1999/11/01 19:05:16  goetz
 make local copy of user name returned by getpwuid() in sec_api.c

 Revision 7.5  1999/08/06 17:44:06  goetz
 removed usage of varargs for g++ on solaris and hpux

 Revision 7.4  1999/07/09 05:15:27  goetz
 added M.Diehl's patch to DevServerSig.c to exit() after calling unregister_server()

 Revision 7.3  1999/06/07 15:26:55  goetz
 fixed bug with multi-nethost reimport, device name stored with nethost

 Revision 7.2  1999/05/12 15:21:54  goetz
 changed dev_event_fire() to void; fixed bug in dev_event_unlisten()

 * Revision 7.1  99/05/11  15:59:42  15:59:42  goetz (Andy Goetz)
 * replace static declaration of event_client[] array by malloc()
 * 
 Revision 7.0  1999/04/26 07:30:36  goetz
 implemented user events (added event_api.c)

 Revision 6.15  1999/03/27 09:00:14  goetz
 asynch_cleanup() only checks for asynch clients; C++ returns output arguments if DS_WARNING

 * Revision 6.14  99/02/27  15:21:14  15:21:14  goetz (Andy Goetz)
 * fixed reimport bug; disabled reimport for rpc version 1
 * 
 Revision 6.13  1999/02/05 00:50:21  goetz
 fixed reimport socket+memory leak; ported to aCC on HPUX; suppressed rpc errors

 * Revision 6.12  99/01/18  21:38:57  21:38:57  goetz (Andy Goetz)
 * suppressed test for RPC_TIMEDOUT in svc_check()
 * 
 * Revision 6.11  99/01/14  23:14:47  23:14:47  goetz (Andy Goetz)
 * dbase timeout = 4 s; unregister ver. 1; svc_check() handles RPC_TIMEDOUT
 * 
 * Revision 6.10  98/12/22  10:29:40  10:29:40  taurel (E.Taurel)
 * Added support for Solaris and HP C++ native compiler. Remove K_R C support
 * 
 * Revision 6.9  98/12/15  14:04:56  14:04:56  goetz (Andy Goetz)
 * unregister RPC; use pgm no. 1 as flag; dev_pending() checks timeout; extern C prototype
 * 
 * Revision 6.8  98/11/20  14:35:31  14:35:31  goetz (Andy Goetz)
 * unregister API_VERSION (4) correctly now + check return value of svc_register()
 * 
 * Revision 6.7  98/11/20  10:34:56  10:34:56  goetz (Andy Goetz)
 * improved gettrans_ut(); multi-config_flags=0; removde static client_data; fixed linux select() bug; only register pgm # 0,4,5; portmap address == 111
 * 
 * Revision 6.6  98/09/24  09:25:06  09:25:06  goetz (Andy Goetz)
 * fixed stupid type which reintroduced asynchronous memory leak
 * 
 * Revision 6.5  98/08/26  16:20:31  16:20:31  goetz (Andy Goetz)
 * added dynamic NETHOST allocation, fixed bug in db_setup_multi, ported to Irix 6.4
 * 
 * Revision 6.4  98/04/29  10:21:19  10:21:19  goetz (Andy Goetz)
 * asynchronous - memory leak fixed, OS9 bug fixed, stale handle cleanup, pending=300
 * 
 * Revision 6.3  97/12/10  15:28:29  15:28:29  meyer (J.Meyer)
 * Changed select() timeout in rpc_check_host() to 200ms
 * 
 * Revision 6.2  97/12/01  12:59:11  12:59:11  goetz (Andy Goetz)
 * intermediate checkin before opening 5.14.1 branch
 * 
 * Revision 6.1  97/11/20  21:49:21  21:49:21  goetz (Andy Goetz)
 * main() continue even if cannot register asynch rpc
 * 
 * Revision 6.0  97/11/03  17:22:22  17:22:22  goetz (Andy Goetz)
 * merged synchronous and asynchronous branches
 * 

 Copyright (c) 1990-1997 by European Synchrotron Radiation Facility, 
                            Grenoble, France

********************************************************************-*/

#ifndef _api_h
#define _api_h

/*
 *  standart header string to use "what" or "ident".
 */
#ifdef _IDENT
static char APIh[] =
"@(#)$Header: API.h,v 8.20 2001/01/08 13:11:53 goetz Rel $";
#endif /* _IDENT */

/*
 * RedHat 5.0 of Linux needs this otherwise it has missing types
 * when it comes to the RPC part e.g. caddr_t
#ifdef linux
#include <linux/types.h>
#endif
 */

/*
 * Include system commands and states.
 */
#include <macros.h>
#include <DevCmds.h>
#include <DevStates.h>

/*
 * xdr library include file
 */
#include <DevXdrKernel.h>

/*
 * database library include file
 */
#include <db_setup.h>

/*
 * Definition of some constants
 */

#define MAX_NAME_LENGTH LONG_NAME_SIZE 	/* maximum length of name fields */
#define MIN_NETHOST 	10		/* minimum number of NETHOSTs */

/*
 * Definitions for the states of the startup configuration
 * flag.
 */

#define SERVER_STARTUP                        (-1)

/*
 * Definitions for available protocols
 */

#define D_TCP	888
#define D_UDP	999
#define D_IIOP	1111

/*
 * definitions needed by asynchronous call (should be in macros.h)
 */

#define DS_PENDING 3

/*
 *  Structure for the administration of open RPC connections.
 */

typedef struct _server_connections {
	char            server_host[SHORT_NAME_SIZE];
	long            prog_number;
	long            vers_number;
	CLIENT          *clnt;
	_Int            no_conns;
	/* indicates already detected RPC problems */
	long            rpc_error_flag;
	/* number of times the connection was reestablished */
	_Int            rpc_conn_counter;
	/* indicates the RPC connection status */
	long            rpc_conn_status;
	/* indicates the RPC protocol */
	long            rpc_protocol;
	int             tcp_socket;
	/* timeout for RPC connection */
	struct timeval  rpc_timeout;
	struct timeval  rpc_retry_timeout;
	/* time stamp for delay time of VME access after a reboot */
	time_t          first_access_time;
	/* for the security system with single user connections! */
	long		open_si_connections;
	long		rpc_protocol_before_si;
	/* copy of UDP client handle for synchronous calls */
	CLIENT         	*udp_clnt;
	/* copy of TCP client handle for synchronous calls */
	CLIENT         	*tcp_clnt;
	/* client handle for asynchronous calls */
	CLIENT		*asynch_clnt; 
	/* flag for asynchonous queue flushing */
	DevBoolean     	flushed; 
	/* number of asynchronous requests with reply still pending */
	long		pending; 
	/* timeout for asynchronous requests */
	struct timeval 	asynch_timeout;
	int		asynch_listen_tcp_socket;
	int		asynch_callback_tcp_socket;
	 } server_connections;

/*
 * type returned by a successful dev_import call, is used in all
 * subsequent calls to the api_lib for this device
 */

typedef struct _devserver {
	char        device_name[LONG_NAME_SIZE];
	char        device_class[SHORT_NAME_SIZE];
	char        device_type[SHORT_NAME_SIZE];
	char        server_name[LONG_NAME_SIZE];
	char        server_host[SHORT_NAME_SIZE];
	long        prog_number;
	long        vers_number;
	CLIENT      *clnt;
	long        ds_id;
	_Int        no_svr_conn;
	_Int	    rpc_conn_counter;
	long	    dev_access;
	long        i_nethost;
	long        rpc_protocol;
	struct timeval rpc_timeout;
	CLIENT      *asynch_clnt;
	struct timeval asynch_timeout;
	long        pending;
	} *devserver;


/*
 * structures for a dev_cmd_query() call
 */

typedef struct {
	long    cmd;
	char    cmd_name [SHORT_NAME_SIZE];
	char	*in_name;
	long    in_type;
	char	*out_name;
	long    out_type;
	} DevCmdInfo;

typedef struct {
	u_int          	length;
	DevCmdInfo 	*sequence;
	} DevVarCmdArray;

/*
 * structures for a dev_event_query() call
 */

typedef struct {
	long    event;
	char    event_name [SHORT_NAME_SIZE];
	char	*out_name;
	long    out_type;
	} DevEventInfo;

typedef struct {
	u_int          	length;
	DevEventInfo 	*sequence;
	} DevVarEventArray;


/*
 * structures for a dev_inform() call
 */
typedef struct {
	char    device_name[LONG_NAME_SIZE];
	char    device_class[SHORT_NAME_SIZE];
	char    device_type[SHORT_NAME_SIZE];
	char    server_name[LONG_NAME_SIZE];
	char    server_host[SHORT_NAME_SIZE];
	} DevInfo;

/*
 * structures for dev_putget_asyn() call
 */
typedef struct _DevCallbackData { 	long asynch_id;
					DevArgument argout;
					DevType argout_type;
					long status;
					long error;
					struct timeval time; }
		DevCallbackData;

typedef void (*DevCallbackFunction(devserver, void*, DevCallbackData));


/*
 * modes for dev_printerror, dev_printerror_no, dev_printdiag !
 */

#define CLEAR		0
#define WRITE		1
#define SEND      	2


/*
 * data collector library include file
 */
#include <dc.h>

#if !defined(_NT)
 /*
 * HDB library include file
 */
#include <hdb_out.h>
#endif

/*
 *  Function definitions for API-library
 */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
extern _DLLFunc long  dev_import
				PT_( (char *dev_name, long access,
				devserver *ds_ptr, long *error) );
extern _DLLFunc long  dev_putget
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				DevArgument argout, DevType argout_type,
				long *error) );
extern _DLLFunc long  dev_put
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				long *error) );
extern _DLLFunc long  dev_putget_raw
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				DevOpaque *argout,  DevType argout_type,
				long *error) );
extern _DLLFunc long  dev_put_asyn
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				long *error) );
extern _DLLFunc long  dev_free
				PT_( (devserver ds, long *error) );
extern _DLLFunc long  dev_xdrfree
				PT_( (DevType type, DevArgument objptr,
				long *error) );
extern _DLLFunc long  dev_cmd_query
				PT_( (devserver ds, DevVarCmdArray *varcmdarr,
				long *error) );
extern _DLLFunc long  dev_event_query
				PT_( (devserver ds, DevVarEventArray *vareventarr,
				long *error) );
extern _DLLFunc long  dev_inform
				PT_( (devserver *clnt_handles, long num_devices,
				DevInfo * *dev_info, long *error) );
extern _DLLFunc long  dev_rpc_protocol
				PT_( (devserver ds, long protocol,
				long *error) );
extern _DLLFunc long  dev_rpc_timeout
				PT_( (devserver ds, long request,
				struct timeval *timeout, long *error) );
extern _DLLFunc long  dev_ping
				PT_( (devserver ds, long *error) );
extern _DLLFunc long  dev_import_timeout
				PT_( (long request, struct timeval *timeout, 
				long *error) );



extern _DLLFunc long   db_import
				PT_( (long *error) );
extern _DLLFunc long   msg_import
				PT_( (char *DS_name, char *DS_host,
				long DS_prog_number, char *DS_display,
				long *error) );
extern _DLLFunc char * dev_error_str
				PT_( (long dev_errno) );
extern _DLLFunc void  dev_printerror_no
				PT_( (short mode, char *comment,
				long dev_errno) );
extern _DLLFunc long  dev_putget_asyn
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				DevArgument argout, DevType argout_type,
				DevCallbackFunction *callback, void *user_data,
				long *asynch_id, long *error) );

extern _DLLFunc long  dev_putget_raw_asyn
				PT_( (devserver ds, long cmd,
				DevArgument argin,  DevType argin_type,
				DevArgument argout, DevType argout_type,
				DevCallbackFunction *callback, void *user_data,
				long *asynch_id, long *error) );

extern _DLLFunc long dev_asynch_timeout 
				PT_( (devserver ds, long request,
				struct timeval *dev_timeout, long *error) );

extern _DLLFunc long dev_event_listen 
				PT_( (devserver ds, long event_type,
				DevArgument argout, DevType argout_type,
				DevCallbackFunction *callback, void *user_data,
				long *event_id, long *error) );

extern _DLLFunc long dev_event_unlisten 
				PT_( (devserver ds, long event_type,
				long event_id, long *error) );

extern _DLLFunc long dev_synch PT_( (struct timeval *timeout, long *error) );

extern _DLLFunc long dev_pending PT_( (devserver) );

#ifdef __cplusplus
}
#endif /* __cplusplus */

extern _DLLFunc long debug_flag;	/* global that is used in gen_api.c */

/*
 * For these functions, ANSI prtotyping is in
 * todays form not possible, because their
 * functionality base on type conversion for
 * input arguments.
 */
/* 
 * adding ANSI C support for function with variable argument lists
 *
 * - andy , 13sep94
 */
#if defined (__STDC__) || (__STDCPP__)
#ifdef __cplusplus
extern "C" {
#endif
#if (!defined _GNU_PP)
extern _DLLFunc void  dev_printerror	PT_( (DevShort mode, char *var_args, ...) );
extern _DLLFunc void  dev_printdebug	PT_( (long mode, char *var_args, ...) );
extern _DLLFunc void  dev_printdiag	PT_( (DevShort mode, char *var_args, ...) );
#else
extern _DLLFunc void  dev_printerror	(DevShort mode,char *fmt, char *str);
extern _DLLFunc void  dev_printdebug	();
extern _DLLFunc void  dev_printdiag	();
#endif
#ifdef __cplusplus
}
#endif /* __cplusplus */
#else /* STDC */
extern _DLLFunc void  dev_printerror();
extern _DLLFunc void  dev_printdebug();
extern _DLLFunc void  dev_printdiag();
#endif /* __STDC__ */

/* global variable containing dynamic error string */

extern char *dev_error_string;

#endif /* _api_h */

