/*static char RcsId[] = "$Header: DSSignalP.h,v 5.9 99/08/20 17:31:16 pons Exp $";*/

/*********************************************************************
 *
 * File:	DSSignalP.h
 *
 * Project:	SRRF3 control system
 *
 * Description:	A class to specify signal properties.
 *
 * Author(s):	J.Meyer
 *
 * Original:	June 1996	
 *
 * $Log:	DSSignalP.h,v $
 * Revision 5.9  99/08/20  17:31:16  17:31:16  pons ()
 * Multi Nethost support
 * 
 * Revision 5.8  99/02/12  14:35:33  14:35:33  pons ()
 * Add management of NaN value
 * 
 * Revision 5.7  99/02/05  16:53:46  16:53:46  pons ()
 * Correction
 * 
 * Revision 5.6  99/02/04  17:39:20  17:39:20  pons ()
 * Add a SIG_RES_NAME string array for the fast implementation of dev_get_sig_config
 * /
 * 
 * Revision 5.5  98/11/18  13:07:53  13:07:53  meyer (J.Meyer)
 * Dynamic allocation of description and alarm message.
 * 
 * Revision 5.3  97/12/05  10:03:42  10:03:42  meyer (J.Meyer)
 * Added DevMethodeDestroy to the class
 * 
 * Revision 5.2  97/07/09  14:10:00  14:10:00  meyer (J.Meyer)
 * Corrected memory allocation in object_initialise()
 * 
 * Revision 5.1  97/07/01  10:54:03  10:54:03  beteva (A.Beteva)
 * correct free of string array in object_initialise
 * 
 * Revision 5.0  97/02/18  17:14:29  17:14:29  meyer (J.Meyer)
 * Added the multiplier value for standard units.
 * 
 * Revision 4.4  97/02/18  16:04:52  16:04:52  pons ()
 * Added alarm on difference between read and nominal value.
 * 
 * Revision 4.3  97/01/28  18:20:27  18:20:27  meyer (J.Meyer)
 * Changed class initialisation.
 * 
 * Revision 4.1  97/01/14  14:11:55  14:11:55  pons ()
 * new alarm concept added.
 * 
 * 
 * Revision 4.0  96/10/22  08:28:21  08:28:21  meyer (J.Meyer)
 * First release.
 * 
 * 
 * Copyright (c) 1996 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *********************************************************************/

#ifndef _DSSignalP_H
#define _DSSignalP_H

#include <CntrlDsNumbers.h>

/*
 * Define the methods of the signal class
 */

#define DevMethodReadProperties		DevSignalBase + 1
#define DevMethodCheckAlarm		DevSignalBase + 2
#define DevMethodReadAlarm		DevSignalBase + 3
#define DevMethodCheckLimits		DevSignalBase + 4 
#define DevMethodSignalReset		DevSignalBase + 5


#define NUMBER_OF_RES		11	

typedef struct _DssignalClassPart
{
   	int		none;
} DssignalClassPart;



typedef struct _DssignalPart
{
	char	*label;
	char	*unit;
	char	*format;
	char	*description;
	char    *alarm_high;
	double 	alarm_high_value;
	char  	*alarm_low;
	double  alarm_low_value;
	char  	*max_limit;
	double  max_limit_value;
	char	*min_limit;
	double	min_limit_value;
	char	*dev_class_name;
	long	delta_time_value;
	char	*delta_time;
	double	delta_value;
	char	*delta;
	long	last_set_time;
	double	last_set_value;
	char	*last_alarm_msg;
	char	*std_unit_multiplier;
	double	std_unit_multiplier_value;
} DssignalPart;



typedef struct _DssignalClassRec
{
   	DevServerClassPart	devserver_class;
   	DssignalClassPart	dssignal_class;
} DssignalClassRec;



extern DssignalClassRec dssignalClassRec;


typedef struct _DssignalRec
{
   	DevServerPart 		devserver;
   	DssignalPart 		dssignal;
} DssignalRec;


typedef struct _DssignalClassRec *DssignalClass;
typedef struct _DssignalRec *Dssignal;

extern DssignalClass dssignalClass;

void  load_NaN(void *v);
int  Is_NaN(void *v);

#endif /*_DSSignalP_H*/
