static char RcsId[] = "@(#)$Header: /segfs/dbase/res/clnt/RCS/setacc_clnt.c,v 6.12 2001/01/08 13:29:17 goetz Rel $";

/*+*******************************************************************

 File       :   setacc_clnt.c

 Project    :   Static database

 Description:   Application Programmers Interface

            :   Stub routines for calling remote procedures in static
	        database server.

	    :   This code was originally generated using "rpcgen"

 Author(s)  :   Emmanuel Taurel

 Original   :   January 1991

 * $Log: setacc_clnt.c,v $
 * Revision 6.12  2001/01/08 13:29:17  goetz
 * added J.Quick's patch to support double arrays for resources
 *
 * Revision 6.11  2001/01/08 11:46:14  goetz
 * added patch by B.Pedersen to support querying events
 *
 * Revision 6.10  2000/06/22 19:18:05  goetz
 * added support for D_USHORT_TYPE and D_ULONG_TYPE
 *
 * Revision 6.9  1999/07/08 15:44:27  goetz
 * added J.Quick's patch to fix reconnection bug on Linux
 *
 * Revision 6.8  1999/06/07 15:48:13  goetz
 * replace name with name_copy in db_dev_import()
 *
 * Revision 6.7  1999/02/22 17:17:22  taurel
 * Fix another bug in reconnection. This bug increases open f. for db_putresource and db_getresource
 *
 * Revision 6.6  99/02/04  12:51:20  12:51:20  taurel (E.Taurel)
 * Add a clnt_destroy in reconnect function to avoid mem. and open file leak
 * 
 * Revision 6.5  98/12/01  13:26:50  13:26:50  taurel (E.Taurel)
 * Added call to init resource cache
 * 
 * Revision 6.4  98/10/26  16:33:47  16:33:47  taurel (E.Taurel)
 * Fix a bug in the db_delreslist call (setacc_cli.c file)
 * 
 * Revision 6.3  98/10/12  16:10:37  16:10:37  taurel (E.Taurel)
 * Added a new call db_delreslist. Reconnection in its own file. Fix miscellaneous small bugs
 * 
 * Revision 6.2  98/09/01  16:21:22  16:21:22  taurel (E.Taurel)
 * Adapted to any number of nethost
 * 
 * Revision 6.1  98/08/21  08:51:57  08:51:57  taurel (E.Taurel)
 * Fix a little bug in tools_cli.c file.
 * 
 * Revision 6.0  98/08/14  08:55:03  08:55:03  taurel (E.Taurel)
 * Added many calls to server in order to have all utilities server oriented
 * 
 * Revision 5.15  97/12/01  15:36:01  15:36:01  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 5.10  97/08/07  10:04:37  10:04:37  goetz (Andy Goetz)
 * ported to VxWorks
 * 
 * Revision 5.9  1997/01/07 15:36:46  goetz
 * Ported to Linux (2.0.9)
 *
 * Revision 5.8  1996/11/26 10:12:55  taurel
 * Fix a bug in the arg. checking in the db_getresource function.
 *
 * Revision 5.7  96/11/22  17:42:02  17:42:02  taurel (E.Taurel)
 * Adapted to new release of setup_config
 * 
 * Revision 5.6  96/11/21  14:59:06  14:59:06  taurel (E.Taurel)
 * Fix_bug_in_db_reconnection_and_in_multi_nethost_implementatio
 * 
 * Revision 5.5  96/11/21  13:11:42  13:11:42  taurel (E.Taurel)
 * Fix bug in db reconnection and in the multi nethost implementation
 * of db_getresource
 * 
 * Revision 5.4  96/11/04  13:51:19  13:51:19  goetz (Andy Goetz)
 * added
 * 
 * Revision 5.3  96/10/21  15:53:40  15:53:40  taurel (E.Taurel)
 * Checked in after port to Windows NT
 * 
 * Revision 5.2  96/09/17  17:25:45  17:25:45  klotz (W.D. Klotz)
 * WD Klotz: checked NT build
 * 
 * Revision 5.1  96/06/06  08:49:25  08:49:25  taurel (E.Taurel)
 * Clarify ifdef definition for the PC port.
 * 
 * Revision 4.6  96/06/05  10:46:32  10:46:32  taurel (E.Taurel)
 * Change for db software release 5.
 * 
 * Revision 4.5  96/01/05  15:32:23  15:32:23  taurel (Emmanuel TAUREL)
 * Ported to Solaris2 in compatibility mode.
 * 
 * Revision 4.4  95/02/01  14:23:17  14:23:17  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.3  94/09/29  09:26:18  09:26:18  taurel (Emmanuel TAUREL)
 * First check-in for PC port.
 *  
 *-*******************************************************************/

#include <macros.h>
#include <db_setup.h>
#include <db_xdr.h>

#if defined(_NT)
#include <nm_rpc.h>
#else
#include <rpc/rpc.h>
#endif

#include <time.h>
#include <DevErrors.h>


#ifndef NULL
#define NULL  0
#endif  /* NULL */


/* Added for the db_freedevexp function */
extern int func_ptr;
extern devexp_res *tab_clstu;
/* End of added definition */

static struct timeval TimeOut = { 3, 0 };

db_res
#if defined __STDC__ | defined __STDCPP__
* db_getres_1(arr1 *argp, CLIENT *clnt, long *perr)
#else
*db_getres_1(argp, clnt, perr)
	arr1 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRES, (xdrproc_t)xdr_arr1, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


db_res
#if defined __STDC__ | defined __STDCPP__
* db_getdev_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_getdev_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETDEV, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_devexp_2(tab_dbdev_2 *argp, CLIENT *clnt, long *perr)
#else
*db_devexp_2(argp, clnt, perr)
	tab_dbdev_2 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVEXP, (xdrproc_t)xdr_tab_dbdev_2, 
	                      (caddr_t)argp, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_devexp_3(tab_dbdev_3 *argp, CLIENT *clnt, long *perr)
#else
*db_devexp_3(argp, clnt, perr)
	tab_dbdev_3 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVEXP, (xdrproc_t)xdr_tab_dbdev_3, 
	                      (caddr_t)argp, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}




db_resimp
#if defined __STDC__ | defined __STDCPP__
* db_devimp_1(arr1 *argp, CLIENT *clnt, long *perr)
#else
*db_devimp_1(argp, clnt, perr)
	arr1 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_resimp res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVIMP, (xdrproc_t)xdr_arr1, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_resimp, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_svcunr_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_svcunr_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SVCUNR, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


svc_inf
#if defined __STDC__ | defined __STDCPP__
* db_svcchk_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_svcchk_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static svc_inf res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SVCCHK, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_svc_inf, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


/* Some changes have been made to this function:
	To give to the user the possibily to free the allocated memory,
	it is necessary to store the returned structure in an array.
	The memory needed for this array is allocated in the setacc_cli.c
        file. */

db_res
#if defined __STDC__ | defined __STDCPP__
* db_getdevexp_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_getdevexp_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	enum clnt_stat clnt_stat;

	clnt_stat = clnt_call(clnt, DB_GETDEVEXP, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&(tab_clstu[func_ptr].res), 
	                      TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&(tab_clstu[func_ptr].res));
}


int
#if defined __STDC__ | defined __STDCPP__
* db_clodb_1(CLIENT *clnt, long *perr)
#else
*db_clodb_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_CLODB, (xdrproc_t)xdr_void, 
	                      NULL, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_reopendb_1(CLIENT *clnt, long *perr)
#else
*db_reopendb_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_REOPENDB, (xdrproc_t)xdr_void, 
	                      NULL, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_putres_1(tab_putres *argp, CLIENT *clnt, long *perr)
#else
*db_putres_1(argp, clnt, perr)
	tab_putres *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_PUTRES, (xdrproc_t)xdr_tab_putres, 
                              (caddr_t)argp, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


int
#if defined __STDC__ | defined __STDCPP__
* db_delres_1(arr1 *argp, CLIENT *clnt, long *perr)
#else
*db_delres_1(argp, clnt, perr)
	arr1 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static int res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DELRES, (xdrproc_t)xdr_arr1, 
	                      (caddr_t)argp, (xdrproc_t)xdr_int, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


cmd_que
#if defined __STDC__ | defined __STDCPP__
* db_cmd_query_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_cmd_query_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static cmd_que res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_CMDQUERY, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_cmd_que, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

/*event query function */
event_que
#if defined __STDC__ | defined __STDCPP__
* db_event_query_1(nam *argp, CLIENT *clnt, long *perr)
#else
*db_event_query_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static event_que res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_EVENTQUERY, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_event_que, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}
/*end event query */


db_psdev_error
#if defined __STDC__ | defined __STDCPP__
* db_psdev_reg_1(psdev_reg_x *argp, CLIENT *clnt, long *perr)
#else
*db_psdev_reg_1(argp, clnt, perr)
	ps_dev_reg_x *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_psdev_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_PSDEV_REG, (xdrproc_t)xdr_psdev_reg_x, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_psdev_error, 
	                      (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



db_psdev_error
#if defined __STDC__ | defined __STDCPP__
* db_psdev_unreg_1(arr1 *argp, CLIENT *clnt, long *perr)
#else
*db_psdev_unreg_1(argp, clnt, perr)
	arr1 *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_psdev_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_PSDEV_UNREG, (xdrproc_t)xdr_arr1, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_psdev_error, 
	                      (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getdevdomain_1(CLIENT *clnt, long *perr)
#else
db_res *db_getdevfamily_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETDEVDOMAIN, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getdevfamily_1(nam *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getdevfamily_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETDEVFAMILY, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getdevmember_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getdevmember_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETDEVMEMBER, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getresdomain_1(CLIENT *clnt, long *perr)
#else
db_res *db_getresdomain_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRESDOMAIN, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getresfamily_1(nam *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getresfamily_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRESFAMILY, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getresmember_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getresmember_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRESMEMBER, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getresreso_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getresreso_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRESRESO, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getresresoval_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getresresoval_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETRESRESOVAL, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getdsserver_1(CLIENT *clnt, long *perr)
#else
db_res *db_getdsserver_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETSERVER, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_getdspers_1(nam *argp, CLIENT *clnt, long *perr)
#else
db_res *db_getdspers_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETPERS, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}

#if defined __STDC__ | defined __STDCPP__
db_res *db_gethost_1(CLIENT *clnt, long *perr)
#else
db_res *db_gethost_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETHOST, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_devinfo_svc *db_deviceinfo_1(nam *argp,CLIENT *clnt, long *perr)
#else
db_devinfo_svc *db_deviceinfo_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_devinfo_svc res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVINFO, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_devinfo_svc, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_res *db_deviceres_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_res *db_deviceres_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVRES, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



#if defined __STDC__ | defined __STDCPP__
long *db_devicedelete_1(nam *argp, CLIENT *clnt, long *perr)
#else
long *db_devicedelete_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static long res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVDEL, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_long, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_psdev_error *db_devicedeleteres_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_psdev_error *db_devicedeleteres_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_psdev_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEVDELALLRES, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_psdev_error, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_info_svc *db_stat_1(CLIENT *clnt, long *perr)
#else
db_info_svc *db_stat_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_info_svc res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_INFO, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_info_svc, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
long *db_servunreg_1(db_res *argp, CLIENT *clnt, long *perr)
#else
long *db_servunreg_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static long res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SVCUNREG, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_long, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



#if defined __STDC__ | defined __STDCPP__
svcinfo_svc *db_servinfo_1(db_res *argp, CLIENT *clnt, long *perr)
#else
svcinfo_svc *db_servinfo_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static svcinfo_svc res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SVCINFO, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_svcinfo_svc, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
long *db_servdelete_1(db_res *argp, CLIENT *clnt, long *perr)
#else
long *db_servdelete_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static long res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SVCDELETE, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_long, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



#if defined __STDC__ | defined __STDCPP__
db_psdev_error *db_upddev_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_psdev_error *db_upddev_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_psdev_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_UPDDEV, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_psdev_error, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_psdev_error *db_updres_1(db_res *argp, CLIENT *clnt, long *perr)
#else
db_psdev_error *db_updres_1(argp, clnt, perr)
	db_res *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_psdev_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_UPDRES, (xdrproc_t)xdr_db_res, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_psdev_error, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



#if defined __STDC__ | defined __STDCPP__
db_res *db_secpass_1(CLIENT *clnt, long *perr)
#else
db_res *db_secpass_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_res res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_SECPASS, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_db_res, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_poller_svc *db_getpoll_1(nam *argp, CLIENT *clnt, long *perr)
#else
db_poller_svc *db_getpoll_1(clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_poller_svc res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETPOLLER, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_poller_svc, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_delupd_error *db_delete_update_1(db_arr1_array *argp, CLIENT *clnt, long *perr)
#else
db_delupd_error *db_delete_update_1(clnt, perr)
	db_arr1_array *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_delupd_error res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_DEL_UPDATE, (xdrproc_t)xdr_db_arr1_array, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_delupd_error, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}



#if defined __STDC__ | defined __STDCPP__
long *db_initcache_1(nam *argp, CLIENT *clnt, long *perr)
#else
long *db_initcache_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static long res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_INITCACHE, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_long, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
db_svcarray_net *db_getdsonhost_1(nam *argp, CLIENT *clnt, long *perr)
#else
db_svcarray_net *db_getdsonhost_1(argp, clnt, perr)
	nam *argp;
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	static db_svcarray_net res;
	enum clnt_stat clnt_stat;

	memset((void *)&res, 0, sizeof(res));

	clnt_stat = clnt_call(clnt, DB_GETDSHOST, (xdrproc_t)xdr_nam, 
	                      (caddr_t)argp, (xdrproc_t)xdr_db_svcarray_net, 
		              (caddr_t)&res, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (NULL);
	}
	return (&res);
}


#if defined __STDC__ | defined __STDCPP__
long db_null_proc_1(CLIENT *clnt, long *perr)
#else
long db_null_proc_1(clnt, perr)
	CLIENT *clnt;
	long *perr;
#endif	/* __STDC__ */
{
	enum clnt_stat clnt_stat;

	clnt_stat = clnt_call(clnt,NULLPROC, (xdrproc_t)xdr_void, 
	                      (caddr_t)NULL, (xdrproc_t)xdr_void, 
		              (caddr_t)NULL, TIMEVAL(TimeOut));

	if (clnt_stat != RPC_SUCCESS)
	{
		if (clnt_stat == RPC_TIMEDOUT)
			*perr = DevErr_RPCTimedOut;
		else if (clnt_stat == RPC_CANTENCODEARGS)
			*perr = DbErr_CannotEncodeArguments;
		else if (clnt_stat == RPC_CANTDECODERES)
			*perr = DbErr_CannotDecodeResult;
		else
			*perr = DbErr_RPCreception;
		return (-1);
	}
	return (0);
}
