static char RcsId[] =
"@(#)$Header: /segfs/dserver/dev/system/xdr/src/RCS/ws_xdr.c,v 5.18 1999/07/08 14:10:46 goetz Rel $";

/*+*******************************************************************

 File:          ws_xdr.c

 Project:       Device Servers with sun-rpc

 Description:   xdr_routines for Wire Scanner data types.

 Author(s):	Jens Meyer

 Original:	July 1992

$Revision: 5.18 $
$Date: 1999/07/08 14:10:46 $

$Author: goetz $

$Log: ws_xdr.c,v $
Revision 5.18  1999/07/08 14:10:46  goetz
changed _LPfd_set type for Linux in macros.h

Revision 5.17  1998/05/25 17:59:40  klotz
fixed C++ prototypes in api_xdr.h

Revision 5.16  1998/04/29 10:24:02  goetz
macros.h - added __STDCPP__ for HP C++ compiler (aCC)

 * Revision 5.15  97/12/01  15:16:53  15:16:53  klotz (W.D. Klotz)
 * WIN_NT_95_released_NOV_97
 * 
 * Revision 4.34  97/01/30  13:58:37  13:58:37  goetz (Andy Goetz)
 * removed dev_printdebug() from DevXdrKernel.h
 * 
 * Revision 4.33  97/01/09  10:08:42  10:08:42  goetz (Andy Goetz)
 * (xdrproc_t) castings added to maxe_xdr, ram_xdr, thc_xdr, seism_xdr
 * 
 * Revision 4.32  97/01/08  16:48:31  16:48:31  goetz (Andy Goetz)
 * Ported to Linux (2.0.9)
 * 
Revision 4.31  1996/11/18 17:28:48  goetz
Check

 * Revision 4.28  96/10/21  16:22:23  16:22:23  taurel (E.Taurel)
 * Check_in_after_port_to_OS9/ISP_2.1_and_OS9/RPC1.4
 * 
 * Revision 4.27  96/09/17  16:40:28  16:40:28  klotz (W.D. Klotz)
 * WD Klotz: tested NT build  
 * 
 * Revision 4.26  96/07/19  10:01:01  10:01:01  taurel (E.Taurel)
 * Some_change_in_macros.h_for_the_API_port_to_OS-9_Ultra_C++
 * 
 * Revision 4.25  96/06/07  16:23:05  16:23:05  meyer (J.Meyer)
 * Corrected_elif_to_else_in_macros.h
 * 
 * Revision 4.24  96/06/05  15:01:40  15:01:40  meyer (J.Meyer)
 * Corrected_macros.h
 * 
 * Revision 4.23  96/06/03  13:10:18  13:10:18  meyer (J.Meyer)
 * Cleaned-up_MSDOS_and_added_porting_options_for_Windows_NT.
 * 
 * Revision 4.22  96/05/23  11:07:27  11:07:27  taurel (E.Taurel)
 * Added_some_definitions_for_C++_in_API_xdr.h_file
 * 
 * Revision 4.21  96/05/06  18:37:37  18:37:37  meyer (J.Meyer)
 * Fortran_compatibility_for:_dev_xdr.h,macros.h,maxe_xdr.h
 * 
 * Revision 4.20  96/02/27  13:31:37  13:31:37  meyer (J.Meyer)
 * Deleted_Cross_References_To_DSAPI_Library
 * 
 * Revision 4.19  96/01/11  17:40:22  17:40:22  meyer (Jens Meyer)
 * Added_#define_PORTMAP_to_macros.h.
 * 
 * Revision 4.18  95/12/21  10:33:32  10:33:32  meyer (Jens Meyer)
 * Corrected length calculation for D_VAR_MSTATARR.
 * 
 * Revision 4.17  95/08/02  16:05:14  16:05:14  meyer (Jens Meyer)
 * Corrected DevXdrKernel.h after C++ implementation.
 * 
 * Revision 4.15  95/03/02  10:27:54  10:27:54  meyer (Jens Meyer)
 * Added D_VAR_SFRPARR type to the kernel.
 * 
 * Revision 4.14  95/02/20  09:56:44  09:56:44  meyer (Jens Meyer)
 * Passed the compilers for HPUX, SUNOS and UCC after the first windows check in.
 * 
 * Revision 4.13  95/02/10  17:19:00  17:19:00  meyer (Jens Meyer)
 * Deleted
 * 
 * Revision 4.12  95/02/01  14:27:12  14:27:12  klotz (W.D. Klotz)
 * WDK: first successfull compile of dbase, api, xdr on WIN16/3.1
 * 
 * Revision 4.11  95/01/03  13:19:21  13:19:21  meyer (Jens Meyer)
 * Repared bug in dev_cmd_query() for version 3!
 * 
 * Revision 4.10  94/12/08  15:24:53  15:24:53  meyer (Jens Meyer)
 * Changed _manager_data in API_xdr and added old version to API_xdr_vers3.
 * 
 * Revision 4.9  94/11/28  17:04:14  17:04:14  meyer (Jens Meyer)
 * Data types for compatibility with library version 3.x
 * 
 * Revision 4.8  94/08/16  16:59:31  16:59:31  meyer (Jens Meyer)
 * Corrected error in ws_xdr.h
 * 
 * Revision 4.7  94/08/16  16:34:27  16:34:27  meyer (Jens Meyer)
 * Added define for MAX_RESOURCE_FIELD_LENGTH to macros.h
 * 
 * Revision 4.6  94/08/12  15:07:42  15:07:42  meyer (Jens Meyer)
 * Added valriable arguments to all API RPC structures.
 * 
 * Revision 4.5  94/07/20  18:15:42  18:15:42  meyer (Jens Meyer)
 * Changed include files in macros.h!
 * 
 * Revision 4.4  94/07/20  08:56:02  08:56:02  meyer (Jens Meyer)
 * All XDR functions with prototypes!
 * 
 * Revision 4.3  94/07/18  18:50:51  18:50:51  meyer (Jens Meyer)
 * Had to change macros.h, because #define must be in the first column!
 * 
 * Revision 4.2  94/07/18  18:22:29  18:22:29  meyer (Jens Meyer)
 * First test with PC macros for the XDR kernel.
 * 
 * Revision 4.1  94/05/02  10:50:45  10:50:45  meyer (Jens Meyer)
 * For Security System without connection count.
 * 
 * Revision 4.0  94/03/14  18:17:30  18:17:30  meyer (Jens Meyer)
 * Library version with Security System.
 * 
 * Revision 3.50  94/03/12  14:36:23  14:36:23  meyer (Jens Meyer)
 * Changed API xdr structures for security.
 * 
 * Revision 3.35  94/03/03  10:52:07  10:52:07  taurel (Emmanuel TAUREL)
 * Added unsigned long array type in the XDRkernel
 * 
 * Revision 3.34  94/03/03  10:29:00  10:29:00  taurel (Emmanuel TAUREL)
 * Added the unsigned long array type in
 * XDR kernel (LC and ET).
 * 
 * Revision 3.33  94/01/12  16:34:22  16:34:22  meyer (Jens Meyer)
 * Global XDR type array for data collector access
 * 
 * Revision 3.31  93/12/02  09:38:56  09:38:56  meyer (Jens Meyer)
 * New release with small XDR data type kernel.
 * 
 * Revision 1.1  93/12/01  15:31:00  15:31:00  meyer (Jens Meyer)
 * Initial revision
 * 

 Copyright (c) 1990 by European Synchrotron Radiation Facility,
		       Grenoble, France

*******************************************************************-*/


#include <dev_xdr.h>
#include <ws_xdr.h>


/*
 *  xdr_routines for wire scanner types
 */

bool_t
xdr_DevWsBeamFitParm(xdrs, objp)
	XDR *xdrs;
	DevWsBeamFitParm *objp;
{
	if (!xdr_DevVarFloatArray(xdrs, &objp->pos_array)) {
		return (FALSE);
	}
	if (!xdr_DevVarFloatArray(xdrs, &objp->meas_array)) {
		return (FALSE);
	}
	if (!xdr_DevVarFloatArray(xdrs, &objp->perc_array)) {
		return (FALSE);
	}
	if (!xdr_short(xdrs, &objp->mode)) {
		return (FALSE);
	}
	return (TRUE);
}


